/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.buffer.BufferSubgraph;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J,\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0002J&\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/buffer/SubgraphDepthLocater;", "", "subgraphs", "", "Lorg/locationtech/jts/operation/buffer/BufferSubgraph;", "<init>", "(Ljava/util/List;)V", "", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "getDepth", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "findStabbedSegments", "Lorg/locationtech/jts/operation/buffer/SubgraphDepthLocater$DepthSegment;", "stabbingRayLeftPt", "", "dirEdges", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "stabbedSegments", "dirEdge", "DepthSegment", "kts-core"})
public final class SubgraphDepthLocater {
    @NotNull
    private final Collection<?> subgraphs;
    @NotNull
    private final LineSegment seg;

    public SubgraphDepthLocater(@NotNull List<BufferSubgraph> subgraphs) {
        Intrinsics.checkNotNullParameter(subgraphs, (String)"subgraphs");
        this.seg = new LineSegment(null, null, 3, null);
        this.subgraphs = subgraphs;
    }

    public final int getDepth(@Nullable Coordinate p) {
        List<DepthSegment> stabbedSegments = this.findStabbedSegments(p);
        if (stabbedSegments.size() == 0) {
            return 0;
        }
        DepthSegment ds = (DepthSegment)CollectionsKt.minOrThrow((Iterable)stabbedSegments);
        return ds.getLeftDepth();
    }

    private final List<DepthSegment> findStabbedSegments(Coordinate stabbingRayLeftPt) {
        List stabbedSegments = new ArrayList();
        for (Object obj : this.subgraphs) {
            Envelope env;
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.buffer.BufferSubgraph");
            BufferSubgraph bsg = (BufferSubgraph)obj;
            Intrinsics.checkNotNull((Object)bsg.getEnvelope());
            Coordinate coordinate = stabbingRayLeftPt;
            Intrinsics.checkNotNull((Object)coordinate);
            if (coordinate.y < env.getMinY() || stabbingRayLeftPt.y > env.getMaxY()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, bsg.getDirectedEdges(), (List<DepthSegment>)stabbedSegments);
        }
        return stabbedSegments;
    }

    private final void findStabbedSegments(Coordinate stabbingRayLeftPt, List<DirectedEdge> dirEdges, List<DepthSegment> stabbedSegments) {
        Iterator<DirectedEdge> i = dirEdges.iterator();
        while (i.hasNext()) {
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            if (!de.isForward()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, de, stabbedSegments);
        }
    }

    private final void findStabbedSegments(Coordinate stabbingRayLeftPt, DirectedEdge dirEdge, List<DepthSegment> stabbedSegments) {
        Coordinate[] pts = dirEdge.getEdge().getCoordinates();
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            double maxx;
            this.seg.p0 = pts[i];
            this.seg.p1 = pts[i + 1];
            if (this.seg.p0.y > this.seg.p1.y) {
                this.seg.reverse();
            }
            if ((maxx = Math.INSTANCE.max(this.seg.p0.x, this.seg.p1.x)) < stabbingRayLeftPt.x || this.seg.isHorizontal() || stabbingRayLeftPt.y < this.seg.p0.y || stabbingRayLeftPt.y > this.seg.p1.y || Orientation.index(this.seg.p0, this.seg.p1, stabbingRayLeftPt) == -1) continue;
            int depth = dirEdge.getDepth(1);
            if (!Intrinsics.areEqual((Object)this.seg.p0, (Object)pts[i])) {
                depth = dirEdge.getDepth(2);
            }
            DepthSegment ds = new DepthSegment(this.seg, depth);
            stabbedSegments.add(ds);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/operation/buffer/SubgraphDepthLocater$DepthSegment;", "", "", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "depth", "", "<init>", "(Lorg/locationtech/jts/geom/LineSegment;I)V", "upwardSeg", "leftDepth", "getLeftDepth", "()I", "compareTo", "obj", "compareX", "seg0", "seg1", "toString", "", "kts-core"})
    public static final class DepthSegment
    implements Comparable<Object> {
        @NotNull
        private final LineSegment upwardSeg;
        private final int leftDepth;

        public DepthSegment(@Nullable LineSegment seg, int depth) {
            LineSegment lineSegment = seg;
            Intrinsics.checkNotNull((Object)lineSegment);
            this.upwardSeg = new LineSegment(lineSegment);
            this.leftDepth = depth;
        }

        public final int getLeftDepth() {
            return this.leftDepth;
        }

        @Override
        public int compareTo(@Nullable Object obj) {
            Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.buffer.SubgraphDepthLocater.DepthSegment");
            DepthSegment other = (DepthSegment)obj;
            if (this.upwardSeg.minX() >= other.upwardSeg.maxX()) {
                return 1;
            }
            if (this.upwardSeg.maxX() <= other.upwardSeg.minX()) {
                return -1;
            }
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            orientIndex = -1 * other.upwardSeg.orientationIndex(this.upwardSeg);
            return orientIndex != 0 ? orientIndex : this.upwardSeg.compareTo(other.upwardSeg);
        }

        private final int compareX(LineSegment seg0, LineSegment seg1) {
            int compare0 = seg0.p0.compareTo(seg1.p0);
            return compare0 != 0 ? compare0 : seg0.p1.compareTo(seg1.p1);
        }

        @NotNull
        public String toString() {
            return this.upwardSeg.toString();
        }
    }
}

