/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.distance.DistanceOp;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\"\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020\u0005H\u0002J \u0010$\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lorg/locationtech/jts/operation/buffer/validate/BufferDistanceValidator;", "", "input", "Lorg/locationtech/jts/geom/Geometry;", "bufDistance", "", "result", "<init>", "(Lorg/locationtech/jts/geom/Geometry;DLorg/locationtech/jts/geom/Geometry;)V", "minValidDistance", "maxValidDistance", "minDistanceFound", "maxDistanceFound", "isValid", "", "value", "", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "Lorg/locationtech/jts/geom/Coordinate;", "errorLocation", "getErrorLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "errorIndicator", "getErrorIndicator", "()Lorg/locationtech/jts/geom/Geometry;", "checkPositiveValid", "", "checkNegativeValid", "getPolygonLines", "g", "checkMinimumDistance", "g1", "g2", "minDist", "checkMaximumDistance", "bufCurve", "maxDist", "Companion", "kts-core"})
public final class BufferDistanceValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry input;
    private final double bufDistance;
    @NotNull
    private final Geometry result;
    private double minValidDistance;
    private double maxValidDistance;
    private double minDistanceFound;
    private double maxDistanceFound;
    private boolean isValid;
    @Nullable
    private String errorMessage;
    @Nullable
    private Coordinate errorLocation;
    @Nullable
    private Geometry errorIndicator;
    private static final boolean VERBOSE = false;
    private static final double MAX_DISTANCE_DIFF_FRAC = 0.012;

    public BufferDistanceValidator(@NotNull Geometry input, double bufDistance, @NotNull Geometry result2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.input = input;
        this.bufDistance = bufDistance;
        this.result = result2;
        this.isValid = true;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public final Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    @Nullable
    public final Geometry getErrorIndicator() {
        return this.errorIndicator;
    }

    public final boolean isValid() {
        double posDistance = Math.INSTANCE.abs(this.bufDistance);
        double distDelta = 0.012 * posDistance;
        this.minValidDistance = posDistance - distDelta;
        this.maxValidDistance = posDistance + distDelta;
        if (this.input.isEmpty() || this.result.isEmpty()) {
            return true;
        }
        if (this.bufDistance > 0.0) {
            this.checkPositiveValid();
        } else {
            this.checkNegativeValid();
        }
        return this.isValid;
    }

    private final void checkPositiveValid() {
        Geometry bufCurve = this.result.getBoundary();
        this.checkMinimumDistance(this.input, bufCurve, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        Geometry geometry = bufCurve;
        Intrinsics.checkNotNull((Object)geometry);
        this.checkMaximumDistance(this.input, geometry, this.maxValidDistance);
    }

    private final void checkNegativeValid() {
        if (!(this.input instanceof Polygon || this.input instanceof MultiPolygon || this.input instanceof GeometryCollection)) {
            return;
        }
        Geometry inputCurve = this.getPolygonLines(this.input);
        this.checkMinimumDistance(inputCurve, this.result, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(inputCurve, this.result, this.maxValidDistance);
    }

    private final Geometry getPolygonLines(Geometry g) {
        List lines = new ArrayList();
        LinearComponentExtracter lineExtracter = new LinearComponentExtracter(lines);
        List<Polygon> polys = PolygonExtracter.Companion.getPolygons(g);
        Iterator<Polygon> i = polys.iterator();
        while (i.hasNext()) {
            Polygon poly;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            poly.apply(lineExtracter);
        }
        return g.getFactory().buildGeometry(lines);
    }

    private final void checkMinimumDistance(Geometry g1, Geometry g2, double minDist) {
        Geometry geometry = g2;
        Intrinsics.checkNotNull((Object)geometry);
        DistanceOp distOp = new DistanceOp(g1, geometry, minDist);
        this.minDistanceFound = distOp.distance();
        if (this.minDistanceFound < minDist) {
            this.isValid = false;
            Object[] pts = distOp.nearestPoints();
            this.errorLocation = distOp.nearestPoints()[1];
            this.errorIndicator = g1.getFactory().createLineString((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
            Object object = pts[0];
            Intrinsics.checkNotNull((Object)object);
            Object object2 = pts[1];
            Intrinsics.checkNotNull((Object)object2);
            this.errorMessage = "Distance between buffer curve and input is too small (" + this.minDistanceFound + " at " + WKTWriter.Companion.toLineString((Coordinate)object, (Coordinate)object2) + " )";
        }
    }

    private final void checkMaximumDistance(Geometry input, Geometry bufCurve, double maxDist) {
        DiscreteHausdorffDistance haus = new DiscreteHausdorffDistance(bufCurve, input);
        haus.setDensifyFraction(0.25);
        this.maxDistanceFound = haus.orientedDistance();
        if (this.maxDistanceFound > maxDist) {
            this.isValid = false;
            Coordinate[] pts = haus.getCoordinates();
            this.errorLocation = pts[1];
            this.errorIndicator = input.getFactory().createLineString(pts);
            this.errorMessage = "Distance between buffer curve and input is too large (" + this.maxDistanceFound + " at " + WKTWriter.Companion.toLineString(pts[0], pts[1]) + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/operation/buffer/validate/BufferDistanceValidator$Companion;", "", "<init>", "()V", "VERBOSE", "", "MAX_DISTANCE_DIFF_FRAC", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

