/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.validate.BufferDistanceValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/buffer/validate/BufferResultValidator;", "", "input", "Lorg/locationtech/jts/geom/Geometry;", "distance", "", "result", "<init>", "(Lorg/locationtech/jts/geom/Geometry;DLorg/locationtech/jts/geom/Geometry;)V", "isValid", "", "value", "", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "Lorg/locationtech/jts/geom/Coordinate;", "errorLocation", "getErrorLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "errorIndicator", "getErrorIndicator", "()Lorg/locationtech/jts/geom/Geometry;", "report", "", "checkName", "checkPolygonal", "checkExpectedEmpty", "checkEnvelope", "checkArea", "checkDistance", "Companion", "kts-core"})
public final class BufferResultValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry input;
    private final double distance;
    @NotNull
    private final Geometry result;
    private boolean isValid;
    @Nullable
    private String errorMessage;
    @Nullable
    private Coordinate errorLocation;
    @Nullable
    private Geometry errorIndicator;
    private static final boolean VERBOSE = false;
    private static final double MAX_ENV_DIFF_FRAC = 0.012;

    public BufferResultValidator(@NotNull Geometry input, double distance, @NotNull Geometry result2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.input = input;
        this.distance = distance;
        this.result = result2;
        this.isValid = true;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public final Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    @Nullable
    public final Geometry getErrorIndicator() {
        return this.errorIndicator;
    }

    public final boolean isValid() {
        this.checkPolygonal();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkExpectedEmpty();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkEnvelope();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkArea();
        if (!this.isValid) {
            return this.isValid;
        }
        this.checkDistance();
        return this.isValid;
    }

    private final void report(String checkName) {
    }

    private final void checkPolygonal() {
        if (!(this.result instanceof Polygon) && !(this.result instanceof MultiPolygon)) {
            this.isValid = false;
        }
        this.errorMessage = "Result is not polygonal";
        this.errorIndicator = this.result;
        this.report("Polygonal");
    }

    private final void checkExpectedEmpty() {
        if (this.input.getDimension() >= 2) {
            return;
        }
        if (this.distance > 0.0) {
            return;
        }
        if (!this.result.isEmpty()) {
            this.isValid = false;
            this.errorMessage = "Result is non-empty";
            this.errorIndicator = this.result;
        }
        this.report("ExpectedEmpty");
    }

    private final void checkEnvelope() {
        if (this.distance < 0.0) {
            return;
        }
        double padding = this.distance * 0.012;
        if (padding == 0.0) {
            padding = 0.001;
        }
        Envelope expectedEnv = new Envelope(this.input.getEnvelopeInternal());
        expectedEnv.expandBy(this.distance);
        Envelope bufEnv = new Envelope(this.result.getEnvelopeInternal());
        bufEnv.expandBy(padding);
        if (!bufEnv.contains(expectedEnv)) {
            this.isValid = false;
            this.errorMessage = "Buffer envelope is incorrect";
            this.errorIndicator = this.input.getFactory().toGeometry(bufEnv);
        }
        this.report("Envelope");
    }

    private final void checkArea() {
        double inputArea = this.input.getArea();
        double resultArea = this.result.getArea();
        if (this.distance > 0.0 && inputArea > resultArea) {
            this.isValid = false;
            this.errorMessage = "Area of positive buffer is smaller than input";
            this.errorIndicator = this.result;
        }
        if (this.distance < 0.0 && inputArea < resultArea) {
            this.isValid = false;
            this.errorMessage = "Area of negative buffer is larger than input";
            this.errorIndicator = this.result;
        }
        this.report("Area");
    }

    private final void checkDistance() {
        BufferDistanceValidator distValid = new BufferDistanceValidator(this.input, this.distance, this.result);
        if (!distValid.isValid()) {
            this.isValid = false;
            this.errorMessage = distValid.getErrorMessage();
            this.errorLocation = distValid.getErrorLocation();
            this.errorIndicator = distValid.getErrorIndicator();
        }
        this.report("Distance");
    }

    @JvmStatic
    public static final boolean isValid(@NotNull Geometry g, double distance, @NotNull Geometry result2) {
        return Companion.isValid(g, distance, result2);
    }

    @JvmStatic
    @Nullable
    public static final String isValidMsg(@NotNull Geometry g, double distance, @NotNull Geometry result2) {
        return Companion.isValidMsg(g, distance, result2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/buffer/validate/BufferResultValidator$Companion;", "", "<init>", "()V", "VERBOSE", "", "MAX_ENV_DIFF_FRAC", "", "isValid", "g", "Lorg/locationtech/jts/geom/Geometry;", "distance", "result", "isValidMsg", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isValid(@NotNull Geometry g, double distance, @NotNull Geometry result2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            BufferResultValidator validator = new BufferResultValidator(g, distance, result2);
            return validator.isValid();
        }

        @JvmStatic
        @Nullable
        public final String isValidMsg(@NotNull Geometry g, double distance, @NotNull Geometry result2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            BufferResultValidator validator = new BufferResultValidator(g, distance, result2);
            return !validator.isValid() ? validator.getErrorMessage() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

