/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.PointExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.operation.distance.ConnectedElementLocationFilter;
import org.locationtech.jts.operation.distance.GeometryLocation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0001BB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0006J\u0013\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\fH\u0007\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J%\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010'J5\u0010#\u001a\u00020\u001d2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030)2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010+J-\u0010#\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001dH\u0002J5\u00101\u001a\u00020\u001d2\n\u00102\u001a\u0006\u0012\u0002\b\u00030)2\n\u00103\u001a\u0006\u0012\u0002\b\u00030)2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010+J5\u00104\u001a\u00020\u001d2\n\u00105\u001a\u0006\u0012\u0002\b\u00030)2\n\u00106\u001a\u0006\u0012\u0002\b\u00030)2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010+J5\u00107\u001a\u00020\u001d2\n\u00108\u001a\u0006\u0012\u0002\b\u00030)2\n\u00109\u001a\u0006\u0012\u0002\b\u00030)2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010+J-\u0010\"\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010=J-\u0010\"\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0002\u00a2\u0006\u0002\u0010AR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/locationtech/jts/operation/distance/DistanceOp;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "terminateDistance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;D)V", "getTerminateDistance", "()D", "geom", "", "[Lorg/locationtech/jts/geom/Geometry;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "minDistanceLocation", "Lorg/locationtech/jts/operation/distance/GeometryLocation;", "[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "minDistance", "distance", "nearestPoints", "Lorg/locationtech/jts/geom/Coordinate;", "()[Lorg/locationtech/jts/geom/Coordinate;", "closestPoints", "nearestLocations", "()[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "closestLocations", "updateMinDistance", "", "locGeom", "flip", "", "([Lorg/locationtech/jts/operation/distance/GeometryLocation;Z)V", "computeMinDistance", "computeContainmentDistance", "polyGeomIndex", "", "locPtPoly", "(I[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "locs", "", "polys", "(Ljava/util/List;Ljava/util/List;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "ptLoc", "poly", "Lorg/locationtech/jts/geom/Polygon;", "(Lorg/locationtech/jts/operation/distance/GeometryLocation;Lorg/locationtech/jts/geom/Polygon;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "computeFacetDistance", "computeMinDistanceLines", "lines0", "lines1", "computeMinDistancePoints", "points0", "points1", "computeMinDistanceLinesPoints", "lines", "points", "line0", "Lorg/locationtech/jts/geom/LineString;", "line1", "(Lorg/locationtech/jts/geom/LineString;Lorg/locationtech/jts/geom/LineString;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "line", "pt", "Lorg/locationtech/jts/geom/Point;", "(Lorg/locationtech/jts/geom/LineString;Lorg/locationtech/jts/geom/Point;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nDistanceOp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistanceOp.kt\norg/locationtech/jts/operation/distance/DistanceOp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
public final class DistanceOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double terminateDistance;
    @NotNull
    private final Geometry[] geom;
    @NotNull
    private final PointLocator ptLocator;
    @Nullable
    private GeometryLocation[] minDistanceLocation;
    private double minDistance;

    @JvmOverloads
    public DistanceOp(@NotNull Geometry g0, @NotNull Geometry g1, double terminateDistance) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.terminateDistance = terminateDistance;
        Geometry[] geometryArray = new Geometry[]{g0, g1};
        this.geom = geometryArray;
        this.ptLocator = new PointLocator();
        this.minDistance = Double.MAX_VALUE;
    }

    public /* synthetic */ DistanceOp(Geometry geometry, Geometry geometry2, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        this(geometry, geometry2, d);
    }

    public final double getTerminateDistance() {
        return this.terminateDistance;
    }

    public final double distance() {
        if (!(this.geom[0] != null && this.geom[1] != null)) {
            boolean bl = false;
            String string = "null geometries are not supported";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.geom[0].isEmpty() || this.geom[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance;
    }

    @NotNull
    public final Coordinate[] nearestPoints() {
        this.computeMinDistance();
        Coordinate[] coordinateArray = new Coordinate[2];
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        GeometryLocation geometryLocation = this.minDistanceLocation[0];
        Intrinsics.checkNotNull((Object)geometryLocation);
        coordinateArray[0] = geometryLocation.getCoordinate();
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        GeometryLocation geometryLocation2 = this.minDistanceLocation[1];
        Intrinsics.checkNotNull((Object)geometryLocation2);
        coordinateArray[1] = geometryLocation2.getCoordinate();
        return coordinateArray;
    }

    @Deprecated(message="renamed to nearestPoints")
    @NotNull
    public final Coordinate[] closestPoints() {
        return this.nearestPoints();
    }

    @Nullable
    public final GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    @Deprecated(message="renamed to nearestLocations")
    @Nullable
    public final GeometryLocation[] closestLocations() {
        return this.nearestLocations();
    }

    private final void updateMinDistance(GeometryLocation[] locGeom, boolean flip) {
        if (locGeom[0] == null) {
            return;
        }
        if (flip) {
            Intrinsics.checkNotNull((Object)this.minDistanceLocation);
            this.minDistanceLocation[0] = locGeom[1];
            Intrinsics.checkNotNull((Object)this.minDistanceLocation);
            this.minDistanceLocation[1] = locGeom[0];
        } else {
            Intrinsics.checkNotNull((Object)this.minDistanceLocation);
            this.minDistanceLocation[0] = locGeom[0];
            Intrinsics.checkNotNull((Object)this.minDistanceLocation);
            this.minDistanceLocation[1] = locGeom[1];
        }
    }

    private final void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        this.computeContainmentDistance();
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeFacetDistance();
    }

    private final void computeContainmentDistance() {
        GeometryLocation[] locPtPoly = new GeometryLocation[2];
        this.computeContainmentDistance(0, locPtPoly);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeContainmentDistance(1, locPtPoly);
    }

    private final void computeContainmentDistance(int polyGeomIndex, GeometryLocation[] locPtPoly) {
        Geometry polyGeom = this.geom[polyGeomIndex];
        if (polyGeom.getDimension() < 2) {
            return;
        }
        int locationsIndex = 1 - polyGeomIndex;
        List<Polygon> polys = PolygonExtracter.Companion.getPolygons(polyGeom);
        if (!((Collection)polys).isEmpty()) {
            List<GeometryLocation> insideLocs = ConnectedElementLocationFilter.Companion.getLocations(this.geom[locationsIndex]);
            this.computeContainmentDistance(insideLocs, polys, locPtPoly);
            if (this.minDistance <= this.terminateDistance) {
                Intrinsics.checkNotNull((Object)this.minDistanceLocation);
                this.minDistanceLocation[locationsIndex] = locPtPoly[0];
                Intrinsics.checkNotNull((Object)this.minDistanceLocation);
                this.minDistanceLocation[polyGeomIndex] = locPtPoly[1];
                return;
            }
        }
    }

    private final void computeContainmentDistance(List<?> locs, List<?> polys, GeometryLocation[] locPtPoly) {
        int n = ((Collection)locs).size();
        for (int i = 0; i < n; ++i) {
            Object obj = locs.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.GeometryLocation");
            GeometryLocation loc = (GeometryLocation)obj;
            int n2 = ((Collection)polys).size();
            for (int j = 0; j < n2; ++j) {
                Object obj2 = polys.get(j);
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                this.computeContainmentDistance(loc, (Polygon)obj2, locPtPoly);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private final void computeContainmentDistance(GeometryLocation ptLoc, Polygon poly, GeometryLocation[] locPtPoly) {
        Coordinate pt;
        Coordinate coordinate = pt = ptLoc.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        if (2 != this.ptLocator.locate(coordinate, poly)) {
            this.minDistance = 0.0;
            locPtPoly[0] = ptLoc;
            locPtPoly[1] = new GeometryLocation(poly, pt);
            return;
        }
    }

    private final void computeFacetDistance() {
        GeometryLocation[] locGeom = new GeometryLocation[2];
        List<Geometry> lines0 = LinearComponentExtracter.Companion.getLines(this.geom[0]);
        List<Geometry> lines1 = LinearComponentExtracter.Companion.getLines(this.geom[1]);
        List<Point> pts0 = PointExtracter.Companion.getPoints(this.geom[0]);
        List<Point> pts1 = PointExtracter.Companion.getPoints(this.geom[1]);
        this.computeMinDistanceLines(lines0, lines1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines1, pts0, locGeom);
        this.updateMinDistance(locGeom, true);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistancePoints(pts0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
    }

    private final void computeMinDistanceLines(List<?> lines0, List<?> lines1, GeometryLocation[] locGeom) {
        int n = ((Collection)lines0).size();
        for (int i = 0; i < n; ++i) {
            Object obj = lines0.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line0 = (LineString)obj;
            int n2 = ((Collection)lines1).size();
            for (int j = 0; j < n2; ++j) {
                Object obj2 = lines1.get(j);
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line1 = (LineString)obj2;
                this.computeMinDistance(line0, line1, locGeom);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private final void computeMinDistancePoints(List<?> points0, List<?> points1, GeometryLocation[] locGeom) {
        int n = ((Collection)points0).size();
        for (int i = 0; i < n; ++i) {
            Object obj = points0.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt0 = (Point)obj;
            int n2 = ((Collection)points1).size();
            for (int j = 0; j < n2; ++j) {
                Object obj2 = points1.get(j);
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                Point pt1 = (Point)obj2;
                Coordinate coordinate = pt0.getCoordinate();
                Intrinsics.checkNotNull((Object)coordinate);
                Coordinate coordinate2 = pt1.getCoordinate();
                Intrinsics.checkNotNull((Object)coordinate2);
                double dist = coordinate.distance(coordinate2);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    locGeom[0] = new GeometryLocation(pt0, 0, pt0.getCoordinate());
                    locGeom[1] = new GeometryLocation(pt1, 0, pt1.getCoordinate());
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private final void computeMinDistanceLinesPoints(List<?> lines, List<?> points, GeometryLocation[] locGeom) {
        int n = ((Collection)lines).size();
        for (int i = 0; i < n; ++i) {
            Object obj = lines.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)obj;
            int n2 = ((Collection)points).size();
            for (int j = 0; j < n2; ++j) {
                Object obj2 = points.get(j);
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                Point pt = (Point)obj2;
                this.computeMinDistance(line, pt, locGeom);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private final void computeMinDistance(LineString line0, LineString line1, GeometryLocation[] locGeom) {
        if (line0.getEnvelopeInternal().distance(line1.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line0.getCoordinates();
        Coordinate[] coord1 = line1.getCoordinates();
        int n = coord0.length - 1;
        for (int i = 0; i < n; ++i) {
            Envelope segEnv0 = new Envelope(coord0[i], coord0[i + 1]);
            if (segEnv0.distance(line1.getEnvelopeInternal()) > this.minDistance) continue;
            int n2 = coord1.length - 1;
            for (int j = 0; j < n2; ++j) {
                Envelope segEnv1 = new Envelope(coord1[j], coord1[j + 1]);
                if (segEnv0.distance(segEnv1) > this.minDistance) continue;
                double dist = Distance.segmentToSegment(coord0[i], coord0[i + 1], coord1[j], coord1[j + 1]);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    LineSegment seg0 = new LineSegment(coord0[i], coord0[i + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j], coord1[j + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    locGeom[0] = new GeometryLocation(line0, i, closestPt[0]);
                    locGeom[1] = new GeometryLocation(line1, j, closestPt[1]);
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private final void computeMinDistance(LineString line, Point pt, GeometryLocation[] locGeom) {
        if (line.getEnvelopeInternal().distance(pt.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line.getCoordinates();
        Coordinate coord = pt.getCoordinate();
        int n = coord0.length - 1;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull((Object)coordinate);
            double dist = Distance.pointToSegment(coordinate, coord0[i], coord0[i + 1]);
            if (dist < this.minDistance) {
                this.minDistance = dist;
                LineSegment seg = new LineSegment(coord0[i], coord0[i + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                locGeom[0] = new GeometryLocation(line, i, segClosestPoint);
                locGeom[1] = new GeometryLocation(pt, 0, coord);
            }
            if (!(this.minDistance <= this.terminateDistance)) continue;
            return;
        }
    }

    @JvmOverloads
    public DistanceOp(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this(g0, g1, 0.0, 4, null);
    }

    @JvmStatic
    public static final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
        return Companion.distance(g0, g1);
    }

    @JvmStatic
    @NotNull
    public static final Coordinate[] nearestPoints(@NotNull Geometry g0, @NotNull Geometry g1) {
        return Companion.nearestPoints(g0, g1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J%\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/operation/distance/DistanceOp$Companion;", "", "<init>", "()V", "distance", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "isWithinDistance", "", "nearestPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "closestPoints", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DistanceOp distOp = new DistanceOp(g0, g1, 0.0, 4, null);
            return distOp.distance();
        }

        public final boolean isWithinDistance(@NotNull Geometry g0, @NotNull Geometry g1, double distance) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            double envDist = g0.getEnvelopeInternal().distance(g1.getEnvelopeInternal());
            if (envDist > distance) {
                return false;
            }
            DistanceOp distOp = new DistanceOp(g0, g1, distance);
            return distOp.distance() <= distance;
        }

        @JvmStatic
        @NotNull
        public final Coordinate[] nearestPoints(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DistanceOp distOp = new DistanceOp(g0, g1, 0.0, 4, null);
            return distOp.nearestPoints();
        }

        @Deprecated(message="renamed to nearestPoints")
        @NotNull
        public final Coordinate[] closestPoints(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DistanceOp distOp = new DistanceOp(g0, g1, 0.0, 4, null);
            return distOp.nearestPoints();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

