/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge;
import org.locationtech.jts.operation.linemerge.LineMergeEdge;
import org.locationtech.jts.planargraph.Edge;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/operation/linemerge/EdgeString;", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "directedEdges", "", "Lorg/locationtech/jts/operation/linemerge/LineMergeDirectedEdge;", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "add", "", "directedEdge", "toLineString", "Lorg/locationtech/jts/geom/LineString;", "kts-core"})
public final class EdgeString {
    @NotNull
    private final GeometryFactory factory;
    @NotNull
    private final List<LineMergeDirectedEdge> directedEdges;
    @Nullable
    private Coordinate[] coordinates;

    public EdgeString(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.directedEdges = new ArrayList();
    }

    private final Coordinate[] getCoordinates() {
        if (this.coordinates == null) {
            int forwardDirectedEdges = 0;
            int reverseDirectedEdges = 0;
            CoordinateList coordinateList = new CoordinateList();
            Iterator<LineMergeDirectedEdge> i = this.directedEdges.iterator();
            while (i.hasNext()) {
                LineMergeDirectedEdge directedEdge;
                Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge");
                if (directedEdge.getEdgeDirection()) {
                    ++forwardDirectedEdges;
                } else {
                    ++reverseDirectedEdges;
                }
                Edge edge = directedEdge.getEdge();
                Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.linemerge.LineMergeEdge");
                coordinateList.add(((LineMergeEdge)edge).getLine().getCoordinates(), false, directedEdge.getEdgeDirection());
            }
            this.coordinates = coordinateList.toCoordinateArray();
            if (reverseDirectedEdges > forwardDirectedEdges) {
                Intrinsics.checkNotNull((Object)this.coordinates);
                CoordinateArrays.reverse(this.coordinates);
            }
        }
        return this.coordinates;
    }

    public final void add(@NotNull LineMergeDirectedEdge directedEdge) {
        Intrinsics.checkNotNullParameter((Object)directedEdge, (String)"directedEdge");
        this.directedEdges.add(directedEdge);
    }

    @NotNull
    public final LineString toLineString() {
        return this.factory.createLineString(this.getCoordinates());
    }
}

