/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge;
import org.locationtech.jts.operation.linemerge.LineMergeEdge;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/operation/linemerge/LineMergeGraph;", "Lorg/locationtech/jts/planargraph/PlanarGraph;", "<init>", "()V", "addEdge", "", "lineString", "Lorg/locationtech/jts/geom/LineString;", "getNode", "Lorg/locationtech/jts/planargraph/Node;", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
public final class LineMergeGraph
extends PlanarGraph {
    public final void addEdge(@NotNull LineString lineString) {
        Intrinsics.checkNotNullParameter((Object)lineString, (String)"lineString");
        if (lineString.isEmpty()) {
            return;
        }
        Coordinate[] coordinates = CoordinateArrays.INSTANCE.removeRepeatedPoints(lineString.getCoordinates());
        if (coordinates.length <= 1) {
            return;
        }
        Coordinate startCoordinate = coordinates[0];
        Coordinate endCoordinate = coordinates[coordinates.length - 1];
        Node startNode = this.getNode(startCoordinate);
        Node endNode = this.getNode(endCoordinate);
        DirectedEdge directedEdge0 = new LineMergeDirectedEdge(startNode, endNode, coordinates[1], true);
        DirectedEdge directedEdge1 = new LineMergeDirectedEdge(endNode, startNode, coordinates[coordinates.length - 2], false);
        Edge edge = new LineMergeEdge(lineString);
        edge.setDirectedEdges(directedEdge0, directedEdge1);
        this.add(edge);
    }

    private final Node getNode(Coordinate coordinate) {
        Node node = this.findNode(coordinate);
        if (node == null) {
            node = new Node(coordinate, null, 2, null);
            this.add(node);
        }
        return node;
    }
}

