/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.EdgeString;
import org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge;
import org.locationtech.jts.operation.linemerge.LineMergeGraph;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/linemerge/LineMerger;", "", "<init>", "()V", "graph", "Lorg/locationtech/jts/operation/linemerge/LineMergeGraph;", "mergedLineStrings", "", "Lorg/locationtech/jts/geom/LineString;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "add", "", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "geometries", "", "lineString", "edgeStrings", "Lorg/locationtech/jts/operation/linemerge/EdgeString;", "merge", "buildEdgeStringsForObviousStartNodes", "buildEdgeStringsForIsolatedLoops", "buildEdgeStringsForUnprocessedNodes", "buildEdgeStringsForNonDegree2Nodes", "buildEdgeStringsStartingAt", "node", "Lorg/locationtech/jts/planargraph/Node;", "buildEdgeStringStartingWith", "start", "Lorg/locationtech/jts/operation/linemerge/LineMergeDirectedEdge;", "getMergedLineStrings", "kts-core"})
public final class LineMerger {
    @NotNull
    private final LineMergeGraph graph = new LineMergeGraph();
    @Nullable
    private Collection<LineString> mergedLineStrings;
    @Nullable
    private GeometryFactory factory;
    @Nullable
    private Collection<EdgeString> edgeStrings;

    public final void add(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        geometry.apply(new GeometryComponentFilter(this){
            final /* synthetic */ LineMerger this$0;
            {
                this.this$0 = $receiver;
            }

            public void filter(Geometry component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                if (component instanceof LineString) {
                    LineMerger.access$add(this.this$0, (LineString)component);
                }
            }
        });
    }

    public final void add(@NotNull Collection<?> geometries) {
        Intrinsics.checkNotNullParameter(geometries, (String)"geometries");
        this.mergedLineStrings = null;
        for (Object obj : geometries) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geometry = (Geometry)obj;
            this.add(geometry);
        }
    }

    private final void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private final void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        GraphComponent.Companion.setMarked(this.graph.nodeIterator(), false);
        GraphComponent.Companion.setMarked(this.graph.edgeIterator(), false);
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        Collection<EdgeString> collection = this.edgeStrings;
        Intrinsics.checkNotNull(collection);
        Iterator<EdgeString> i = collection.iterator();
        while (i.hasNext()) {
            EdgeString edgeString;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.linemerge.EdgeString");
            Collection<LineString> collection2 = this.mergedLineStrings;
            Intrinsics.checkNotNull(collection2);
            collection2.add(edgeString.toLineString());
        }
    }

    private final void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private final void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private final void buildEdgeStringsForUnprocessedNodes() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)obj;
            if (node.isMarked()) continue;
            Assert.isTrue(node.getDegree() == 2);
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private final void buildEdgeStringsForNonDegree2Nodes() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)obj;
            if (node.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private final void buildEdgeStringsStartingAt(Node node) {
        Iterator<DirectedEdge> i = node.getOutEdges().iterator();
        while (i.hasNext()) {
            DirectedEdge directedEdge = i.next();
            Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge");
            LineMergeDirectedEdge directedEdge2 = (LineMergeDirectedEdge)directedEdge;
            Edge edge = directedEdge2.getEdge();
            Intrinsics.checkNotNull((Object)edge);
            if (edge.isMarked()) continue;
            Collection<EdgeString> collection = this.edgeStrings;
            Intrinsics.checkNotNull(collection);
            collection.add(this.buildEdgeStringStartingWith(directedEdge2));
        }
    }

    private final EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge start) {
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        EdgeString edgeString = new EdgeString(geometryFactory);
        LineMergeDirectedEdge current = start;
        do {
            LineMergeDirectedEdge lineMergeDirectedEdge = current;
            Intrinsics.checkNotNull((Object)lineMergeDirectedEdge);
            edgeString.add(lineMergeDirectedEdge);
            Edge edge = current.getEdge();
            Intrinsics.checkNotNull((Object)edge);
            edge.setMarked(true);
        } while ((current = current.getNext()) != null && current != start);
        return edgeString;
    }

    @Nullable
    public final Collection<?> getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }

    public static final /* synthetic */ void access$add(LineMerger $this, LineString lineString) {
        $this.add(lineString);
    }
}

