/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.operation.overlay.OverlayOp;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/overlay/ConsistentPolygonRingChecker;", "", "graph", "Lorg/locationtech/jts/geomgraph/PlanarGraph;", "<init>", "(Lorg/locationtech/jts/geomgraph/PlanarGraph;)V", "checkAll", "", "check", "opCode", "", "getPotentialResultAreaEdges", "", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "deStar", "Lorg/locationtech/jts/geomgraph/DirectedEdgeStar;", "isPotentialResultAreaEdge", "", "de", "testLinkResultDirectedEdges", "Companion", "kts-core"})
public final class ConsistentPolygonRingChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanarGraph graph;
    private static final int SCANNING_FOR_INCOMING = 1;
    private static final int LINKING_TO_OUTGOING = 2;

    public ConsistentPolygonRingChecker(@NotNull PlanarGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
    }

    public final void checkAll() {
        this.check(1);
        this.check(3);
        this.check(2);
        this.check(4);
    }

    public final void check(int opCode) {
        Iterator<?> nodeit = this.graph.getNodeIterator();
        while (nodeit.hasNext()) {
            Object obj = nodeit.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            this.testLinkResultDirectedEdges((DirectedEdgeStar)node.getEdges(), opCode);
        }
    }

    private final List<DirectedEdge> getPotentialResultAreaEdges(DirectedEdgeStar deStar, int opCode) {
        List resultAreaEdgeList = new ArrayList();
        DirectedEdgeStar directedEdgeStar = deStar;
        Intrinsics.checkNotNull((Object)directedEdgeStar);
        Iterator<?> it = directedEdgeStar.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (!this.isPotentialResultAreaEdge(de, opCode) && !this.isPotentialResultAreaEdge(de.getSym(), opCode)) continue;
            resultAreaEdgeList.add(de);
        }
        return resultAreaEdgeList;
    }

    private final boolean isPotentialResultAreaEdge(DirectedEdge de, int opCode) {
        DirectedEdge directedEdge = de;
        Intrinsics.checkNotNull((Object)directedEdge);
        Label label = directedEdge.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label label2 = label;
        return label2.isArea() && !de.isInteriorAreaEdge() && OverlayOp.Companion.isResultOfOp(label2.getLocation(0, 2), label2.getLocation(1, 2), opCode);
    }

    private final void testLinkResultDirectedEdges(DirectedEdgeStar deStar, int opCode) {
        List<DirectedEdge> ringEdges = this.getPotentialResultAreaEdges(deStar, opCode);
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        int n = ((Collection)ringEdges).size();
        block4: for (int i = 0; i < n; ++i) {
            DirectedEdge nextOut = ringEdges.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            Label label = nextOut.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (!label.isArea()) continue;
            if (firstOut == null && this.isPotentialResultAreaEdge(nextOut, opCode)) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (!this.isPotentialResultAreaEdge(nextIn, opCode)) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (!this.isPotentialResultAreaEdge(nextOut, opCode)) continue block4;
                    state = 1;
                }
            }
        }
        if (state == 2 && firstOut == null) {
            DirectedEdgeStar directedEdgeStar = deStar;
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            throw new TopologyException("no outgoing dirEdge found", directedEdgeStar.getCoordinate());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/operation/overlay/ConsistentPolygonRingChecker$Companion;", "", "<init>", "()V", "SCANNING_FOR_INCOMING", "", "LINKING_TO_OUTGOING", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

