/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.MinimalEdgeRing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001H\u0016J\u0006\u0010\r\u001a\u00020\u000bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/operation/overlay/MaximalEdgeRing;", "Lorg/locationtech/jts/geomgraph/EdgeRing;", "start", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geomgraph/DirectedEdge;Lorg/locationtech/jts/geom/GeometryFactory;)V", "getNext", "de", "setEdgeRing", "", "er", "linkDirectedEdgesForMinimalEdgeRings", "buildMinimalRings", "", "kts-core"})
public final class MaximalEdgeRing
extends EdgeRing {
    public MaximalEdgeRing(@Nullable DirectedEdge start, @Nullable GeometryFactory geometryFactory) {
        GeometryFactory geometryFactory2 = geometryFactory;
        Intrinsics.checkNotNull((Object)geometryFactory2);
        super(start, geometryFactory2);
    }

    @Override
    @Nullable
    public DirectedEdge getNext(@NotNull DirectedEdge de) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        return de.getNext();
    }

    @Override
    public void setEdgeRing(@NotNull DirectedEdge de, @NotNull EdgeRing er) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        Intrinsics.checkNotNullParameter((Object)er, (String)"er");
        de.setEdgeRing(er);
    }

    public final void linkDirectedEdgesForMinimalEdgeRings() {
        DirectedEdge de = this.getStartDe();
        do {
            Node node;
            DirectedEdge directedEdge = de;
            Intrinsics.checkNotNull((Object)directedEdge);
            Intrinsics.checkNotNull((Object)directedEdge.getNode());
            DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)node.getEdges();
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            directedEdgeStar.linkMinimalDirectedEdges(this);
        } while (!Intrinsics.areEqual((Object)(de = de.getNext()), (Object)this.getStartDe()));
    }

    @NotNull
    public final List<EdgeRing> buildMinimalRings() {
        List minEdgeRings = new ArrayList();
        DirectedEdge de = this.getStartDe();
        do {
            DirectedEdge directedEdge = de;
            Intrinsics.checkNotNull((Object)directedEdge);
            if (directedEdge.getMinEdgeRing() != null) continue;
            EdgeRing minEr = new MinimalEdgeRing(de, this.getGeometryFactory());
            minEdgeRings.add(minEr);
        } while (!Intrinsics.areEqual((Object)(de = de.getNext()), (Object)this.getStartDe()));
        return minEdgeRings;
    }
}

