/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geomgraph.Depth;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.EdgeList;
import org.locationtech.jts.geomgraph.EdgeNodingValidator;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.GeometryGraphOperation;
import org.locationtech.jts.operation.overlay.LineBuilder;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.operation.overlay.PointBuilder;
import org.locationtech.jts.operation.overlay.PolygonBuilder;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0014\u0010\u001c\u001a\u00020\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0004J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J\b\u0010(\u001a\u00020\u001aH\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0018H\u0002J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002002\u0006\u00101\u001a\u000202J\u001e\u00104\u001a\u0002002\u0006\u00101\u001a\u0002022\f\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J:\u00106\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u00107\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/locationtech/jts/operation/overlay/OverlayOp;", "Lorg/locationtech/jts/operation/GeometryGraphOperation;", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "resultGeom", "graph", "Lorg/locationtech/jts/geomgraph/PlanarGraph;", "getGraph", "()Lorg/locationtech/jts/geomgraph/PlanarGraph;", "edgeList", "Lorg/locationtech/jts/geomgraph/EdgeList;", "resultPolyList", "", "resultLineList", "resultPointList", "getResultGeometry", "overlayOpCode", "", "computeOverlay", "", "opCode", "insertUniqueEdges", "edges", "insertUniqueEdge", "e", "Lorg/locationtech/jts/geomgraph/Edge;", "computeLabelsFromDepths", "replaceCollapsedEdges", "copyPoints", "argIndex", "computeLabelling", "mergeSymLabels", "updateNodeLabelling", "labelIncompleteNodes", "labelIncompleteNode", "n", "Lorg/locationtech/jts/geomgraph/Node;", "targetIndex", "findResultAreaEdges", "cancelDuplicateResultEdges", "isCoveredByLA", "", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "isCoveredByA", "isCovered", "geomList", "computeGeometry", "opcode", "Companion", "kts-core"})
public final class OverlayOp
extends GeometryGraphOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PointLocator ptLocator;
    @NotNull
    private final GeometryFactory geomFact;
    @Nullable
    private Geometry resultGeom;
    @NotNull
    private final PlanarGraph graph;
    @NotNull
    private final EdgeList edgeList;
    @NotNull
    private List<? extends Geometry> resultPolyList;
    @NotNull
    private List<? extends Geometry> resultLineList;
    @NotNull
    private List<? extends Geometry> resultPointList;
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;

    public OverlayOp(@NotNull Geometry g0, @Nullable Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Geometry geometry = g1;
        Intrinsics.checkNotNull((Object)geometry);
        super(g0, geometry, null, 4, null);
        this.ptLocator = new PointLocator();
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.edgeList = new EdgeList();
        this.resultPolyList = new ArrayList();
        this.resultLineList = new ArrayList();
        this.resultPointList = new ArrayList();
        this.geomFact = g0.getFactory();
    }

    @NotNull
    public final PlanarGraph getGraph() {
        return this.graph;
    }

    @Nullable
    public final Geometry getResultGeometry(int overlayOpCode) {
        this.computeOverlay(overlayOpCode);
        return this.resultGeom;
    }

    private final void computeOverlay(int opCode) {
        this.copyPoints(0);
        this.copyPoints(1);
        this.getArg()[0].computeSelfNodes(this.getLi(), false);
        this.getArg()[1].computeSelfNodes(this.getLi(), false);
        this.getArg()[0].computeEdgeIntersections(this.getArg()[1], this.getLi(), true);
        List baseSplitEdges = new ArrayList();
        this.getArg()[0].computeSplitEdges(baseSplitEdges);
        this.getArg()[1].computeSplitEdges(baseSplitEdges);
        List splitEdges = baseSplitEdges;
        this.insertUniqueEdges(baseSplitEdges);
        this.computeLabelsFromDepths();
        this.replaceCollapsedEdges();
        EdgeNodingValidator.Companion.checkValid((Collection)this.edgeList.getEdges());
        this.graph.addEdges(this.edgeList.getEdges());
        this.computeLabelling();
        this.labelIncompleteNodes();
        this.findResultAreaEdges(opCode);
        this.cancelDuplicateResultEdges();
        PolygonBuilder polyBuilder = new PolygonBuilder(this.geomFact);
        polyBuilder.add(this.graph);
        this.resultPolyList = polyBuilder.getPolygons();
        LineBuilder lineBuilder = new LineBuilder(this, this.geomFact, this.ptLocator);
        this.resultLineList = lineBuilder.build(opCode);
        PointBuilder pointBuilder = new PointBuilder(this, this.geomFact, this.ptLocator);
        this.resultPointList = pointBuilder.build(opCode);
        this.resultGeom = this.computeGeometry(this.resultPointList, this.resultLineList, this.resultPolyList, opCode);
    }

    private final void insertUniqueEdges(List<?> edges) {
        for (Object obj : edges) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            this.insertUniqueEdge(e);
        }
    }

    protected final void insertUniqueEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Edge existingEdge = this.edgeList.findEqualEdge(e);
        if (existingEdge != null) {
            Depth depth;
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                Label label = e.getLabel();
                Intrinsics.checkNotNull((Object)label);
                labelToMerge = new Label(label);
                labelToMerge.flip();
            }
            if ((depth = existingEdge.getDepth()).isNull()) {
                Label label = existingLabel;
                Intrinsics.checkNotNull((Object)label);
                depth.add(label);
            }
            Label label = labelToMerge;
            Intrinsics.checkNotNull((Object)label);
            depth.add(label);
            Label label2 = existingLabel;
            Intrinsics.checkNotNull((Object)label2);
            label2.merge(labelToMerge);
        } else {
            this.edgeList.add(e);
        }
    }

    private final void computeLabelsFromDepths() {
        ListIterator<Edge> it = this.edgeList.iterator();
        while (it.hasNext()) {
            Edge e = it.next();
            Label lbl = e.getLabel();
            Depth depth = e.getDepth();
            if (depth.isNull()) continue;
            depth.normalize();
            for (int i = 0; i < 2; ++i) {
                Label label = lbl;
                Intrinsics.checkNotNull((Object)label);
                if (label.isNull(i) || !lbl.isArea() || depth.isNull(i)) continue;
                if (depth.getDelta(i) == 0) {
                    lbl.toLine(i);
                    continue;
                }
                Assert.INSTANCE.isTrue(!depth.isNull(i, 1), "depth of LEFT side has not been initialized");
                lbl.setLocation(i, 1, depth.getLocation(i, 1));
                Assert.INSTANCE.isTrue(!depth.isNull(i, 2), "depth of RIGHT side has not been initialized");
                lbl.setLocation(i, 2, depth.getLocation(i, 2));
            }
        }
    }

    private final void replaceCollapsedEdges() {
        List newEdges = new ArrayList();
        ListIterator<Edge> it = this.edgeList.iterator();
        while (it.hasNext()) {
            Edge e = it.next();
            if (!e.isCollapsed()) continue;
            it.remove();
            newEdges.add(e.getCollapsedEdge());
        }
        this.edgeList.addAll(newEdges);
    }

    private final void copyPoints(int argIndex) {
        Iterator<?> i = this.getArg()[argIndex].getNodeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node graphNode = (Node)obj;
            Coordinate coordinate = graphNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            Node newNode = this.graph.addNode(coordinate);
            Label label = graphNode.getLabel();
            Intrinsics.checkNotNull((Object)label);
            newNode.setLabel(argIndex, label.getLocation(argIndex));
        }
    }

    private final void computeLabelling() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar);
            edgeEndStar.computeLabelling(this.getArg());
        }
        this.mergeSymLabels();
        this.updateNodeLabelling();
    }

    private final void mergeSymLabels() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)node.getEdges();
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            directedEdgeStar.mergeSymLabels();
        }
    }

    private final void updateNodeLabelling() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)node.getEdges();
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            Label lbl = directedEdgeStar.getLabel();
            Label label = node.getLabel();
            Intrinsics.checkNotNull((Object)label);
            Label label2 = lbl;
            Intrinsics.checkNotNull((Object)label2);
            label.merge(label2);
        }
    }

    private final void labelIncompleteNodes() {
        for (Object obj : this.graph.getNodes()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node n = (Node)obj;
            Label label = n.getLabel();
            if (n.isIsolated()) {
                Label label2 = label;
                Intrinsics.checkNotNull((Object)label2);
                if (label2.isNull(0)) {
                    this.labelIncompleteNode(n, 0);
                } else {
                    this.labelIncompleteNode(n, 1);
                }
            }
            DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)n.getEdges();
            Intrinsics.checkNotNull((Object)directedEdgeStar);
            Label label3 = label;
            Intrinsics.checkNotNull((Object)label3);
            directedEdgeStar.updateLabelling(label3);
        }
    }

    private final void labelIncompleteNode(Node n, int targetIndex) {
        Coordinate coordinate = n.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Geometry geometry = this.getArg()[targetIndex].getGeometry();
        Intrinsics.checkNotNull((Object)geometry);
        int loc = this.ptLocator.locate(coordinate, geometry);
        Label label = n.getLabel();
        Intrinsics.checkNotNull((Object)label);
        label.setLocation(targetIndex, loc);
    }

    private final void findResultAreaEdges(int opCode) {
        for (Object obj : this.graph.getEdgeEnds()) {
            Label label;
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            Label label2 = label = de.getLabel();
            Intrinsics.checkNotNull((Object)label2);
            if (!label2.isArea() || de.isInteriorAreaEdge() || !Companion.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), opCode)) continue;
            de.setInResult(true);
        }
    }

    private final void cancelDuplicateResultEdges() {
        for (Object obj : this.graph.getEdgeEnds()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            DirectedEdge sym = de.getSym();
            if (!de.isInResult()) continue;
            DirectedEdge directedEdge = sym;
            Intrinsics.checkNotNull((Object)directedEdge);
            if (!directedEdge.isInResult()) continue;
            de.setInResult(false);
            sym.setInResult(false);
        }
    }

    public final boolean isCoveredByLA(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (this.isCovered(coord, this.resultLineList)) {
            return true;
        }
        return this.isCovered(coord, this.resultPolyList);
    }

    public final boolean isCoveredByA(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return this.isCovered(coord, this.resultPolyList);
    }

    private final boolean isCovered(Coordinate coord, List<?> geomList) {
        List<?> list = geomList;
        Intrinsics.checkNotNull(list);
        for (Object obj : list) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geom = (Geometry)obj;
            int loc = this.ptLocator.locate(coord, geom);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    private final Geometry computeGeometry(List<? extends Geometry> resultPointList, List<? extends Geometry> resultLineList, List<? extends Geometry> resultPolyList, int opcode) {
        Geometry geometry;
        List geomList = new ArrayList();
        geomList.addAll((Collection)resultPointList);
        geomList.addAll((Collection)resultLineList);
        geomList.addAll((Collection)resultPolyList);
        if (geomList.isEmpty()) {
            Geometry geometry2 = this.getArg()[0].getGeometry();
            Intrinsics.checkNotNull((Object)geometry2);
            Geometry geometry3 = this.getArg()[1].getGeometry();
            Intrinsics.checkNotNull((Object)geometry3);
            geometry = Companion.createEmptyResult(opcode, geometry2, geometry3, this.geomFact);
        } else {
            geometry = this.geomFact.buildGeometry(geomList);
        }
        return geometry;
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlayOp(@NotNull Geometry geom0, @Nullable Geometry geom1, int opCode) {
        return Companion.overlayOp(geom0, geom1, opCode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J&\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/operation/overlay/OverlayOp$Companion;", "", "<init>", "()V", "INTERSECTION", "", "UNION", "DIFFERENCE", "SYMDIFFERENCE", "overlayOp", "Lorg/locationtech/jts/geom/Geometry;", "geom0", "geom1", "opCode", "isResultOfOp", "", "label", "Lorg/locationtech/jts/geomgraph/Label;", "loc0", "loc1", "overlayOpCode", "createEmptyResult", "a", "b", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "resultDimension", "g0", "g1", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nOverlayOp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayOp.kt\norg/locationtech/jts/operation/overlay/OverlayOp$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,647:1\n1#2:648\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Geometry overlayOp(@NotNull Geometry geom0, @Nullable Geometry geom1, int opCode) {
            Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
            OverlayOp gov = new OverlayOp(geom0, geom1);
            return gov.getResultGeometry(opCode);
        }

        public final boolean isResultOfOp(@NotNull Label label, int opCode) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            int loc0 = label.getLocation(0);
            int loc1 = label.getLocation(1);
            return this.isResultOfOp(loc0, loc1, opCode);
        }

        public final boolean isResultOfOp(int loc0, int loc1, int overlayOpCode) {
            int loc02 = loc0;
            int loc12 = loc1;
            if (loc02 == 1) {
                loc02 = 0;
            }
            if (loc12 == 1) {
                loc12 = 0;
            }
            switch (overlayOpCode) {
                case 1: {
                    return loc02 == 0 && loc12 == 0;
                }
                case 2: {
                    return loc02 == 0 || loc12 == 0;
                }
                case 3: {
                    return loc02 == 0 && loc12 != 0;
                }
                case 4: {
                    return loc02 == 0 && loc12 != 0 || loc02 != 0 && loc12 == 0;
                }
            }
            return false;
        }

        @NotNull
        public final Geometry createEmptyResult(int overlayOpCode, @NotNull Geometry a, @NotNull Geometry b, @NotNull GeometryFactory geomFact) {
            Geometry geometry;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
            Geometry result2 = null;
            int resultDim = this.resultDimension(overlayOpCode, a, b);
            Geometry it = geometry = geomFact.createEmpty(resultDim);
            boolean bl = false;
            result2 = it;
            return geometry;
        }

        private final int resultDimension(int opCode, Geometry g0, Geometry g1) {
            int dim0 = g0.getDimension();
            int dim1 = g1.getDimension();
            int resultDimension = -1;
            switch (opCode) {
                case 1: {
                    resultDimension = Math.INSTANCE.min(dim0, dim1);
                    break;
                }
                case 2: {
                    resultDimension = Math.INSTANCE.max(dim0, dim1);
                    break;
                }
                case 3: {
                    resultDimension = dim0;
                    break;
                }
                case 4: {
                    resultDimension = Math.INSTANCE.max(dim0, dim1);
                }
            }
            return resultDimension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

