/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0016J#\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/LineStringSnapper;", "", "srcPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "snapTolerance", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;D)V", "srcLine", "Lorg/locationtech/jts/geom/LineString;", "(Lorg/locationtech/jts/geom/LineString;D)V", "[Lorg/locationtech/jts/geom/Coordinate;", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "allowSnappingToSourceVertices", "", "isClosed", "setAllowSnappingToSourceVertices", "", "snapTo", "snapPts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "snapVertices", "srcCoords", "Lorg/locationtech/jts/geom/CoordinateList;", "(Lorg/locationtech/jts/geom/CoordinateList;[Lorg/locationtech/jts/geom/Coordinate;)V", "findSnapForVertex", "pt", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "snapSegments", "findSegmentIndexToSnap", "", "snapPt", "Companion", "kts-core"})
public final class LineStringSnapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] srcPts;
    private final double snapTolerance;
    @NotNull
    private final LineSegment seg;
    private boolean allowSnappingToSourceVertices;
    private boolean isClosed;

    public LineStringSnapper(@NotNull Coordinate[] srcPts, double snapTolerance) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        this.srcPts = srcPts;
        this.snapTolerance = snapTolerance;
        this.seg = new LineSegment(null, null, 3, null);
        this.isClosed = LineStringSnapper.Companion.isClosed(this.srcPts);
    }

    public LineStringSnapper(@NotNull LineString srcLine, double snapTolerance) {
        Intrinsics.checkNotNullParameter((Object)srcLine, (String)"srcLine");
        this(srcLine.getCoordinates(), snapTolerance);
    }

    public final void setAllowSnappingToSourceVertices(boolean allowSnappingToSourceVertices) {
        this.allowSnappingToSourceVertices = allowSnappingToSourceVertices;
    }

    @NotNull
    public final Coordinate[] snapTo(@NotNull Coordinate[] snapPts) {
        Intrinsics.checkNotNullParameter((Object)snapPts, (String)"snapPts");
        CoordinateList coordList = new CoordinateList(this.srcPts);
        this.snapVertices(coordList, snapPts);
        this.snapSegments(coordList, snapPts);
        return coordList.toCoordinateArray();
    }

    private final void snapVertices(CoordinateList srcCoords, Coordinate[] snapPts) {
        int end = this.isClosed ? srcCoords.size() - 1 : srcCoords.size();
        for (int i = 0; i < end; ++i) {
            Coordinate snapVert = this.findSnapForVertex(srcCoords.get(i), snapPts);
            if (snapVert == null) continue;
            srcCoords.set(i, new Coordinate(snapVert));
            if (i != 0 || !this.isClosed) continue;
            srcCoords.set(srcCoords.size() - 1, new Coordinate(snapVert));
        }
    }

    private final Coordinate findSnapForVertex(Coordinate pt, Coordinate[] snapPts) {
        int n = snapPts.length;
        for (int i = 0; i < n; ++i) {
            if (pt.equals2D(snapPts[i])) {
                return null;
            }
            if (!(pt.distance(snapPts[i]) < this.snapTolerance)) continue;
            return snapPts[i];
        }
        return null;
    }

    private final void snapSegments(CoordinateList srcCoords, Coordinate[] snapPts) {
        if (snapPts.length == 0) {
            return;
        }
        int distinctPtCount = snapPts.length;
        if (snapPts[0].equals2D(snapPts[snapPts.length - 1])) {
            distinctPtCount = snapPts.length - 1;
        }
        int n = distinctPtCount;
        for (int i = 0; i < n; ++i) {
            Coordinate snapPt = snapPts[i];
            int index = this.findSegmentIndexToSnap(snapPt, srcCoords);
            if (index < 0) continue;
            srcCoords.add(index + 1, new Coordinate(snapPt), false);
        }
    }

    private final int findSegmentIndexToSnap(Coordinate snapPt, CoordinateList srcCoords) {
        double minDist = Double.MAX_VALUE;
        int snapIndex = -1;
        int n = srcCoords.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.seg.p0 = srcCoords.get(i);
            this.seg.p1 = srcCoords.get(i + 1);
            if (this.seg.p0.equals2D(snapPt) || this.seg.p1.equals2D(snapPt)) {
                if (this.allowSnappingToSourceVertices) continue;
                return -1;
            }
            double dist = this.seg.distance(snapPt);
            if (!(dist < this.snapTolerance) || !(dist < minDist)) continue;
            minDist = dist;
            snapIndex = i;
        }
        return snapIndex;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/LineStringSnapper$Companion;", "", "<init>", "()V", "isClosed", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isClosed(Coordinate[] pts) {
            return pts.length <= 1 ? false : pts[0].equals2D(pts[pts.length - 1]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

