/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.precision.CommonBitsRemover;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002\u00a2\u0006\u0002\u0010\u0013R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/SnapOverlayOp;", "", "g1", "Lorg/locationtech/jts/geom/Geometry;", "g2", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "geom", "", "[Lorg/locationtech/jts/geom/Geometry;", "snapTolerance", "", "computeSnapTolerance", "", "getResultGeometry", "opCode", "", "selfSnap", "snap", "([Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Geometry;", "prepareResult", "cbr", "Lorg/locationtech/jts/precision/CommonBitsRemover;", "removeCommonBits", "Companion", "kts-core"})
public final class SnapOverlayOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry[] geom = new Geometry[2];
    private double snapTolerance;
    @Nullable
    private CommonBitsRemover cbr;

    public SnapOverlayOp(@Nullable Geometry g1, @Nullable Geometry g2) {
        this.geom[0] = g1;
        this.geom[1] = g2;
        this.computeSnapTolerance();
    }

    private final void computeSnapTolerance() {
        Geometry geometry = this.geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        Geometry geometry2 = this.geom[1];
        Intrinsics.checkNotNull((Object)geometry2);
        this.snapTolerance = GeometrySnapper.Companion.computeOverlaySnapTolerance(geometry, geometry2);
    }

    @NotNull
    public final Geometry getResultGeometry(int opCode) {
        Geometry[] prepGeom = this.snap((Geometry[])ArraysKt.requireNoNulls((Object[])this.geom));
        Geometry geometry = OverlayOp.Companion.overlayOp(prepGeom[0], prepGeom[1], opCode);
        Intrinsics.checkNotNull((Object)geometry);
        Geometry result2 = geometry;
        return this.prepareResult(result2);
    }

    private final Geometry selfSnap(Geometry geom) {
        GeometrySnapper snapper0 = new GeometrySnapper(geom);
        return snapper0.snapTo(geom, this.snapTolerance);
    }

    private final Geometry[] snap(Geometry[] geom) {
        Geometry[] remGeom = this.removeCommonBits(geom);
        return GeometrySnapper.Companion.snap(remGeom[0], remGeom[1], this.snapTolerance);
    }

    private final Geometry prepareResult(Geometry geom) {
        CommonBitsRemover commonBitsRemover = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover);
        commonBitsRemover.addCommonBits(geom);
        return geom;
    }

    private final Geometry[] removeCommonBits(Geometry[] geom) {
        CommonBitsRemover commonBitsRemover = this.cbr = new CommonBitsRemover();
        Intrinsics.checkNotNull((Object)commonBitsRemover);
        commonBitsRemover.add(geom[0]);
        CommonBitsRemover commonBitsRemover2 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover2);
        commonBitsRemover2.add(geom[1]);
        Object[] remGeom = new Geometry[2];
        CommonBitsRemover commonBitsRemover3 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover3);
        remGeom[0] = commonBitsRemover3.removeCommonBits(geom[0].copy());
        CommonBitsRemover commonBitsRemover4 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover4);
        remGeom[1] = commonBitsRemover4.removeCommonBits(geom[1].copy());
        return (Geometry[])ArraysKt.requireNoNulls((Object[])remGeom);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/SnapOverlayOp$Companion;", "", "<init>", "()V", "overlayOp", "Lorg/locationtech/jts/geom/Geometry;", "g0", "g1", "opCode", "", "intersection", "union", "difference", "symDifference", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Geometry overlayOp(@Nullable Geometry g0, @Nullable Geometry g1, int opCode) {
            SnapOverlayOp op = new SnapOverlayOp(g0, g1);
            return op.getResultGeometry(opCode);
        }

        @NotNull
        public final Geometry intersection(@Nullable Geometry g0, @Nullable Geometry g1) {
            return this.overlayOp(g0, g1, 1);
        }

        @NotNull
        public final Geometry union(@Nullable Geometry g0, @Nullable Geometry g1) {
            return this.overlayOp(g0, g1, 2);
        }

        @NotNull
        public final Geometry difference(@Nullable Geometry g0, @Nullable Geometry g1) {
            return this.overlayOp(g0, g1, 3);
        }

        @NotNull
        public final Geometry symDifference(@Nullable Geometry g0, @Nullable Geometry g1) {
            return this.overlayOp(g0, g1, 4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

