/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.overlay.snap.LineStringSnapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/SnapTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "snapTolerance", "", "snapPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(D[Lorg/locationtech/jts/geom/Coordinate;)V", "isSelfSnap", "", "(D[Lorg/locationtech/jts/geom/Coordinate;Z)V", "[Lorg/locationtech/jts/geom/Coordinate;", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coords", "parent", "Lorg/locationtech/jts/geom/Geometry;", "snapLine", "srcPts", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
public final class SnapTransformer
extends GeometryTransformer {
    private double snapTolerance;
    @NotNull
    private Coordinate[] snapPts;
    private boolean isSelfSnap;

    public SnapTransformer(double snapTolerance, @NotNull Coordinate[] snapPts) {
        Intrinsics.checkNotNullParameter((Object)snapPts, (String)"snapPts");
        this.snapTolerance = snapTolerance;
        this.snapPts = snapPts;
    }

    public SnapTransformer(double snapTolerance, @NotNull Coordinate[] snapPts, boolean isSelfSnap) {
        Intrinsics.checkNotNullParameter((Object)snapPts, (String)"snapPts");
        this.snapTolerance = snapTolerance;
        this.snapPts = snapPts;
        this.isSelfSnap = isSelfSnap;
    }

    @Override
    @NotNull
    protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coords, @Nullable Geometry parent) {
        CoordinateSequence coordinateSequence = coords;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        Coordinate[] srcPts = coordinateSequence.toCoordinateArray();
        Coordinate[] newPts = this.snapLine(srcPts, this.snapPts);
        GeometryFactory geometryFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.getCoordinateSequenceFactory().create(newPts);
    }

    private final Coordinate[] snapLine(Coordinate[] srcPts, Coordinate[] snapPts) {
        LineStringSnapper snapper = new LineStringSnapper(srcPts, this.snapTolerance);
        snapper.setAllowSnappingToSourceVertices(this.isSelfSnap);
        return snapper.snapTo(snapPts);
    }
}

