/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.validate;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.operation.overlay.validate.PolygonalLineworkExtracter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/overlay/validate/FuzzyPointLocator;", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "boundaryDistanceTolerance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;D)V", "linework", "Lorg/locationtech/jts/geom/MultiLineString;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "getLocation", "", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "extractLinework", "isWithinToleranceOfBoundary", "", "kts-core"})
public final class FuzzyPointLocator {
    @NotNull
    private final Geometry g;
    private final double boundaryDistanceTolerance;
    @NotNull
    private final MultiLineString linework;
    @NotNull
    private final PointLocator ptLocator;
    @NotNull
    private final LineSegment seg;

    public FuzzyPointLocator(@NotNull Geometry g, double boundaryDistanceTolerance) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.g = g;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.ptLocator = new PointLocator();
        this.seg = new LineSegment(null, null, 3, null);
        this.linework = this.extractLinework(this.g);
    }

    public final int getLocation(@NotNull Coordinate pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        return this.isWithinToleranceOfBoundary(pt) ? 1 : this.ptLocator.locate(pt, this.g);
    }

    private final MultiLineString extractLinework(Geometry g) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g.apply(extracter);
        List<LineString> linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.Companion.toLineStringArray((Collection<? extends Geometry>)linework);
        return g.getFactory().createMultiLineString(lines);
    }

    private final boolean isWithinToleranceOfBoundary(Coordinate pt) {
        int n = this.linework.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = this.linework.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            CoordinateSequence seq = line.getCoordinateSequence();
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            int n2 = coordinateSequence.size() - 1;
            for (int j = 0; j < n2; ++j) {
                seq.getCoordinate(j, this.seg.p0);
                seq.getCoordinate(j + 1, this.seg.p1);
                double dist = this.seg.distance(pt);
                if (!(dist <= this.boundaryDistanceTolerance)) continue;
                return true;
            }
        }
        return false;
    }
}

