/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.validate;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J.\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/overlay/validate/OffsetPointGenerator;", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "doLeft", "", "doRight", "setSidesToGenerate", "", "getPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "offsetDistance", "", "extractPoints", "line", "Lorg/locationtech/jts/geom/LineString;", "offsetPts", "computeOffsetPoints", "p0", "p1", "kts-core"})
public final class OffsetPointGenerator {
    @NotNull
    private final Geometry g;
    private boolean doLeft;
    private boolean doRight;

    public OffsetPointGenerator(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.g = g;
        this.doLeft = true;
        this.doRight = true;
    }

    public final void setSidesToGenerate(boolean doLeft, boolean doRight) {
        this.doLeft = doLeft;
        this.doRight = doRight;
    }

    @NotNull
    public final List<Coordinate> getPoints(double offsetDistance) {
        List offsetPts = new ArrayList();
        List<Geometry> lines = LinearComponentExtracter.Companion.getLines(this.g);
        for (Geometry geometry : lines) {
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            this.extractPoints(line, offsetDistance, offsetPts);
        }
        return offsetPts;
    }

    private final void extractPoints(LineString line, double offsetDistance, List<Coordinate> offsetPts) {
        Coordinate[] pts = line.getCoordinates();
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            this.computeOffsetPoints(pts[i], pts[i + 1], offsetDistance, offsetPts);
        }
    }

    private final void computeOffsetPoints(Coordinate p0, Coordinate p1, double offsetDistance, List<Coordinate> offsetPts) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double len = Math.INSTANCE.sqrt(dx * dx + dy * dy);
        double ux = offsetDistance * dx / len;
        double uy = offsetDistance * dy / len;
        double midX = (p1.x + p0.x) / (double)2;
        double midY = (p1.y + p0.y) / (double)2;
        if (this.doLeft) {
            Coordinate offsetLeft = new Coordinate(midX - uy, midY + ux);
            offsetPts.add(offsetLeft);
        }
        if (this.doRight) {
            Coordinate offsetRight = new Coordinate(midX + uy, midY - ux);
            offsetPts.add(offsetRight);
        }
    }
}

