/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.ValidatingNoder;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeMerger;
import org.locationtech.jts.operation.overlayng.EdgeSourceInfo;
import org.locationtech.jts.operation.overlayng.LineLimiter;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.operation.overlayng.RingClipper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 K2\u00020\u0001:\u0001KB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0!H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u001a\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u00100\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0002J\u0018\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u00105\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u001fH\u0002J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0010H\u0002J\u001d\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010?J\u0018\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J#\u0010@\u001a\u00020\u001b2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010DJ#\u0010E\u001a\u00020\u001b2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010F\u001a\u00020GH\u0002\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020BH\u0002J\u001e\u0010J\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0=\u0018\u00010!2\u0006\u0010A\u001a\u00020BH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006L"}, d2={"Lorg/locationtech/jts/operation/overlayng/EdgeNodingBuilder;", "", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "customNoder", "Lorg/locationtech/jts/noding/Noder;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;Lorg/locationtech/jts/noding/Noder;)V", "inputEdges", "", "Lorg/locationtech/jts/noding/NodedSegmentString;", "getInputEdges", "()Ljava/util/List;", "setInputEdges", "(Ljava/util/List;)V", "clipEnv", "Lorg/locationtech/jts/geom/Envelope;", "clipper", "Lorg/locationtech/jts/operation/overlayng/RingClipper;", "limiter", "Lorg/locationtech/jts/operation/overlayng/LineLimiter;", "hasEdges", "", "noder", "getNoder", "()Lorg/locationtech/jts/noding/Noder;", "setClipEnvelope", "", "hasEdgesFor", "", "geomIndex", "", "build", "", "Lorg/locationtech/jts/operation/overlayng/Edge;", "geom0", "Lorg/locationtech/jts/geom/Geometry;", "geom1", "node", "segStrings", "createEdges", "", "Lorg/locationtech/jts/noding/SegmentString;", "add", "g", "addCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "addGeometryCollection", "expectedDim", "addPolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "addPolygonRing", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "isHole", "index", "isClippedCompletely", "env", "clip", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/LinearRing;)[Lorg/locationtech/jts/geom/Coordinate;", "addLine", "line", "Lorg/locationtech/jts/geom/LineString;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;I)V", "addEdge", "info", "Lorg/locationtech/jts/operation/overlayng/EdgeSourceInfo;", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/overlayng/EdgeSourceInfo;)V", "isToBeLimited", "limit", "Companion", "kts-core"})
public final class EdgeNodingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PrecisionModel pm;
    @Nullable
    private final Noder customNoder;
    @NotNull
    private List<NodedSegmentString> inputEdges;
    @Nullable
    private Envelope clipEnv;
    @Nullable
    private RingClipper clipper;
    @Nullable
    private LineLimiter limiter;
    @NotNull
    private final boolean[] hasEdges;
    private static final int MIN_LIMIT_PTS = 20;
    private static final boolean IS_NODING_VALIDATED = true;

    public EdgeNodingBuilder(@Nullable PrecisionModel pm, @Nullable Noder customNoder) {
        this.pm = pm;
        this.customNoder = customNoder;
        this.inputEdges = new ArrayList();
        this.hasEdges = new boolean[2];
    }

    @NotNull
    public final List<NodedSegmentString> getInputEdges() {
        return this.inputEdges;
    }

    public final void setInputEdges(@NotNull List<NodedSegmentString> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inputEdges = list;
    }

    private final Noder getNoder() {
        if (this.customNoder != null) {
            return this.customNoder;
        }
        return OverlayUtil.INSTANCE.isFloating(this.pm) ? EdgeNodingBuilder.Companion.createFloatingPrecisionNoder(true) : EdgeNodingBuilder.Companion.createFixedPrecisionNoder(this.pm);
    }

    public final void setClipEnvelope(@NotNull Envelope clipEnv) {
        Intrinsics.checkNotNullParameter((Object)clipEnv, (String)"clipEnv");
        this.clipEnv = clipEnv;
        this.clipper = new RingClipper(clipEnv);
        this.limiter = new LineLimiter(clipEnv);
    }

    public final boolean hasEdgesFor(int geomIndex) {
        return this.hasEdges[geomIndex];
    }

    @NotNull
    public final List<Edge> build(@Nullable Geometry geom0, @Nullable Geometry geom1) {
        this.add(geom0, 0);
        this.add(geom1, 1);
        List<Edge> nodedEdges = this.node(this.inputEdges);
        return EdgeMerger.INSTANCE.merge(nodedEdges);
    }

    private final List<Edge> node(List<NodedSegmentString> segStrings) {
        Noder noder = this.getNoder();
        noder.computeNodes((Collection<? extends SegmentString>)segStrings);
        Collection<SegmentString> collection = noder.getNodedSubstrings();
        Intrinsics.checkNotNull(collection);
        Collection<SegmentString> nodedSS = collection;
        return this.createEdges(nodedSS);
    }

    private final List<Edge> createEdges(Collection<? extends SegmentString> segStrings) {
        List edges = new ArrayList();
        for (SegmentString segmentString : segStrings) {
            EdgeSourceInfo info;
            Coordinate[] pts = segmentString.getCoordinates();
            if (Edge.Companion.isCollapsed(pts)) continue;
            EdgeSourceInfo edgeSourceInfo = info = (EdgeSourceInfo)segmentString.getData();
            Intrinsics.checkNotNull((Object)edgeSourceInfo);
            this.hasEdges[edgeSourceInfo.getIndex()] = true;
            edges.add(new Edge(segmentString.getCoordinates(), info));
        }
        return edges;
    }

    private final void add(Geometry g, int geomIndex) {
        if (g == null || g.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(g.getEnvelopeInternal())) {
            return;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g, geomIndex);
        } else if (g instanceof LineString) {
            this.addLine((LineString)g, geomIndex);
        } else if (g instanceof MultiLineString) {
            this.addCollection((GeometryCollection)g, geomIndex);
        } else if (g instanceof MultiPolygon) {
            this.addCollection((GeometryCollection)g, geomIndex);
        } else if (g instanceof GeometryCollection) {
            this.addGeometryCollection((GeometryCollection)g, geomIndex, ((GeometryCollection)g).getDimension());
        }
    }

    private final void addCollection(GeometryCollection gc, int geomIndex) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g, geomIndex);
        }
    }

    private final void addGeometryCollection(GeometryCollection gc, int geomIndex, int expectedDim) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            if (g.getDimension() != expectedDim) {
                throw new IllegalArgumentException("Overlay input is mixed-dimension");
            }
            this.add(g, geomIndex);
        }
    }

    private final void addPolygon(Polygon poly, int geomIndex) {
        LinearRing shell = poly.getExteriorRing();
        this.addPolygonRing(shell, false, geomIndex);
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            this.addPolygonRing(hole, true, geomIndex);
        }
    }

    private final void addPolygonRing(LinearRing ring, boolean isHole, int index) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(ring.getEnvelopeInternal())) {
            return;
        }
        Coordinate[] pts = this.clip(ring);
        if (pts.length < 2) {
            return;
        }
        int depthDelta = EdgeNodingBuilder.Companion.computeDepthDelta(ring, isHole);
        EdgeSourceInfo info = new EdgeSourceInfo(index, depthDelta, isHole);
        this.addEdge(pts, info);
    }

    private final boolean isClippedCompletely(Envelope env) {
        boolean bl;
        if (this.clipEnv == null) {
            bl = false;
        } else {
            Envelope envelope = this.clipEnv;
            Intrinsics.checkNotNull((Object)envelope);
            bl = envelope.disjoint(env);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Coordinate[] clip(LinearRing ring) {
        Coordinate[] coordinateArray;
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] pts = linearRing.getCoordinates();
        Envelope env = ring.getEnvelopeInternal();
        if (this.clipper != null) {
            Envelope envelope = this.clipEnv;
            Intrinsics.checkNotNull((Object)envelope);
            if (!envelope.covers(env)) {
                RingClipper ringClipper = this.clipper;
                Intrinsics.checkNotNull((Object)ringClipper);
                coordinateArray = ringClipper.clip(pts);
                return coordinateArray;
            }
        }
        coordinateArray = EdgeNodingBuilder.Companion.removeRepeatedPoints(ring);
        return coordinateArray;
    }

    private final void addLine(LineString line, int geomIndex) {
        if (line.isEmpty()) {
            return;
        }
        if (this.isClippedCompletely(line.getEnvelopeInternal())) {
            return;
        }
        if (this.isToBeLimited(line)) {
            List<Coordinate[]> sections;
            List<Coordinate[]> list = sections = this.limit(line);
            Intrinsics.checkNotNull(list);
            for (Coordinate[] pts : list) {
                this.addLine(pts, geomIndex);
            }
        } else {
            Coordinate[] ptsNoRepeat = EdgeNodingBuilder.Companion.removeRepeatedPoints(line);
            this.addLine(ptsNoRepeat, geomIndex);
        }
    }

    private final void addLine(Coordinate[] pts, int geomIndex) {
        if (pts.length < 2) {
            return;
        }
        EdgeSourceInfo info = new EdgeSourceInfo(geomIndex);
        this.addEdge(pts, info);
    }

    private final void addEdge(Coordinate[] pts, EdgeSourceInfo info) {
        NodedSegmentString ss = new NodedSegmentString(pts, info);
        this.inputEdges.add(ss);
    }

    private final boolean isToBeLimited(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        if (this.limiter == null || pts.length <= 20) {
            return false;
        }
        Envelope env = line.getEnvelopeInternal();
        Envelope envelope = this.clipEnv;
        Intrinsics.checkNotNull((Object)envelope);
        return !envelope.covers(env);
    }

    private final List<Coordinate[]> limit(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        LineLimiter lineLimiter = this.limiter;
        Intrinsics.checkNotNull((Object)lineLimiter);
        return lineLimiter.limit(pts);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/operation/overlayng/EdgeNodingBuilder$Companion;", "", "<init>", "()V", "MIN_LIMIT_PTS", "", "IS_NODING_VALIDATED", "", "createFixedPrecisionNoder", "Lorg/locationtech/jts/noding/Noder;", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "createFloatingPrecisionNoder", "doValidation", "removeRepeatedPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "line", "Lorg/locationtech/jts/geom/LineString;", "(Lorg/locationtech/jts/geom/LineString;)[Lorg/locationtech/jts/geom/Coordinate;", "computeDepthDelta", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "isHole", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Noder createFixedPrecisionNoder(PrecisionModel pm) {
            PrecisionModel precisionModel = pm;
            Intrinsics.checkNotNull((Object)precisionModel);
            return new SnapRoundingNoder(precisionModel);
        }

        private final Noder createFloatingPrecisionNoder(boolean doValidation) {
            MCIndexNoder mcNoder = new MCIndexNoder();
            LineIntersector li = new RobustLineIntersector();
            mcNoder.setSegmentIntersector(new IntersectionAdder(li));
            Noder noder = mcNoder;
            if (doValidation) {
                noder = new ValidatingNoder(mcNoder);
            }
            return noder;
        }

        private final Coordinate[] removeRepeatedPoints(LineString line) {
            LineString lineString = line;
            Intrinsics.checkNotNull((Object)lineString);
            Coordinate[] pts = lineString.getCoordinates();
            return CoordinateArrays.INSTANCE.removeRepeatedPoints(pts);
        }

        private final int computeDepthDelta(LinearRing ring, boolean isHole) {
            LinearRing linearRing = ring;
            Intrinsics.checkNotNull((Object)linearRing);
            CoordinateSequence coordinateSequence = linearRing.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence);
            boolean isCCW = Orientation.isCCW(coordinateSequence);
            boolean isOriented = true;
            isOriented = !isHole ? !isCCW : isCCW;
            return isOriented ? 1 : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

