/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0004J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\"\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/overlayng/ElevationModel;", "", "extent", "Lorg/locationtech/jts/geom/Envelope;", "numCellX", "", "numCellY", "<init>", "(Lorg/locationtech/jts/geom/Envelope;II)V", "cellSizeX", "", "cellSizeY", "cells", "", "Lorg/locationtech/jts/operation/overlayng/ElevationModel$ElevationCell;", "[[Lorg/locationtech/jts/operation/overlayng/ElevationModel$ElevationCell;", "isInitialized", "", "hasZValue", "averageZ", "add", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "x", "y", "z", "init", "getZ", "populateZ", "getCell", "isCreateIfMissing", "ElevationCell", "Companion", "kts-core"})
public final class ElevationModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Envelope extent;
    private int numCellX;
    private int numCellY;
    private final double cellSizeX;
    private final double cellSizeY;
    @NotNull
    private final ElevationCell[][] cells;
    private boolean isInitialized;
    private boolean hasZValue;
    private double averageZ;
    private static final int DEFAULT_CELL_NUM = 3;

    public ElevationModel(@NotNull Envelope extent, int numCellX, int numCellY) {
        Intrinsics.checkNotNullParameter((Object)extent, (String)"extent");
        this.extent = extent;
        this.numCellX = numCellX;
        this.numCellY = numCellY;
        this.cellSizeX = this.extent.getWidth() / (double)this.numCellX;
        this.averageZ = Double.NaN;
        this.cellSizeY = this.extent.getHeight() / (double)this.numCellY;
        if (this.cellSizeX <= 0.0) {
            this.numCellX = 1;
        }
        if (this.cellSizeY <= 0.0) {
            this.numCellY = 1;
        }
        int n = 0;
        int n2 = this.numCellX;
        ElevationCell[][] elevationCellArrayArray = new ElevationCell[n2][];
        ElevationModel elevationModel = this;
        while (n < n2) {
            int n3 = n++;
            elevationCellArrayArray[n3] = new ElevationCell[this.numCellY];
        }
        elevationModel.cells = elevationCellArrayArray;
    }

    public final void add(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        geom.apply(new CoordinateSequenceFilter(this){
            private boolean hasZ;
            final /* synthetic */ ElevationModel this$0;
            {
                this.this$0 = $receiver;
                this.hasZ = true;
            }

            public void filter(CoordinateSequence seq, int i) {
                CoordinateSequence coordinateSequence = seq;
                Intrinsics.checkNotNull((Object)coordinateSequence);
                if (!coordinateSequence.hasZ()) {
                    this.hasZ = false;
                    return;
                }
                double z = seq.getOrdinate(i, 2);
                this.this$0.add(seq.getOrdinate(i, 0), seq.getOrdinate(i, 1), z);
            }

            public boolean isDone() {
                return !this.hasZ;
            }

            public boolean isGeometryChanged() {
                return false;
            }
        });
    }

    protected final void add(double x, double y, double z) {
        ElevationCell cell;
        if (Math.INSTANCE.isNaN(z)) {
            return;
        }
        this.hasZValue = true;
        ElevationCell elevationCell = cell = this.getCell(x, y, true);
        Intrinsics.checkNotNull((Object)elevationCell);
        elevationCell.add(z);
    }

    private final void init() {
        this.isInitialized = true;
        int numCells = 0;
        double sumZ = 0.0;
        int n = ((Object[])this.cells).length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.cells[0].length;
            for (int j = 0; j < n2; ++j) {
                ElevationCell cell = this.cells[i][j];
                if (cell == null) continue;
                cell.compute();
                ++numCells;
                sumZ += cell.getZ();
            }
        }
        this.averageZ = Double.NaN;
        if (numCells > 0) {
            this.averageZ = sumZ / (double)numCells;
        }
    }

    public final double getZ(double x, double y) {
        if (!this.isInitialized) {
            this.init();
        }
        ElevationCell elevationCell = this.getCell(x, y, false);
        if (elevationCell == null) {
            return this.averageZ;
        }
        ElevationCell cell = elevationCell;
        return cell.getZ();
    }

    public final void populateZ(@Nullable Geometry geom) {
        if (!this.hasZValue) {
            return;
        }
        if (!this.isInitialized) {
            this.init();
        }
        Geometry geometry = geom;
        Intrinsics.checkNotNull((Object)geometry);
        geometry.apply(new CoordinateSequenceFilter(this){
            private boolean isDone;
            final /* synthetic */ ElevationModel this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isDone() {
                return this.isDone;
            }

            public void filter(CoordinateSequence seq, int i) {
                CoordinateSequence coordinateSequence = seq;
                Intrinsics.checkNotNull((Object)coordinateSequence);
                if (!coordinateSequence.hasZ()) {
                    this.isDone = true;
                    return;
                }
                if (Math.INSTANCE.isNaN(seq.getZ(i))) {
                    double z = this.this$0.getZ(seq.getOrdinate(i, 0), seq.getOrdinate(i, 1));
                    seq.setOrdinate(i, 2, z);
                }
            }

            public boolean isGeometryChanged() {
                return false;
            }
        });
    }

    private final ElevationCell getCell(double x, double y, boolean isCreateIfMissing) {
        int ix = 0;
        if (this.numCellX > 1) {
            ix = (int)((x - this.extent.getMinX()) / this.cellSizeX);
            ix = MathUtil.INSTANCE.clamp(ix, 0, this.numCellX - 1);
        }
        int iy = 0;
        if (this.numCellY > 1) {
            iy = (int)((y - this.extent.getMinY()) / this.cellSizeY);
            iy = MathUtil.INSTANCE.clamp(iy, 0, this.numCellY - 1);
        }
        ElevationCell cell = this.cells[ix][iy];
        if (isCreateIfMissing && cell == null) {
            this.cells[ix][iy] = cell = new ElevationCell();
        }
        return cell;
    }

    @JvmStatic
    @NotNull
    public static final ElevationModel create(@Nullable Geometry geom1, @Nullable Geometry geom2) {
        return Companion.create(geom1, geom2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/operation/overlayng/ElevationModel$Companion;", "", "<init>", "()V", "DEFAULT_CELL_NUM", "", "create", "Lorg/locationtech/jts/operation/overlayng/ElevationModel;", "geom1", "Lorg/locationtech/jts/geom/Geometry;", "geom2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ElevationModel create(@Nullable Geometry geom1, @Nullable Geometry geom2) {
            Geometry geometry = geom1;
            Intrinsics.checkNotNull((Object)geometry);
            Envelope extent = geometry.getEnvelopeInternal().copy();
            if (geom2 != null) {
                extent.expandToInclude(geom2.getEnvelopeInternal());
            }
            ElevationModel model = new ElevationModel(extent, 3, 3);
            model.add(geom1);
            if (geom2 != null) {
                model.add(geom2);
            }
            return model;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/overlayng/ElevationModel$ElevationCell;", "", "<init>", "()V", "numZ", "", "sumZ", "", "value", "z", "getZ", "()D", "add", "", "compute", "kts-core"})
    public static final class ElevationCell {
        private int numZ;
        private double sumZ;
        private double z;

        public final double getZ() {
            return this.z;
        }

        public final void add(double z) {
            int n = this.numZ;
            this.numZ = n + 1;
            this.sumZ += z;
        }

        public final void compute() {
            this.z = Double.NaN;
            if (this.numZ > 0) {
                this.z = this.sumZ / (double)this.numZ;
            }
        }
    }
}

