/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlayng.OverlayUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/operation/overlayng/FastOverlayFilter;", "", "targetGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "isTargetRectangle", "", "overlay", "geom", "overlayOpCode", "", "intersection", "createEmpty", "intersectionRectangle", "isEnvelopeIntersects", "a", "b", "isEnvelopeCovers", "kts-core"})
public final class FastOverlayFilter {
    @NotNull
    private final Geometry targetGeom;
    private final boolean isTargetRectangle;

    public FastOverlayFilter(@NotNull Geometry targetGeom) {
        Intrinsics.checkNotNullParameter((Object)targetGeom, (String)"targetGeom");
        this.targetGeom = targetGeom;
        this.isTargetRectangle = this.targetGeom.isRectangle();
    }

    @Nullable
    public final Geometry overlay(@NotNull Geometry geom, int overlayOpCode) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return overlayOpCode != 1 ? null : this.intersection(geom);
    }

    private final Geometry intersection(Geometry geom) {
        Geometry resultForRect = this.intersectionRectangle(geom);
        if (resultForRect != null) {
            return resultForRect;
        }
        return !this.isEnvelopeIntersects(this.targetGeom, geom) ? this.createEmpty(geom) : null;
    }

    private final Geometry createEmpty(Geometry geom) {
        return OverlayUtil.INSTANCE.createEmptyResult(geom.getDimension(), geom.getFactory());
    }

    private final Geometry intersectionRectangle(Geometry geom) {
        if (!this.isTargetRectangle) {
            return null;
        }
        if (this.isEnvelopeCovers(this.targetGeom, geom)) {
            return geom.copy();
        }
        return !this.isEnvelopeIntersects(this.targetGeom, geom) ? this.createEmpty(geom) : null;
    }

    private final boolean isEnvelopeIntersects(Geometry a, Geometry b) {
        return a.getEnvelopeInternal().intersects(b.getEnvelopeInternal());
    }

    private final boolean isEnvelopeCovers(Geometry a, Geometry b) {
        return a.getEnvelopeInternal().covers(b.getEnvelopeInternal());
    }
}

