/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/operation/overlayng/LineLimiter;", "", "limitEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "ptList", "Lorg/locationtech/jts/geom/CoordinateList;", "lastOutside", "Lorg/locationtech/jts/geom/Coordinate;", "sections", "", "", "limit", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/List;", "addPoint", "", "p", "addOutside", "isLastSegmentIntersecting", "", "isSectionOpen", "()Z", "startSection", "finishSection", "kts-core"})
public final class LineLimiter {
    @NotNull
    private final Envelope limitEnv;
    @Nullable
    private CoordinateList ptList;
    @Nullable
    private Coordinate lastOutside;
    @Nullable
    private List<Coordinate[]> sections;

    public LineLimiter(@NotNull Envelope limitEnv) {
        Intrinsics.checkNotNullParameter((Object)limitEnv, (String)"limitEnv");
        this.limitEnv = limitEnv;
    }

    @Nullable
    public final List<Coordinate[]> limit(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.lastOutside = null;
        this.ptList = null;
        this.sections = new ArrayList();
        for (Coordinate p : pts) {
            if (this.limitEnv.intersects(p)) {
                this.addPoint(p);
                continue;
            }
            this.addOutside(p);
        }
        this.finishSection();
        return this.sections;
    }

    private final void addPoint(Coordinate p) {
        if (p == null) {
            return;
        }
        this.startSection();
        CoordinateList coordinateList = this.ptList;
        Intrinsics.checkNotNull((Object)coordinateList);
        coordinateList.add(p, false);
    }

    private final void addOutside(Coordinate p) {
        boolean segIntersects = this.isLastSegmentIntersecting(p);
        if (!segIntersects) {
            this.finishSection();
        } else {
            this.addPoint(this.lastOutside);
            this.addPoint(p);
        }
        this.lastOutside = p;
    }

    private final boolean isLastSegmentIntersecting(Coordinate p) {
        boolean bl;
        if (this.lastOutside == null) {
            bl = this.isSectionOpen();
        } else {
            Coordinate coordinate = this.lastOutside;
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = p;
            Intrinsics.checkNotNull((Object)coordinate2);
            bl = this.limitEnv.intersects(coordinate, coordinate2);
        }
        return bl;
    }

    private final boolean isSectionOpen() {
        return this.ptList != null;
    }

    private final void startSection() {
        if (this.ptList == null) {
            this.ptList = new CoordinateList();
        }
        if (this.lastOutside != null) {
            CoordinateList coordinateList = this.ptList;
            Intrinsics.checkNotNull((Object)coordinateList);
            coordinateList.add((Object)this.lastOutside, false);
        }
        this.lastOutside = null;
    }

    private final void finishSection() {
        if (this.ptList == null) {
            return;
        }
        if (this.lastOutside != null) {
            CoordinateList coordinateList = this.ptList;
            Intrinsics.checkNotNull((Object)coordinateList);
            coordinateList.add((Object)this.lastOutside, false);
            this.lastOutside = null;
        }
        CoordinateList coordinateList = this.ptList;
        Intrinsics.checkNotNull((Object)coordinateList);
        Coordinate[] section = coordinateList.toCoordinateArray();
        List<Coordinate[]> list = this.sections;
        Intrinsics.checkNotNull(list);
        list.add(section);
        this.ptList = null;
    }
}

