/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.overlayng.OverlayEdge;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u001e\u001a\u00020\u000eJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u0000J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u0004\u0018\u00010\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000(J\u0010\u0010)\u001a\u00020\u000e2\b\u0010*\u001a\u0004\u0018\u00010\u0013J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u00101\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "", "start", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/OverlayEdge;Lorg/locationtech/jts/geom/GeometryFactory;)V", "startEdge", "value", "Lorg/locationtech/jts/geom/LinearRing;", "ring", "getRing", "()Lorg/locationtech/jts/geom/LinearRing;", "", "isHole", "()Z", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "locator", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "getLocator", "()Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "shell", "holes", "", "setShell", "", "hasShell", "getShell", "addHole", "computeRingPts", "(Lorg/locationtech/jts/operation/overlayng/OverlayEdge;)[Lorg/locationtech/jts/geom/Coordinate;", "computeRing", "ringPts", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/GeometryFactory;)V", "findEdgeRingContaining", "erList", "", "isInRing", "pt", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "toPolygon", "Lorg/locationtech/jts/geom/Polygon;", "factory", "edge", "getEdge", "()Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "kts-core"})
public final class OverlayEdgeRing {
    @Nullable
    private final OverlayEdge startEdge;
    @Nullable
    private LinearRing ring;
    private boolean isHole;
    @NotNull
    private final Coordinate[] coordinates;
    @Nullable
    private IndexedPointInAreaLocator locator;
    @Nullable
    private OverlayEdgeRing shell;
    @NotNull
    private final List<OverlayEdgeRing> holes;

    public OverlayEdgeRing(@NotNull OverlayEdge start, @NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.holes = new ArrayList();
        this.startEdge = start;
        this.coordinates = this.computeRingPts(start);
        this.computeRing(this.coordinates, geometryFactory);
    }

    @Nullable
    public final LinearRing getRing() {
        return this.ring;
    }

    public final boolean isHole() {
        return this.isHole;
    }

    private final IndexedPointInAreaLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.ring);
        }
        return this.locator;
    }

    public final void setShell(@Nullable OverlayEdgeRing shell) {
        block0: {
            this.shell = shell;
            OverlayEdgeRing overlayEdgeRing = shell;
            if (overlayEdgeRing == null) break block0;
            overlayEdgeRing.addHole(this);
        }
    }

    public final boolean hasShell() {
        return this.shell != null;
    }

    @Nullable
    public final OverlayEdgeRing getShell() {
        return this.isHole ? this.shell : this;
    }

    public final void addHole(@NotNull OverlayEdgeRing ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        this.holes.add(ring);
    }

    private final Coordinate[] computeRingPts(OverlayEdge start) {
        OverlayEdge edge = start;
        CoordinateList pts = new CoordinateList();
        do {
            if (edge.getEdgeRing() == this) {
                throw new TopologyException("Edge visited twice during ring-building at " + edge.getCoordinate(), edge.getCoordinate());
            }
            edge.addCoordinates(pts);
            edge.setEdgeRing(this);
            if (edge.nextResult() == null) {
                throw new TopologyException("Found null edge in ring", edge.dest());
            }
            Intrinsics.checkNotNull((Object)edge.nextResult());
        } while (edge != start);
        pts.closeRing();
        return pts.toCoordinateArray();
    }

    private final void computeRing(Coordinate[] ringPts, GeometryFactory geometryFactory) {
        if (this.ring != null) {
            return;
        }
        LinearRing linearRing = this.ring = geometryFactory.createLinearRing(ringPts);
        Intrinsics.checkNotNull((Object)linearRing);
        this.isHole = Orientation.isCCW(linearRing.getCoordinates());
    }

    @Nullable
    public final OverlayEdgeRing findEdgeRingContaining(@NotNull List<OverlayEdgeRing> erList) {
        LinearRing testRing;
        Intrinsics.checkNotNullParameter(erList, (String)"erList");
        LinearRing linearRing = testRing = this.ring;
        Intrinsics.checkNotNull((Object)linearRing);
        Envelope testEnv = linearRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        OverlayEdgeRing minRing = null;
        Envelope minRingEnv = null;
        for (OverlayEdgeRing tryEdgeRing : erList) {
            boolean isContained;
            LinearRing tryRing;
            LinearRing linearRing2 = tryRing = tryEdgeRing.ring;
            Intrinsics.checkNotNull((Object)linearRing2);
            Envelope tryShellEnv = linearRing2.getEnvelopeInternal();
            if (Intrinsics.areEqual((Object)tryShellEnv, (Object)testEnv) || !tryShellEnv.contains(testEnv) || !(isContained = tryEdgeRing.isInRing(testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryEdgeRing.coordinates)))) continue;
            if (minRing != null) {
                Envelope envelope = minRingEnv;
                Intrinsics.checkNotNull(envelope);
                if (!envelope.contains(tryShellEnv)) continue;
            }
            minRing = tryEdgeRing;
            LinearRing linearRing3 = minRing.ring;
            Intrinsics.checkNotNull((Object)linearRing3);
            minRingEnv = linearRing3.getEnvelopeInternal();
        }
        return minRing;
    }

    public final boolean isInRing(@Nullable Coordinate pt) {
        IndexedPointInAreaLocator indexedPointInAreaLocator = this.getLocator();
        Intrinsics.checkNotNull((Object)indexedPointInAreaLocator);
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return 2 != indexedPointInAreaLocator.locate(coordinate);
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return this.coordinates[0];
    }

    @NotNull
    public final Polygon toPolygon(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Object[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            int n = ((Collection)this.holes).size();
            for (int i = 0; i < n; ++i) {
                holeLR[i] = this.holes.get((int)i).ring;
            }
        }
        return factory.createPolygon(this.ring, (LinearRing[])(holeLR != null ? (LinearRing[])ArraysKt.requireNoNulls((Object[])holeLR) : null));
    }

    @Nullable
    public final OverlayEdge getEdge() {
        return this.startEdge;
    }
}

