/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\tJ!\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "", "<init>", "()V", "edges", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "nodeMap", "", "Lorg/locationtech/jts/geom/Coordinate;", "getEdges", "", "nodeEdges", "getNodeEdges", "()Ljava/util/Collection;", "getNodeEdge", "nodePt", "resultAreaEdges", "", "getResultAreaEdges", "()Ljava/util/List;", "addEdge", "pts", "", "label", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/overlayng/OverlayLabel;)Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "insert", "", "e", "kts-core"})
public final class OverlayGraph {
    @NotNull
    private final List<OverlayEdge> edges = new ArrayList();
    @NotNull
    private final Map<Coordinate, OverlayEdge> nodeMap = new HashMap();

    @NotNull
    public final Collection<OverlayEdge> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Collection<OverlayEdge> getNodeEdges() {
        return this.nodeMap.values();
    }

    @Nullable
    public final OverlayEdge getNodeEdge(@NotNull Coordinate nodePt) {
        Intrinsics.checkNotNullParameter((Object)nodePt, (String)"nodePt");
        return this.nodeMap.get(nodePt);
    }

    @NotNull
    public final List<OverlayEdge> getResultAreaEdges() {
        List resultEdges = new ArrayList();
        for (OverlayEdge edge : this.getEdges()) {
            if (!edge.isInResultArea()) continue;
            resultEdges.add(edge);
        }
        return resultEdges;
    }

    @NotNull
    public final OverlayEdge addEdge(@NotNull Coordinate[] pts, @NotNull OverlayLabel label) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        OverlayEdge e = OverlayEdge.Companion.createEdgePair(pts, label);
        this.insert(e);
        this.insert(e.symOE());
        return e;
    }

    private final void insert(OverlayEdge e) {
        this.edges.add(e);
        OverlayEdge nodeEdge = this.nodeMap.get(e.orig());
        if (nodeEdge != null) {
            nodeEdge.insert(e);
        } else {
            this.nodeMap.put(e.orig(), e);
        }
    }
}

