/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0010\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayLabeller;", "", "graph", "Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "inputGeometry", "Lorg/locationtech/jts/operation/overlayng/InputGeometry;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/OverlayGraph;Lorg/locationtech/jts/operation/overlayng/InputGeometry;)V", "edges", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "computeLabelling", "", "labelAreaNodeEdges", "nodes", "propagateAreaLocations", "nodeEdge", "geomIndex", "", "labelCollapsedEdges", "labelCollapsedEdge", "edge", "labelConnectedLinearEdges", "propagateLinearLocations", "labelDisconnectedEdges", "labelDisconnectedEdge", "locateEdge", "locateEdgeBothEnds", "markResultAreaEdges", "overlayOpCode", "markInResultArea", "e", "unmarkDuplicateEdgesFromResultArea", "Companion", "kts-core"})
public final class OverlayLabeller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OverlayGraph graph;
    @NotNull
    private final InputGeometry inputGeometry;
    @NotNull
    private final Collection<OverlayEdge> edges;

    public OverlayLabeller(@NotNull OverlayGraph graph, @NotNull InputGeometry inputGeometry) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)inputGeometry, (String)"inputGeometry");
        this.graph = graph;
        this.inputGeometry = inputGeometry;
        this.edges = graph.getEdges();
    }

    public final void computeLabelling() {
        Collection<OverlayEdge> nodes = this.graph.getNodeEdges();
        this.labelAreaNodeEdges(nodes);
        this.labelConnectedLinearEdges();
        this.labelCollapsedEdges();
        this.labelConnectedLinearEdges();
        this.labelDisconnectedEdges();
    }

    private final void labelAreaNodeEdges(Collection<OverlayEdge> nodes) {
        for (OverlayEdge nodeEdge : nodes) {
            this.propagateAreaLocations(nodeEdge, 0);
            if (!this.inputGeometry.hasEdges(1)) continue;
            this.propagateAreaLocations(nodeEdge, 1);
        }
    }

    public final void propagateAreaLocations(@NotNull OverlayEdge nodeEdge, int geomIndex) {
        Intrinsics.checkNotNullParameter((Object)nodeEdge, (String)"nodeEdge");
        if (!this.inputGeometry.isArea(geomIndex)) {
            return;
        }
        if (nodeEdge.degree() == 1) {
            return;
        }
        OverlayEdge overlayEdge = OverlayLabeller.Companion.findPropagationStartEdge(nodeEdge, geomIndex);
        if (overlayEdge == null) {
            return;
        }
        OverlayEdge eStart = overlayEdge;
        int currLoc = eStart.getLocation(geomIndex, 1);
        OverlayEdge e = eStart.oNextOE();
        do {
            OverlayLabel label;
            if (!(label = e.getLabel()).isBoundary(geomIndex)) {
                label.setLocationLine(geomIndex, currLoc);
                continue;
            }
            Assert.isTrue(label.hasSides(geomIndex));
            int locRight = e.getLocation(geomIndex, 2);
            if (locRight != currLoc) {
                throw new TopologyException("side location conflict: arg " + geomIndex, e.getCoordinate());
            }
            int locLeft = e.getLocation(geomIndex, 1);
            if (locLeft == -1) {
                Assert.shouldNeverReachHere("found single null side at " + e);
            }
            currLoc = locLeft;
        } while ((e = e.oNextOE()) != eStart);
    }

    private final void labelCollapsedEdges() {
        for (OverlayEdge edge : this.edges) {
            if (edge.getLabel().isLineLocationUnknown(0)) {
                this.labelCollapsedEdge(edge, 0);
            }
            if (!edge.getLabel().isLineLocationUnknown(1)) continue;
            this.labelCollapsedEdge(edge, 1);
        }
    }

    private final void labelCollapsedEdge(OverlayEdge edge, int geomIndex) {
        OverlayLabel label = edge.getLabel();
        if (!label.isCollapse(geomIndex)) {
            return;
        }
        label.setLocationCollapse(geomIndex);
    }

    private final void labelConnectedLinearEdges() {
        this.propagateLinearLocations(0);
        if (this.inputGeometry.hasEdges(1)) {
            this.propagateLinearLocations(1);
        }
    }

    private final void propagateLinearLocations(int geomIndex) {
        List linearEdges = OverlayLabeller.Companion.findLinearEdgesWithLocation(this.edges, geomIndex);
        if (linearEdges.isEmpty()) {
            return;
        }
        ArrayDeque edgeStack = new ArrayDeque((Collection)linearEdges);
        boolean isInputLine = this.inputGeometry.isLine(geomIndex);
        while (!edgeStack.isEmpty()) {
            OverlayEdge lineEdge = (OverlayEdge)edgeStack.removeFirst();
            OverlayLabeller.Companion.propagateLinearLocationAtNode(lineEdge, geomIndex, isInputLine, (ArrayDeque<OverlayEdge>)edgeStack);
        }
    }

    private final void labelDisconnectedEdges() {
        for (OverlayEdge edge : this.edges) {
            if (edge.getLabel().isLineLocationUnknown(0)) {
                this.labelDisconnectedEdge(edge, 0);
            }
            if (!edge.getLabel().isLineLocationUnknown(1)) continue;
            this.labelDisconnectedEdge(edge, 1);
        }
    }

    private final void labelDisconnectedEdge(OverlayEdge edge, int geomIndex) {
        OverlayLabel label = edge.getLabel();
        if (!this.inputGeometry.isArea(geomIndex)) {
            label.setLocationAll(geomIndex, 2);
            return;
        }
        int edgeLoc = this.locateEdgeBothEnds(geomIndex, edge);
        label.setLocationAll(geomIndex, edgeLoc);
    }

    private final int locateEdge(int geomIndex, OverlayEdge edge) {
        int loc = this.inputGeometry.locatePointInArea(geomIndex, edge.orig());
        return loc != 2 ? 0 : 2;
    }

    private final int locateEdgeBothEnds(int geomIndex, OverlayEdge edge) {
        int locOrig = this.inputGeometry.locatePointInArea(geomIndex, edge.orig());
        int locDest = this.inputGeometry.locatePointInArea(geomIndex, edge.dest());
        boolean isInt = locOrig != 2 && locDest != 2;
        return isInt ? 0 : 2;
    }

    public final void markResultAreaEdges(int overlayOpCode) {
        for (OverlayEdge edge : this.edges) {
            this.markInResultArea(edge, overlayOpCode);
        }
    }

    public final void markInResultArea(@NotNull OverlayEdge e, int overlayOpCode) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        OverlayLabel label = e.getLabel();
        if (label.isBoundaryEither() && OverlayNG.Companion.isResultOfOp(overlayOpCode, label.getLocationBoundaryOrLine(0, 2, e.isForward()), label.getLocationBoundaryOrLine(1, 2, e.isForward()))) {
            e.markInResultArea();
        }
    }

    public final void unmarkDuplicateEdgesFromResultArea() {
        for (OverlayEdge edge : this.edges) {
            if (!edge.isInResultAreaBoth()) continue;
            edge.unmarkFromResultAreaBoth();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0002J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayLabeller$Companion;", "", "<init>", "()V", "findPropagationStartEdge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "nodeEdge", "geomIndex", "", "propagateLinearLocationAtNode", "", "eNode", "isInputLine", "", "edgeStack", "Lkotlin/collections/ArrayDeque;", "findLinearEdgesWithLocation", "", "edges", "", "toString", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final OverlayEdge findPropagationStartEdge(OverlayEdge nodeEdge, int geomIndex) {
            HalfEdge halfEdge;
            OverlayEdge eStart = nodeEdge;
            do {
                OverlayLabel label;
                if ((label = eStart.getLabel()).isBoundary(geomIndex)) {
                    Assert.isTrue(label.hasSides(geomIndex));
                    return eStart;
                }
                halfEdge = eStart.oNext();
                Intrinsics.checkNotNull((Object)halfEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlayng.OverlayEdge");
            } while ((eStart = (OverlayEdge)halfEdge) != nodeEdge);
            return null;
        }

        private final void propagateLinearLocationAtNode(OverlayEdge eNode, int geomIndex, boolean isInputLine, ArrayDeque<OverlayEdge> edgeStack) {
            int lineLoc = eNode.getLabel().getLineLocation(geomIndex);
            if (isInputLine && lineLoc != 2) {
                return;
            }
            OverlayEdge e = eNode.oNextOE();
            do {
                OverlayLabel label;
                if (!(label = e.getLabel()).isLineLocationUnknown(geomIndex)) continue;
                label.setLocationLine(geomIndex, lineLoc);
                edgeStack.addFirst((Object)e.symOE());
            } while ((e = e.oNextOE()) != eNode);
        }

        private final List<OverlayEdge> findLinearEdgesWithLocation(Collection<OverlayEdge> edges, int geomIndex) {
            List linearEdges = new ArrayList();
            for (OverlayEdge edge : edges) {
                OverlayLabel lbl = edge.getLabel();
                if (!lbl.isLinear(geomIndex) || lbl.isLineLocationUnknown(geomIndex)) continue;
                linearEdges.add(edge);
            }
            return linearEdges;
        }

        @NotNull
        public final String toString(@NotNull OverlayEdge nodeEdge) {
            Intrinsics.checkNotNullParameter((Object)nodeEdge, (String)"nodeEdge");
            Coordinate orig = nodeEdge.orig();
            StringBuilder sb = new StringBuilder();
            sb.append("Node( " + WKTWriter.Companion.format(orig) + " )\n");
            OverlayEdge e = nodeEdge;
            do {
                sb.append("  -> " + e);
                if (e.isResultLinked()) {
                    sb.append(" Link: ");
                    sb.append(e.nextResult());
                }
                sb.append("\n");
            } while ((e = e.oNextOE()) != nodeEdge);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

