/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.IndexedPointOnLineLocator;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u001c\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010\"\u001a\u0004\u0018\u00010\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u0016\u0010#\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J)\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010(\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0002J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u001fH\u0002J\n\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayMixedPoints;", "", "opCode", "", "geom0", "Lorg/locationtech/jts/geom/Geometry;", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(ILorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;)V", "geomPoint", "geomNonPointInput", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "isPointRHS", "", "geomNonPoint", "geomNonPointDim", "locator", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "resultDim", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "createLocator", "prepareNonPoint", "geomInput", "computeIntersection", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Geometry;", "computeUnion", "computeDifference", "createPointResult", "points", "", "Lorg/locationtech/jts/geom/Point;", "findPoints", "isCovered", "(Z[Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/List;", "createPoints", "", "hasLocation", "coord", "copyNonPoint", "Companion", "kts-core"})
public final class OverlayMixedPoints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int opCode;
    @Nullable
    private final PrecisionModel pm;
    @Nullable
    private Geometry geomPoint;
    @Nullable
    private Geometry geomNonPointInput;
    @NotNull
    private final GeometryFactory geometryFactory;
    private boolean isPointRHS;
    @Nullable
    private Geometry geomNonPoint;
    private int geomNonPointDim;
    @Nullable
    private PointOnGeometryLocator locator;
    private final int resultDim;

    public OverlayMixedPoints(int opCode, @Nullable Geometry geom0, @Nullable Geometry geom1, @Nullable PrecisionModel pm) {
        this.opCode = opCode;
        this.pm = pm;
        Geometry geometry = geom0;
        Intrinsics.checkNotNull((Object)geometry);
        this.geometryFactory = geometry.getFactory();
        int n = geom0.getDimension();
        Geometry geometry2 = geom1;
        Intrinsics.checkNotNull((Object)geometry2);
        this.resultDim = OverlayUtil.INSTANCE.resultDimension(this.opCode, n, geometry2.getDimension());
        if (geom0.getDimension() == 0) {
            this.geomPoint = geom0;
            this.geomNonPointInput = geom1;
            this.isPointRHS = false;
        } else {
            this.geomPoint = geom1;
            this.geomNonPointInput = geom0;
            this.isPointRHS = true;
        }
    }

    @Nullable
    public final Geometry getResult() {
        Geometry geometry = this.geomNonPoint = this.prepareNonPoint(this.geomNonPointInput);
        Intrinsics.checkNotNull((Object)geometry);
        this.geomNonPointDim = geometry.getDimension();
        this.locator = this.createLocator(this.geomNonPoint);
        Coordinate[] coords = OverlayMixedPoints.Companion.extractCoordinates(this.geomPoint, this.pm);
        switch (this.opCode) {
            case 1: {
                return this.computeIntersection(coords);
            }
            case 2: 
            case 4: {
                return this.computeUnion(coords);
            }
            case 3: {
                return this.computeDifference(coords);
            }
        }
        Assert.shouldNeverReachHere("Unknown overlay op code");
        return null;
    }

    private final PointOnGeometryLocator createLocator(Geometry geomNonPoint) {
        return this.geomNonPointDim == 2 ? (PointOnGeometryLocator)new IndexedPointInAreaLocator(geomNonPoint) : (PointOnGeometryLocator)new IndexedPointOnLineLocator(geomNonPoint);
    }

    private final Geometry prepareNonPoint(Geometry geomInput) {
        return this.resultDim == 0 ? geomInput : OverlayNG.Companion.union(this.geomNonPointInput, this.pm);
    }

    private final Geometry computeIntersection(Coordinate[] coords) {
        return this.createPointResult(this.findPoints(true, coords));
    }

    private final Geometry computeUnion(Coordinate[] coords) {
        List<Point> resultPointList = this.findPoints(false, coords);
        List resultLineList = null;
        if (this.geomNonPointDim == 1) {
            resultLineList = OverlayMixedPoints.Companion.extractLines(this.geomNonPoint);
        }
        List resultPolyList = null;
        if (this.geomNonPointDim == 2) {
            resultPolyList = OverlayMixedPoints.Companion.extractPolygons(this.geomNonPoint);
        }
        return OverlayUtil.INSTANCE.createResultGeometry(resultPolyList, resultLineList, resultPointList, this.geometryFactory);
    }

    private final Geometry computeDifference(Coordinate[] coords) {
        return this.isPointRHS ? this.copyNonPoint() : this.createPointResult(this.findPoints(false, coords));
    }

    private final Geometry createPointResult(List<Point> points) {
        if (points.isEmpty()) {
            return this.geometryFactory.createEmpty(0);
        }
        if (points.size() == 1) {
            return points.get(0);
        }
        Point[] pointsArray = GeometryFactory.Companion.toPointArray((Collection<? extends Geometry>)points);
        return this.geometryFactory.createMultiPoint(pointsArray);
    }

    private final List<Point> findPoints(boolean isCovered, Coordinate[] coords) {
        Set resultCoords = new HashSet();
        for (Coordinate coord : coords) {
            if (!this.hasLocation(isCovered, coord)) continue;
            resultCoords.add(coord.copy());
        }
        return this.createPoints(resultCoords);
    }

    private final List<Point> createPoints(Set<? extends Coordinate> coords) {
        List points = new ArrayList();
        for (Coordinate coordinate : coords) {
            Point point = this.geometryFactory.createPoint(coordinate);
            points.add(point);
        }
        return points;
    }

    private final boolean hasLocation(boolean isCovered, Coordinate coord) {
        boolean isExterior;
        PointOnGeometryLocator pointOnGeometryLocator = this.locator;
        Intrinsics.checkNotNull((Object)pointOnGeometryLocator);
        boolean bl = isExterior = 2 == pointOnGeometryLocator.locate(coord);
        return isCovered ? !isExterior : isExterior;
    }

    private final Geometry copyNonPoint() {
        Geometry geometry;
        if (this.geomNonPointInput != this.geomNonPoint) {
            geometry = this.geomNonPoint;
        } else {
            Geometry geometry2 = this.geomNonPoint;
            Intrinsics.checkNotNull((Object)geometry2);
            geometry = geometry2.copy();
        }
        return geometry;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayMixedPoints$Companion;", "", "<init>", "()V", "overlay", "Lorg/locationtech/jts/geom/Geometry;", "opCode", "", "geom0", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "extractCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "points", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;)[Lorg/locationtech/jts/geom/Coordinate;", "extractPolygons", "", "Lorg/locationtech/jts/geom/Polygon;", "geom", "extractLines", "Lorg/locationtech/jts/geom/LineString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry overlay(int opCode, @Nullable Geometry geom0, @Nullable Geometry geom1, @Nullable PrecisionModel pm) {
            OverlayMixedPoints overlay = new OverlayMixedPoints(opCode, geom0, geom1, pm);
            return overlay.getResult();
        }

        private final Coordinate[] extractCoordinates(Geometry points, PrecisionModel pm) {
            CoordinateList coords = new CoordinateList();
            Geometry geometry = points;
            Intrinsics.checkNotNull((Object)geometry);
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry2 = points.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                Point point = (Point)geometry2;
                if (point.isEmpty()) continue;
                Coordinate coord = OverlayUtil.INSTANCE.round(point, pm);
                coords.add((Object)coord, true);
            }
            return coords.toCoordinateArray();
        }

        private final List<Polygon> extractPolygons(Geometry geom) {
            List list = new ArrayList();
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry2 = geom.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                Polygon poly = (Polygon)geometry2;
                if (poly.isEmpty()) continue;
                list.add(poly);
            }
            return list;
        }

        private final List<LineString> extractLines(Geometry geom) {
            List list = new ArrayList();
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry2 = geom.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line = (LineString)geometry2;
                if (line.isEmpty()) continue;
                list.add(line);
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

