/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeNodingBuilder;
import org.locationtech.jts.operation.overlayng.ElevationModel;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.IntersectionPointBuilder;
import org.locationtech.jts.operation.overlayng.LineBuilder;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;
import org.locationtech.jts.operation.overlayng.OverlayLabeller;
import org.locationtech.jts.operation.overlayng.OverlayMixedPoints;
import org.locationtech.jts.operation.overlayng.OverlayPoints;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.operation.overlayng.PolygonBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u00012B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bB\u001d\b\u0010\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\"\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\n\u0010&\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u0016\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0002J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020+H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010/\u001a\u00020+H\u0002J\n\u00101\u001a\u0004\u0018\u00010\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayNG;", "", "geom0", "Lorg/locationtech/jts/geom/Geometry;", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "opCode", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;I)V", "geom", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;)V", "inputGeom", "Lorg/locationtech/jts/operation/overlayng/InputGeometry;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "noder", "Lorg/locationtech/jts/noding/Noder;", "isStrictMode", "", "isOptimized", "isAreaResultOnly", "isOutputEdges", "isOutputResultEdges", "isOutputNodedEdges", "setStrictMode", "", "setOptimized", "setAreaResultOnly", "setOutputEdges", "setOutputNodedEdges", "setOutputResultEdges", "setNoder", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "computeEdgeOverlay", "nodeEdges", "", "Lorg/locationtech/jts/operation/overlayng/Edge;", "buildGraph", "Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "edges", "", "labelGraph", "graph", "extractResult", "createEmptyResult", "Companion", "kts-core"})
public final class OverlayNG {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PrecisionModel pm;
    private final int opCode;
    @NotNull
    private final InputGeometry inputGeom;
    @NotNull
    private final GeometryFactory geomFact;
    @Nullable
    private Noder noder;
    private boolean isStrictMode;
    private boolean isOptimized;
    private boolean isAreaResultOnly;
    private boolean isOutputEdges;
    private boolean isOutputResultEdges;
    private boolean isOutputNodedEdges;
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;
    public static final boolean STRICT_MODE_DEFAULT = false;

    public OverlayNG(@Nullable Geometry geom0, @Nullable Geometry geom1, @Nullable PrecisionModel pm, int opCode) {
        this.pm = pm;
        this.opCode = opCode;
        this.isOptimized = true;
        Geometry geometry = geom0;
        Intrinsics.checkNotNull((Object)geometry);
        this.geomFact = geometry.getFactory();
        this.inputGeom = new InputGeometry(geom0, geom1);
    }

    public OverlayNG(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode) {
        Geometry geometry = geom0;
        Intrinsics.checkNotNull((Object)geometry);
        this(geom0, geom1, geometry.getFactory().getPrecisionModel(), opCode);
    }

    public OverlayNG(@Nullable Geometry geom, @Nullable PrecisionModel pm) {
        this(geom, null, pm, 2);
    }

    public final void setStrictMode(boolean isStrictMode) {
        this.isStrictMode = isStrictMode;
    }

    public final void setOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
    }

    public final void setAreaResultOnly(boolean isAreaResultOnly) {
        this.isAreaResultOnly = isAreaResultOnly;
    }

    public final void setOutputEdges(boolean isOutputEdges) {
        this.isOutputEdges = isOutputEdges;
    }

    public final void setOutputNodedEdges(boolean isOutputNodedEdges) {
        this.isOutputEdges = true;
        this.isOutputNodedEdges = isOutputNodedEdges;
    }

    public final void setOutputResultEdges(boolean isOutputResultEdges) {
        this.isOutputResultEdges = isOutputResultEdges;
    }

    public final void setNoder(@Nullable Noder noder) {
        this.noder = noder;
    }

    @Nullable
    public final Geometry getResult() {
        if (OverlayUtil.INSTANCE.isEmptyResult(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm)) {
            return this.createEmptyResult();
        }
        ElevationModel elevModel = ElevationModel.Companion.create(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1));
        Geometry result2 = this.inputGeom.isAllPoints() ? OverlayPoints.Companion.overlay(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm) : (!this.inputGeom.isSingle() && this.inputGeom.hasPoints() ? OverlayMixedPoints.Companion.overlay(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm) : this.computeEdgeOverlay());
        elevModel.populateZ(result2);
        return result2;
    }

    private final Geometry computeEdgeOverlay() {
        boolean isAreaConsistent;
        List<Edge> edges = this.nodeEdges();
        OverlayGraph graph = this.buildGraph((Collection<Edge>)edges);
        if (this.isOutputNodedEdges) {
            return OverlayUtil.INSTANCE.toLines(graph, this.isOutputEdges, this.geomFact);
        }
        this.labelGraph(graph);
        if (this.isOutputEdges || this.isOutputResultEdges) {
            return OverlayUtil.INSTANCE.toLines(graph, this.isOutputEdges, this.geomFact);
        }
        Geometry result2 = this.extractResult(this.opCode, graph);
        if (OverlayUtil.INSTANCE.isFloating(this.pm) && !(isAreaConsistent = OverlayUtil.INSTANCE.isResultAreaConsistent(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.opCode, result2))) {
            throw new TopologyException("Result area inconsistent with overlay operation");
        }
        return result2;
    }

    private final List<Edge> nodeEdges() {
        Envelope clipEnv;
        EdgeNodingBuilder nodingBuilder = new EdgeNodingBuilder(this.pm, this.noder);
        if (this.isOptimized && (clipEnv = OverlayUtil.INSTANCE.clippingEnvelope(this.opCode, this.inputGeom, this.pm)) != null) {
            nodingBuilder.setClipEnvelope(clipEnv);
        }
        List<Edge> mergedEdges = nodingBuilder.build(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1));
        this.inputGeom.setCollapsed(0, !nodingBuilder.hasEdgesFor(0));
        this.inputGeom.setCollapsed(1, !nodingBuilder.hasEdgesFor(1));
        return mergedEdges;
    }

    private final OverlayGraph buildGraph(Collection<Edge> edges) {
        OverlayGraph graph = new OverlayGraph();
        for (Edge e : edges) {
            graph.addEdge(e.getCoordinates(), e.createLabel());
        }
        return graph;
    }

    private final void labelGraph(OverlayGraph graph) {
        OverlayLabeller labeller = new OverlayLabeller(graph, this.inputGeom);
        labeller.computeLabelling();
        labeller.markResultAreaEdges(this.opCode);
        labeller.unmarkDuplicateEdgesFromResultArea();
    }

    /*
     * Unable to fully structure code
     */
    private final Geometry extractResult(int opCode, OverlayGraph graph) {
        block4: {
            isAllowMixedIntResult = this.isStrictMode == false;
            resultAreaEdges = graph.getResultAreaEdges();
            polyBuilder = new PolygonBuilder(resultAreaEdges, this.geomFact, false, 4, null);
            resultPolyList = polyBuilder.getPolygons();
            hasResultAreaComponents = ((Collection)resultPolyList).isEmpty() == false;
            resultLineList = null;
            resultPointList = null;
            if (this.isAreaResultOnly) break block4;
            v0 = allowResultLines = hasResultAreaComponents == false || isAllowMixedIntResult != false || opCode == 4 || opCode == 2;
            if (allowResultLines) {
                lineBuilder = new LineBuilder(this.inputGeom, graph, hasResultAreaComponents, opCode, this.geomFact);
                lineBuilder.setStrictMode(this.isStrictMode);
                resultLineList = lineBuilder.getLines();
            }
            if (hasResultAreaComponents) ** GOTO lbl-1000
            v1 = resultLineList;
            Intrinsics.checkNotNull(v1);
            if (((Collection)v1).isEmpty() == false) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            hasResultComponents = v2;
            v3 = allowResultPoints = hasResultComponents == false || isAllowMixedIntResult != false;
            if (opCode == 1 && allowResultPoints) {
                pointBuilder = new IntersectionPointBuilder(graph, this.geomFact);
                pointBuilder.setStrictMode(this.isStrictMode);
                resultPointList = pointBuilder.getPoints();
            }
        }
        return org.locationtech.jts.operation.overlayng.OverlayNG$Companion.access$isEmpty(OverlayNG.Companion, resultPolyList) != false && org.locationtech.jts.operation.overlayng.OverlayNG$Companion.access$isEmpty(OverlayNG.Companion, resultLineList) != false && org.locationtech.jts.operation.overlayng.OverlayNG$Companion.access$isEmpty(OverlayNG.Companion, resultPointList) != false ? this.createEmptyResult() : OverlayUtil.INSTANCE.createResultGeometry(resultPolyList, resultLineList, resultPointList, this.geomFact);
    }

    private final Geometry createEmptyResult() {
        return OverlayUtil.INSTANCE.createEmptyResult(OverlayUtil.INSTANCE.resultDimension(this.opCode, this.inputGeom.getDimension(0), this.inputGeom.getDimension(1)), this.geomFact);
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable PrecisionModel pm) {
        return Companion.overlay(geom0, geom1, opCode, pm);
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable PrecisionModel pm, @Nullable Noder noder) {
        return Companion.overlay(geom0, geom1, opCode, pm, noder);
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable Noder noder) {
        return Companion.overlay(geom0, geom1, opCode, noder);
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode) {
        return Companion.overlay(geom0, geom1, opCode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J0\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J:\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J0\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J&\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J&\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayNG$Companion;", "", "<init>", "()V", "INTERSECTION", "", "UNION", "DIFFERENCE", "SYMDIFFERENCE", "STRICT_MODE_DEFAULT", "", "isResultOfOpPoint", "label", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "opCode", "isResultOfOp", "overlayOpCode", "loc0", "loc1", "overlay", "Lorg/locationtech/jts/geom/Geometry;", "geom0", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "noder", "Lorg/locationtech/jts/noding/Noder;", "union", "geom", "isEmpty", "list", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isResultOfOpPoint(@NotNull OverlayLabel label, int opCode) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            int loc0 = label.getLocation(0);
            int loc1 = label.getLocation(1);
            return this.isResultOfOp(opCode, loc0, loc1);
        }

        public final boolean isResultOfOp(int overlayOpCode, int loc0, int loc1) {
            int loc02 = loc0;
            int loc12 = loc1;
            if (loc02 == 1) {
                loc02 = 0;
            }
            if (loc12 == 1) {
                loc12 = 0;
            }
            switch (overlayOpCode) {
                case 1: {
                    return loc02 == 0 && loc12 == 0;
                }
                case 2: {
                    return loc02 == 0 || loc12 == 0;
                }
                case 3: {
                    return loc02 == 0 && loc12 != 0;
                }
                case 4: {
                    return loc02 == 0 && loc12 != 0 || loc02 != 0 && loc12 == 0;
                }
            }
            return false;
        }

        @JvmStatic
        @Nullable
        public final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable PrecisionModel pm) {
            OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
            return ov.getResult();
        }

        @JvmStatic
        @Nullable
        public final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable PrecisionModel pm, @Nullable Noder noder) {
            OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
            ov.setNoder(noder);
            return ov.getResult();
        }

        @JvmStatic
        @Nullable
        public final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable Noder noder) {
            OverlayNG ov = new OverlayNG(geom0, geom1, null, opCode);
            ov.setNoder(noder);
            return ov.getResult();
        }

        @JvmStatic
        @Nullable
        public final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode) {
            OverlayNG ov = new OverlayNG(geom0, geom1, opCode);
            return ov.getResult();
        }

        @Nullable
        public final Geometry union(@Nullable Geometry geom, @Nullable PrecisionModel pm) {
            OverlayNG ov = new OverlayNG(geom, pm);
            return ov.getResult();
        }

        @Nullable
        public final Geometry union(@Nullable Geometry geom, @Nullable PrecisionModel pm, @Nullable Noder noder) {
            OverlayNG ov = new OverlayNG(geom, pm);
            ov.setNoder(noder);
            ov.setStrictMode(true);
            return ov.getResult();
        }

        private final boolean isEmpty(List<?> list) {
            return list == null || list.isEmpty();
        }

        public static final /* synthetic */ boolean access$isEmpty(Companion $this, List list) {
            return $this.isEmpty(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

