/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.snap.SnappingNoder;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.PrecisionUtil;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.union.UnionStrategy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0007J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J&\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J&\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u001b\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002J&\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayNGRobust;", "", "<init>", "()V", "union", "Lorg/locationtech/jts/geom/Geometry;", "geom", "geoms", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "OVERLAY_UNION", "Lorg/locationtech/jts/operation/union/UnionStrategy;", "overlay", "geom0", "geom1", "opCode", "", "NUM_SNAP_TRIES", "overlaySnapTries", "overlaySnapping", "snapTol", "", "overlaySnapBoth", "snapSelf", "overlaySnapTol", "SNAP_TOL_FACTOR", "snapTolerance", "ordinateMagnitude", "overlaySR", "kts-core"})
public final class OverlayNGRobust {
    @NotNull
    public static final OverlayNGRobust INSTANCE = new OverlayNGRobust();
    @NotNull
    private static final UnionStrategy OVERLAY_UNION = new UnionStrategy(){

        public Geometry union(Geometry g0, Geometry g1) {
            return OverlayNGRobust.overlay(g0, g1, 2);
        }

        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private static final int NUM_SNAP_TRIES = 5;
    private static final double SNAP_TOL_FACTOR = 1.0E12;

    private OverlayNGRobust() {
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        UnaryUnionOp op = new UnaryUnionOp(geom);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Collection<? extends Geometry> geoms) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Collection<? extends Geometry> geoms, @Nullable GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        UnaryUnionOp op = new UnaryUnionOp(geoms, geomFact);
        op.setUnionFunction(OVERLAY_UNION);
        return op.union();
    }

    @JvmStatic
    @Nullable
    public static final Geometry overlay(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode) {
        Geometry result2 = null;
        RuntimeException exOriginal = null;
        try {
            result2 = OverlayNG.Companion.overlay(geom0, geom1, opCode);
            return result2;
        }
        catch (RuntimeException ex) {
            exOriginal = ex;
            result2 = INSTANCE.overlaySnapTries(geom0, geom1, opCode);
            if (result2 != null) {
                return result2;
            }
            result2 = INSTANCE.overlaySR(geom0, geom1, opCode);
            if (result2 != null) {
                return result2;
            }
            throw exOriginal;
        }
    }

    private final Geometry overlaySnapTries(Geometry geom0, Geometry geom1, int opCode) {
        Geometry result2 = null;
        double snapTol = this.snapTolerance(geom0, geom1);
        for (int i = 0; i < 5; ++i) {
            Geometry geometry = result2 = this.overlaySnapping(geom0, geom1, opCode, snapTol);
            if (geometry != null) {
                return geometry;
            }
            Geometry geometry2 = result2 = this.overlaySnapBoth(geom0, geom1, opCode, snapTol);
            if (geometry2 != null) {
                return geometry2;
            }
            snapTol *= (double)10;
        }
        return null;
    }

    private final Geometry overlaySnapping(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        try {
            return this.overlaySnapTol(geom0, geom1, opCode, snapTol);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private final Geometry overlaySnapBoth(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        try {
            Geometry snap0 = this.snapSelf(geom0, snapTol);
            Geometry snap1 = this.snapSelf(geom1, snapTol);
            return this.overlaySnapTol(snap0, snap1, opCode, snapTol);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private final Geometry snapSelf(Geometry geom, double snapTol) {
        OverlayNG ov = new OverlayNG(geom, null);
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        ov.setNoder(snapNoder);
        ov.setStrictMode(true);
        return ov.getResult();
    }

    private final Geometry overlaySnapTol(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        return OverlayNG.Companion.overlay(geom0, geom1, opCode, snapNoder);
    }

    private final double snapTolerance(Geometry geom0, Geometry geom1) {
        double tol0 = this.snapTolerance(geom0);
        double tol1 = this.snapTolerance(geom1);
        return Math.INSTANCE.max(tol0, tol1);
    }

    private final double snapTolerance(Geometry geom) {
        double magnitude = this.ordinateMagnitude(geom);
        return magnitude / 1.0E12;
    }

    private final double ordinateMagnitude(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        Envelope env = geom.getEnvelopeInternal();
        double magMax = Math.INSTANCE.max(Math.INSTANCE.abs(env.getMaxX()), Math.INSTANCE.abs(env.getMaxY()));
        double magMin = Math.INSTANCE.max(Math.INSTANCE.abs(env.getMinX()), Math.INSTANCE.abs(env.getMinY()));
        return Math.INSTANCE.max(magMax, magMin);
    }

    private final Geometry overlaySR(Geometry geom0, Geometry geom1, int opCode) {
        Geometry result2 = null;
        try {
            double scaleSafe = PrecisionUtil.safeScale(geom0, geom1);
            PrecisionModel pmSafe = new PrecisionModel(scaleSafe);
            result2 = OverlayNG.Companion.overlay(geom0, geom1, opCode, pmSafe);
            return result2;
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }
}

