/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.OverlayUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJH\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010H\u0002JH\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010H\u0002JH\u0010\u001b\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J.\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u001fj\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f` 2\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000ej\n\u0012\u0004\u0012\u00020\u000f\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayPoints;", "", "opCode", "", "geom0", "Lorg/locationtech/jts/geom/Geometry;", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(ILorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/PrecisionModel;)V", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "resultList", "Ljava/util/ArrayList;", "Lorg/locationtech/jts/geom/Point;", "Lkotlin/collections/ArrayList;", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "computeIntersection", "", "map0", "", "Lorg/locationtech/jts/geom/Coordinate;", "map1", "computeDifference", "computeUnion", "copyPoint", "pt", "buildPointMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "geom", "Companion", "kts-core"})
public final class OverlayPoints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int opCode;
    @Nullable
    private final Geometry geom0;
    @Nullable
    private final Geometry geom1;
    @Nullable
    private final PrecisionModel pm;
    @NotNull
    private final GeometryFactory geometryFactory;
    @Nullable
    private ArrayList<Point> resultList;

    public OverlayPoints(int opCode, @Nullable Geometry geom0, @Nullable Geometry geom1, @Nullable PrecisionModel pm) {
        this.opCode = opCode;
        this.geom0 = geom0;
        this.geom1 = geom1;
        this.pm = pm;
        Geometry geometry = this.geom0;
        Intrinsics.checkNotNull((Object)geometry);
        this.geometryFactory = geometry.getFactory();
    }

    @Nullable
    public final Geometry getResult() {
        Geometry geometry;
        Map map0 = this.buildPointMap(this.geom0);
        Map map1 = this.buildPointMap(this.geom1);
        this.resultList = new ArrayList();
        switch (this.opCode) {
            case 1: {
                ArrayList<Point> arrayList = this.resultList;
                Intrinsics.checkNotNull(arrayList);
                this.computeIntersection(map0, map1, arrayList);
                break;
            }
            case 2: {
                ArrayList<Point> arrayList = this.resultList;
                Intrinsics.checkNotNull(arrayList);
                this.computeUnion(map0, map1, arrayList);
                break;
            }
            case 3: {
                ArrayList<Point> arrayList = this.resultList;
                Intrinsics.checkNotNull(arrayList);
                this.computeDifference(map0, map1, arrayList);
                break;
            }
            case 4: {
                ArrayList<Point> arrayList = this.resultList;
                Intrinsics.checkNotNull(arrayList);
                this.computeDifference(map0, map1, arrayList);
                ArrayList<Point> arrayList2 = this.resultList;
                Intrinsics.checkNotNull(arrayList2);
                this.computeDifference(map1, map0, arrayList2);
            }
        }
        ArrayList<Point> arrayList = this.resultList;
        Intrinsics.checkNotNull(arrayList);
        if (arrayList.isEmpty()) {
            geometry = OverlayUtil.INSTANCE.createEmptyResult(0, this.geometryFactory);
        } else {
            ArrayList<Point> arrayList3 = this.resultList;
            Intrinsics.checkNotNull(arrayList3);
            geometry = this.geometryFactory.buildGeometry((Collection<? extends Geometry>)arrayList3);
        }
        return geometry;
    }

    private final void computeIntersection(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Map.Entry<Coordinate, Point> entry : map0.entrySet()) {
            Coordinate key = entry.getKey();
            Point value = entry.getValue();
            if (!map1.containsKey(key)) continue;
            resultList.add(this.copyPoint(value));
        }
    }

    private final void computeDifference(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Map.Entry<Coordinate, Point> entry : map0.entrySet()) {
            Coordinate key = entry.getKey();
            Point value = entry.getValue();
            if (map1.containsKey(key)) continue;
            resultList.add(this.copyPoint(value));
        }
    }

    private final void computeUnion(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Point entry : map0.values()) {
            resultList.add(this.copyPoint(entry));
        }
        for (Map.Entry entry : map1.entrySet()) {
            Coordinate key = (Coordinate)entry.getKey();
            Point value = (Point)entry.getValue();
            if (map0.containsKey(key)) continue;
            resultList.add(this.copyPoint(value));
        }
    }

    private final Point copyPoint(Point pt) {
        CoordinateSequence seq;
        if (OverlayUtil.INSTANCE.isFloating(this.pm)) {
            Geometry geometry = pt.copy();
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            return (Point)geometry;
        }
        CoordinateSequence coordinateSequence = seq = pt.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq2 = coordinateSequence.copy();
        PrecisionModel precisionModel = this.pm;
        Intrinsics.checkNotNull((Object)precisionModel);
        seq2.setOrdinate(0, 0, precisionModel.makePrecise(seq.getX(0)));
        seq2.setOrdinate(0, 1, this.pm.makePrecise(seq.getY(0)));
        return this.geometryFactory.createPoint(seq2);
    }

    private final HashMap<Coordinate, Point> buildPointMap(Geometry geom) {
        HashMap<Coordinate, Point> map = new HashMap<Coordinate, Point>();
        Geometry geometry = geom;
        Intrinsics.checkNotNull((Object)geometry);
        int n = geometry.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Point pt;
            Coordinate p;
            Geometry geometry2 = geom.getGeometryN(i);
            Point point = geometry2 instanceof Point ? (Point)geometry2 : null;
            if (point == null) {
                throw new IllegalArgumentException("Non-point geometry input to point overlay");
            }
            Point elt = point;
            if (elt.isEmpty() || map.containsKey(p = Companion.roundCoord(pt = elt, this.pm))) continue;
            ((Map)map).put(p, pt);
        }
        return map;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayPoints$Companion;", "", "<init>", "()V", "overlay", "Lorg/locationtech/jts/geom/Geometry;", "opCode", "", "geom0", "geom1", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "roundCoord", "Lorg/locationtech/jts/geom/Coordinate;", "pt", "Lorg/locationtech/jts/geom/Point;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry overlay(int opCode, @Nullable Geometry geom0, @Nullable Geometry geom1, @Nullable PrecisionModel pm) {
            OverlayPoints overlay = new OverlayPoints(opCode, geom0, geom1, pm);
            return overlay.getResult();
        }

        @NotNull
        public final Coordinate roundCoord(@NotNull Point pt, @Nullable PrecisionModel pm) {
            Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
            Coordinate p = pt.getCoordinate();
            if (OverlayUtil.INSTANCE.isFloating(pm)) {
                Coordinate coordinate = p;
                Intrinsics.checkNotNull((Object)coordinate);
                return coordinate;
            }
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate p2 = coordinate.copy();
            PrecisionModel precisionModel = pm;
            Intrinsics.checkNotNull((Object)precisionModel);
            precisionModel.makePrecise(p2);
            return p2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

