/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.RobustClipEnvelopeComputer;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J$\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J,\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J$\u0010\u001b\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\"\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bJ>\u0010&\u001a\u00020\u00172\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010(2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010(2\u0006\u0010.\u001a\u00020\"J\u001e\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020-2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J,\u0010;\u001a\u00020\u00052\b\u0010<\u001a\u0004\u0018\u00010\u00172\b\u0010=\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\b\u0010>\u001a\u0004\u0018\u00010\u0017J \u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u0012H\u0002J \u0010C\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u0012H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayUtil;", "", "<init>", "()V", "isFloating", "", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "clippingEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "opCode", "", "inputGeom", "Lorg/locationtech/jts/operation/overlayng/InputGeometry;", "resultEnvelope", "safeEnv", "env", "SAFE_ENV_BUFFER_FACTOR", "", "SAFE_ENV_GRID_FACTOR", "safeExpandDistance", "isEmptyResult", "a", "Lorg/locationtech/jts/geom/Geometry;", "b", "isEmpty", "geom", "isEnvDisjoint", "isDisjoint", "envA", "envB", "createEmptyResult", "dim", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "resultDimension", "dim0", "dim1", "createResultGeometry", "resultPolyList", "", "Lorg/locationtech/jts/geom/Polygon;", "resultLineList", "Lorg/locationtech/jts/geom/LineString;", "resultPointList", "Lorg/locationtech/jts/geom/Point;", "geometryFactory", "toLines", "graph", "Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "isOutputEdges", "labelForResult", "", "edge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "round", "Lorg/locationtech/jts/geom/Coordinate;", "pt", "AREA_HEURISTIC_TOLERANCE", "isResultAreaConsistent", "geom0", "geom1", "result", "isLess", "v1", "v2", "tol", "isGreater", "kts-core"})
public final class OverlayUtil {
    @NotNull
    public static final OverlayUtil INSTANCE = new OverlayUtil();
    private static final double SAFE_ENV_BUFFER_FACTOR = 0.1;
    private static final int SAFE_ENV_GRID_FACTOR = 3;
    private static final double AREA_HEURISTIC_TOLERANCE = 0.1;

    private OverlayUtil() {
    }

    public final boolean isFloating(@Nullable PrecisionModel pm) {
        PrecisionModel precisionModel = pm;
        return precisionModel != null ? precisionModel.isFloating() : true;
    }

    @Nullable
    public final Envelope clippingEnvelope(int opCode, @NotNull InputGeometry inputGeom, @Nullable PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        Envelope envelope = this.resultEnvelope(opCode, inputGeom, pm);
        if (envelope == null) {
            return null;
        }
        Envelope resultEnv = envelope;
        Envelope clipEnv = RobustClipEnvelopeComputer.Companion.getEnvelope(inputGeom.getGeometry(0), inputGeom.getGeometry(1), resultEnv);
        return this.safeEnv(clipEnv, pm);
    }

    private final Envelope resultEnvelope(int opCode, InputGeometry inputGeom, PrecisionModel pm) {
        Envelope overlapEnv = null;
        switch (opCode) {
            case 1: {
                Envelope envA = this.safeEnv(inputGeom.getEnvelope(0), pm);
                Envelope envB = this.safeEnv(inputGeom.getEnvelope(1), pm);
                overlapEnv = envA.intersection(envB);
                break;
            }
            case 3: {
                overlapEnv = this.safeEnv(inputGeom.getEnvelope(0), pm);
            }
        }
        return overlapEnv;
    }

    private final Envelope safeEnv(Envelope env, PrecisionModel pm) {
        double envExpandDist = this.safeExpandDistance(env, pm);
        Envelope safeEnv = env.copy();
        safeEnv.expandBy(envExpandDist);
        return safeEnv;
    }

    private final double safeExpandDistance(Envelope env, PrecisionModel pm) {
        double envExpandDist = 0.0;
        if (this.isFloating(pm)) {
            double minSize = Math.INSTANCE.min(env.getHeight(), env.getWidth());
            if (minSize <= 0.0) {
                minSize = Math.INSTANCE.max(env.getHeight(), env.getWidth());
            }
            envExpandDist = 0.1 * minSize;
        } else {
            PrecisionModel precisionModel = pm;
            Intrinsics.checkNotNull((Object)precisionModel);
            double gridSize = 1.0 / precisionModel.getScale();
            envExpandDist = (double)3 * gridSize;
        }
        return envExpandDist;
    }

    public final boolean isEmptyResult(int opCode, @Nullable Geometry a, @Nullable Geometry b, @Nullable PrecisionModel pm) {
        switch (opCode) {
            case 1: {
                if (!this.isEnvDisjoint(a, b, pm)) break;
                return true;
            }
            case 3: {
                if (!this.isEmpty(a)) break;
                return true;
            }
            case 2: 
            case 4: {
                if (!this.isEmpty(a) || !this.isEmpty(b)) break;
                return true;
            }
        }
        return false;
    }

    private final boolean isEmpty(Geometry geom) {
        return geom == null || geom.isEmpty();
    }

    public final boolean isEnvDisjoint(@Nullable Geometry a, @Nullable Geometry b, @Nullable PrecisionModel pm) {
        boolean bl;
        if (this.isEmpty(a) || this.isEmpty(b)) {
            return true;
        }
        if (this.isFloating(pm)) {
            Geometry geometry = a;
            Intrinsics.checkNotNull((Object)geometry);
            Envelope envelope = geometry.getEnvelopeInternal();
            Geometry geometry2 = b;
            Intrinsics.checkNotNull((Object)geometry2);
            bl = envelope.disjoint(geometry2.getEnvelopeInternal());
        } else {
            Geometry geometry = a;
            Intrinsics.checkNotNull((Object)geometry);
            Envelope envelope = geometry.getEnvelopeInternal();
            Geometry geometry3 = b;
            Intrinsics.checkNotNull((Object)geometry3);
            bl = this.isDisjoint(envelope, geometry3.getEnvelopeInternal(), pm);
        }
        return bl;
    }

    private final boolean isDisjoint(Envelope envA, Envelope envB, PrecisionModel pm) {
        PrecisionModel precisionModel = pm;
        Intrinsics.checkNotNull((Object)precisionModel);
        if (precisionModel.makePrecise(envB.getMinX()) > pm.makePrecise(envA.getMaxX())) {
            return true;
        }
        if (pm.makePrecise(envB.getMaxX()) < pm.makePrecise(envA.getMinX())) {
            return true;
        }
        if (pm.makePrecise(envB.getMinY()) > pm.makePrecise(envA.getMaxY())) {
            return true;
        }
        return pm.makePrecise(envB.getMaxY()) < pm.makePrecise(envA.getMinY());
    }

    @Nullable
    public final Geometry createEmptyResult(int dim, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        Geometry result2 = null;
        switch (dim) {
            case 0: {
                result2 = GeometryFactory.createPoint$default(geomFact, null, 1, null);
                break;
            }
            case 1: {
                result2 = GeometryFactory.createLineString$default(geomFact, null, 1, null);
                break;
            }
            case 2: {
                result2 = GeometryFactory.createPolygon$default(geomFact, null, null, 3, null);
                break;
            }
            case -1: {
                result2 = geomFact.createGeometryCollection();
                break;
            }
            default: {
                Assert.shouldNeverReachHere("Unable to determine overlay result geometry dimension");
            }
        }
        return result2;
    }

    public final int resultDimension(int opCode, int dim0, int dim1) {
        int resultDimension = -1;
        switch (opCode) {
            case 1: {
                resultDimension = Math.INSTANCE.min(dim0, dim1);
                break;
            }
            case 2: {
                resultDimension = Math.INSTANCE.max(dim0, dim1);
                break;
            }
            case 3: {
                resultDimension = dim0;
                break;
            }
            case 4: {
                resultDimension = Math.INSTANCE.max(dim0, dim1);
            }
        }
        return resultDimension;
    }

    @NotNull
    public final Geometry createResultGeometry(@Nullable List<? extends Polygon> resultPolyList, @Nullable List<? extends LineString> resultLineList, @Nullable List<Point> resultPointList, @NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        List geomList = new ArrayList();
        if (resultPolyList != null) {
            geomList.addAll((Collection)resultPolyList);
        }
        if (resultLineList != null) {
            geomList.addAll((Collection)resultLineList);
        }
        if (resultPointList != null) {
            geomList.addAll((Collection)resultPointList);
        }
        return geometryFactory.buildGeometry(geomList);
    }

    @NotNull
    public final Geometry toLines(@NotNull OverlayGraph graph, boolean isOutputEdges, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        List lines = new ArrayList();
        for (OverlayEdge edge : graph.getEdges()) {
            boolean includeEdge = isOutputEdges || edge.isInResultArea();
            if (!includeEdge) continue;
            Coordinate[] pts = edge.getCoordinatesOriented();
            LineString line = geomFact.createLineString(pts);
            line.setUserData(this.labelForResult(edge));
            lines.add(line);
        }
        return geomFact.buildGeometry(lines);
    }

    private final String labelForResult(OverlayEdge edge) {
        return edge.getLabel().toString(edge.isForward()) + (edge.isInResultArea() ? " Res" : "");
    }

    @Nullable
    public final Coordinate round(@NotNull Point pt, @Nullable PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        if (pt.isEmpty()) {
            return null;
        }
        Coordinate coordinate = pt.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate p = coordinate.copy();
        if (!this.isFloating(pm)) {
            PrecisionModel precisionModel = pm;
            Intrinsics.checkNotNull((Object)precisionModel);
            precisionModel.makePrecise(p);
        }
        return p;
    }

    public final boolean isResultAreaConsistent(@Nullable Geometry geom0, @Nullable Geometry geom1, int opCode, @Nullable Geometry result2) {
        if (geom0 == null || geom1 == null) {
            return true;
        }
        Geometry geometry = result2;
        Intrinsics.checkNotNull((Object)geometry);
        double areaResult = geometry.getArea();
        double areaA = geom0.getArea();
        double areaB = geom1.getArea();
        boolean isConsistent = true;
        switch (opCode) {
            case 1: {
                isConsistent = this.isLess(areaResult, areaA, 0.1) && this.isLess(areaResult, areaB, 0.1);
                break;
            }
            case 3: {
                isConsistent = this.isLess(areaResult, areaA, 0.1) && this.isGreater(areaResult, areaA - areaB, 0.1);
                break;
            }
            case 4: {
                isConsistent = this.isLess(areaResult, areaA + areaB, 0.1);
                break;
            }
            case 2: {
                isConsistent = this.isLess(areaA, areaResult, 0.1) && this.isLess(areaB, areaResult, 0.1) && this.isGreater(areaResult, areaA - areaB, 0.1);
            }
        }
        return isConsistent;
    }

    private final boolean isLess(double v1, double v2, double tol) {
        return v1 <= v2 * (1.0 + tol);
    }

    private final boolean isGreater(double v1, double v2, double tol) {
        return v1 >= v2 * (1.0 - tol);
    }
}

