/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.overlayng.MaximalEdgeRing;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayEdgeRing;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B)\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0003H\u0002J\u0016\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0002J$\u0010\"\u001a\u00020\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/locationtech/jts/operation/overlayng/PolygonBuilder;", "", "resultAreaEdges", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "isEnforcePolygonal", "", "<init>", "(Ljava/util/List;Lorg/locationtech/jts/geom/GeometryFactory;Z)V", "()Z", "shellList", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "freeHoleList", "polygons", "Lorg/locationtech/jts/geom/Polygon;", "getPolygons", "()Ljava/util/List;", "shellRings", "getShellRings", "computePolygons", "buildRings", "", "linkResultAreaEdgesMax", "resultEdges", "buildMinimalRings", "maxRings", "Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing;", "assignShellsAndHoles", "minRings", "findSingleShell", "edgeRings", "placeFreeHoles", "Companion", "kts-core"})
public final class PolygonBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geometryFactory;
    private final boolean isEnforcePolygonal;
    @NotNull
    private final List<OverlayEdgeRing> shellList;
    @NotNull
    private final List<OverlayEdgeRing> freeHoleList;

    @JvmOverloads
    public PolygonBuilder(@NotNull List<OverlayEdge> resultAreaEdges, @NotNull GeometryFactory geometryFactory, boolean isEnforcePolygonal) {
        Intrinsics.checkNotNullParameter(resultAreaEdges, (String)"resultAreaEdges");
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.geometryFactory = geometryFactory;
        this.isEnforcePolygonal = isEnforcePolygonal;
        this.shellList = new ArrayList();
        this.freeHoleList = new ArrayList();
        this.buildRings(resultAreaEdges);
    }

    public /* synthetic */ PolygonBuilder(List list, GeometryFactory geometryFactory, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(list, geometryFactory, bl);
    }

    public final boolean isEnforcePolygonal() {
        return this.isEnforcePolygonal;
    }

    @NotNull
    public final List<Polygon> getPolygons() {
        return this.computePolygons(this.shellList);
    }

    @NotNull
    public final List<OverlayEdgeRing> getShellRings() {
        return this.shellList;
    }

    private final List<Polygon> computePolygons(List<OverlayEdgeRing> shellList) {
        List resultPolyList = new ArrayList();
        for (OverlayEdgeRing er : shellList) {
            Polygon poly = er.toPolygon(this.geometryFactory);
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }

    private final void buildRings(List<OverlayEdge> resultAreaEdges) {
        this.linkResultAreaEdgesMax(resultAreaEdges);
        List maxRings = PolygonBuilder.Companion.buildMaximalRings(resultAreaEdges);
        this.buildMinimalRings(maxRings);
        this.placeFreeHoles(this.shellList, this.freeHoleList);
    }

    private final void linkResultAreaEdgesMax(List<OverlayEdge> resultEdges) {
        for (OverlayEdge edge : resultEdges) {
            MaximalEdgeRing.Companion.linkResultAreaMaxRingAtNode(edge);
        }
    }

    private final void buildMinimalRings(List<MaximalEdgeRing> maxRings) {
        for (MaximalEdgeRing erMax : maxRings) {
            List<OverlayEdgeRing> minRings = erMax.buildMinimalRings(this.geometryFactory);
            this.assignShellsAndHoles(minRings);
        }
    }

    private final void assignShellsAndHoles(List<OverlayEdgeRing> minRings) {
        OverlayEdgeRing shell = this.findSingleShell(minRings);
        if (shell != null) {
            PolygonBuilder.Companion.assignHoles(shell, minRings);
            v0 = this.shellList.add(shell);
        } else {
            v0 = this.freeHoleList.addAll((Collection<OverlayEdgeRing>)minRings);
        }
    }

    private final OverlayEdgeRing findSingleShell(List<OverlayEdgeRing> edgeRings) {
        int shellCount = 0;
        OverlayEdgeRing shell = null;
        for (OverlayEdgeRing er : edgeRings) {
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert.INSTANCE.isTrue(shellCount <= 1, "found two shells in EdgeRing list");
        return shell;
    }

    private final void placeFreeHoles(List<OverlayEdgeRing> shellList, List<OverlayEdgeRing> freeHoleList) {
        for (OverlayEdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            OverlayEdgeRing shell = hole.findEdgeRingContaining(shellList);
            if (this.isEnforcePolygonal && shell == null) {
                throw new TopologyException("unable to assign free hole to a shell", hole.getCoordinate());
            }
            hole.setShell(shell);
        }
    }

    @JvmOverloads
    public PolygonBuilder(@NotNull List<OverlayEdge> resultAreaEdges, @NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter(resultAreaEdges, (String)"resultAreaEdges");
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this(resultAreaEdges, geometryFactory, false, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/overlayng/PolygonBuilder$Companion;", "", "<init>", "()V", "buildMaximalRings", "", "Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing;", "edges", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "assignHoles", "", "shell", "Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "edgeRings", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final List<MaximalEdgeRing> buildMaximalRings(Collection<OverlayEdge> edges) {
            List edgeRings = new ArrayList();
            for (OverlayEdge e : edges) {
                if (!e.isInResultArea() || !e.getLabel().isBoundaryEither() || e.getEdgeRingMax() != null) continue;
                MaximalEdgeRing er = new MaximalEdgeRing(e);
                edgeRings.add(er);
            }
            return edgeRings;
        }

        private final void assignHoles(OverlayEdgeRing shell, List<OverlayEdgeRing> edgeRings) {
            for (OverlayEdgeRing er : edgeRings) {
                if (!er.isHole()) continue;
                er.setShell(shell);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

