/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.overlayng.OverlayNG;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/overlayng/PrecisionReducer;", "", "<init>", "()V", "reducePrecision", "Lorg/locationtech/jts/geom/Geometry;", "geom", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "kts-core"})
public final class PrecisionReducer {
    @NotNull
    public static final PrecisionReducer INSTANCE = new PrecisionReducer();

    private PrecisionReducer() {
    }

    @JvmStatic
    @NotNull
    public static final Geometry reducePrecision(@NotNull Geometry geom, @Nullable PrecisionModel pm) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        OverlayNG ov = new OverlayNG(geom, pm);
        if (geom.getDimension() == 2) {
            ov.setAreaResultOnly(true);
        }
        try {
            Geometry geometry2 = ov.getResult();
            Intrinsics.checkNotNull((Object)geometry2);
            geometry = geometry2;
        }
        catch (TopologyException ex) {
            throw new IllegalArgumentException("Reduction failed, possible invalid input");
        }
        return geometry;
    }
}

