/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\rJ\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\rJ\u001a\u0010\u0018\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/operation/overlayng/PrecisionUtil;", "", "<init>", "()V", "MAX_ROBUST_DP_DIGITS", "", "getMAX_ROBUST_DP_DIGITS", "()I", "setMAX_ROBUST_DP_DIGITS", "(I)V", "robustPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "a", "Lorg/locationtech/jts/geom/Geometry;", "b", "safeScale", "", "value", "geom", "maxBoundMagnitude", "env", "Lorg/locationtech/jts/geom/Envelope;", "precisionScale", "precisionDigits", "inherentScale", "numberOfDecimals", "robustScale", "InherentScaleFilter", "kts-core"})
public final class PrecisionUtil {
    @NotNull
    public static final PrecisionUtil INSTANCE = new PrecisionUtil();
    private static int MAX_ROBUST_DP_DIGITS = 14;

    private PrecisionUtil() {
    }

    public final int getMAX_ROBUST_DP_DIGITS() {
        return MAX_ROBUST_DP_DIGITS;
    }

    public final void setMAX_ROBUST_DP_DIGITS(int n) {
        MAX_ROBUST_DP_DIGITS = n;
    }

    @NotNull
    public final PrecisionModel robustPM(@NotNull Geometry a, @Nullable Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double scale = PrecisionUtil.robustScale(a, b);
        return new PrecisionModel(scale);
    }

    public final double safeScale(double value) {
        return this.precisionScale(value, MAX_ROBUST_DP_DIGITS);
    }

    public final double safeScale(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.safeScale(this.maxBoundMagnitude(geom.getEnvelopeInternal()));
    }

    @JvmStatic
    public static final double safeScale(@Nullable Geometry a, @Nullable Geometry b) {
        Geometry geometry = a;
        Intrinsics.checkNotNull((Object)geometry);
        double maxBnd = INSTANCE.maxBoundMagnitude(geometry.getEnvelopeInternal());
        if (b != null) {
            double maxBndB = INSTANCE.maxBoundMagnitude(b.getEnvelopeInternal());
            maxBnd = Math.INSTANCE.max(maxBnd, maxBndB);
        }
        return INSTANCE.safeScale(maxBnd);
    }

    private final double maxBoundMagnitude(Envelope env) {
        return MathUtil.INSTANCE.max(Math.INSTANCE.abs(env.getMaxX()), Math.INSTANCE.abs(env.getMaxY()), Math.INSTANCE.abs(env.getMinX()), Math.INSTANCE.abs(env.getMinY()));
    }

    private final double precisionScale(double value, int precisionDigits) {
        int magnitude = (int)(Math.INSTANCE.log(value) / Math.INSTANCE.log(10.0) + 1.0);
        int precDigits = precisionDigits - magnitude;
        return Math.INSTANCE.pow(10.0, precDigits);
    }

    public final double inherentScale(double value) {
        int numDec = this.numberOfDecimals(value);
        return Math.INSTANCE.pow(10.0, numDec);
    }

    public final double inherentScale(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        InherentScaleFilter scaleFilter = new InherentScaleFilter();
        geom.apply(scaleFilter);
        return scaleFilter.getScale();
    }

    @JvmStatic
    public static final double inherentScale(@NotNull Geometry a, @Nullable Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double scale = INSTANCE.inherentScale(a);
        if (b != null) {
            double scaleB = INSTANCE.inherentScale(b);
            scale = Math.INSTANCE.max(scale, scaleB);
        }
        return scale;
    }

    private final int numberOfDecimals(double value) {
        String s = OrdinateFormat.DEFAULT.format(value);
        if (StringsKt.endsWith$default((String)s, (String)".0", (boolean)false, (int)2, null)) {
            return 0;
        }
        int len = s.length();
        int decIndex = StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)0, (boolean)false, (int)6, null);
        return decIndex <= 0 ? 0 : len - decIndex - 1;
    }

    @NotNull
    public final PrecisionModel robustPM(@NotNull Geometry a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double scale = this.robustScale(a);
        return new PrecisionModel(scale);
    }

    @JvmStatic
    public static final double robustScale(@NotNull Geometry a, @Nullable Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double inherentScale = PrecisionUtil.inherentScale(a, b);
        double safeScale = PrecisionUtil.safeScale(a, b);
        return INSTANCE.robustScale(inherentScale, safeScale);
    }

    public final double robustScale(@NotNull Geometry a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double inherentScale = this.inherentScale(a);
        double safeScale = this.safeScale(a);
        return this.robustScale(inherentScale, safeScale);
    }

    private final double robustScale(double inherentScale, double safeScale) {
        return inherentScale <= safeScale ? inherentScale : safeScale;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/operation/overlayng/PrecisionUtil$InherentScaleFilter;", "Lorg/locationtech/jts/geom/CoordinateFilter;", "<init>", "()V", "value", "", "scale", "getScale", "()D", "filter", "", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "updateScaleMax", "kts-core"})
    private static final class InherentScaleFilter
    implements CoordinateFilter {
        private double scale;

        public final double getScale() {
            return this.scale;
        }

        @Override
        public void filter(@Nullable Coordinate coord) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull((Object)coordinate);
            this.updateScaleMax(coordinate.x);
            this.updateScaleMax(coord.y);
        }

        private final void updateScaleMax(double value) {
            double scaleVal = INSTANCE.inherentScale(value);
            if (scaleVal > this.scale) {
                this.scale = scaleVal;
            }
        }
    }
}

