/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0019\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J$\u0010\u001b\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001a\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/overlayng/RingClipper;", "", "clipEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "clipEnvMinY", "", "clipEnvMaxY", "clipEnvMinX", "clipEnvMaxX", "clip", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "clipToBoxEdge", "edgeIndex", "", "closeRing", "", "([Lorg/locationtech/jts/geom/Coordinate;IZ)[Lorg/locationtech/jts/geom/Coordinate;", "intersection", "a", "b", "intersectionLineY", "y", "intersectionLineX", "x", "isInsideEdge", "p", "Companion", "kts-core"})
public final class RingClipper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Envelope clipEnv;
    private final double clipEnvMinY;
    private final double clipEnvMaxY;
    private final double clipEnvMinX;
    private final double clipEnvMaxX;
    private static final int BOX_LEFT = 3;
    private static final int BOX_TOP = 2;
    private static final int BOX_RIGHT = 1;
    private static final int BOX_BOTTOM = 0;

    public RingClipper(@NotNull Envelope clipEnv) {
        Intrinsics.checkNotNullParameter((Object)clipEnv, (String)"clipEnv");
        this.clipEnv = clipEnv;
        this.clipEnvMinY = this.clipEnv.getMinY();
        this.clipEnvMaxY = this.clipEnv.getMaxY();
        this.clipEnvMinX = this.clipEnv.getMinX();
        this.clipEnvMaxX = this.clipEnv.getMaxX();
    }

    @NotNull
    public final Coordinate[] clip(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        Coordinate[] pts2 = pts;
        for (int edgeIndex = 0; edgeIndex < 4; ++edgeIndex) {
            boolean closeRing = edgeIndex == 3;
            if (!((pts2 = this.clipToBoxEdge(pts2, edgeIndex, closeRing)).length == 0)) continue;
            return pts2;
        }
        return pts2;
    }

    private final Coordinate[] clipToBoxEdge(Coordinate[] pts, int edgeIndex, boolean closeRing) {
        Coordinate start;
        CoordinateList ptsClip = new CoordinateList();
        Coordinate p0 = pts[pts.length - 1];
        for (Coordinate p1 : pts) {
            if (this.isInsideEdge(p1, edgeIndex)) {
                if (!this.isInsideEdge(p0, edgeIndex)) {
                    intPt = this.intersection(p0, p1, edgeIndex);
                    ptsClip.add(intPt, false);
                }
                ptsClip.add(p1.copy(), false);
            } else if (this.isInsideEdge(p0, edgeIndex)) {
                intPt = this.intersection(p0, p1, edgeIndex);
                ptsClip.add(intPt, false);
            }
            p0 = p1;
        }
        if (closeRing && ptsClip.size() > 0 && !(start = ptsClip.get(0)).equals2D(ptsClip.get(ptsClip.size() - 1))) {
            ptsClip.add(start.copy());
        }
        return ptsClip.toCoordinateArray();
    }

    private final Coordinate intersection(Coordinate a, Coordinate b, int edgeIndex) {
        Coordinate intPt = switch (edgeIndex) {
            case 0 -> new Coordinate(this.intersectionLineY(a, b, this.clipEnvMinY), this.clipEnvMinY);
            case 1 -> new Coordinate(this.clipEnvMaxX, this.intersectionLineX(a, b, this.clipEnvMaxX));
            case 2 -> new Coordinate(this.intersectionLineY(a, b, this.clipEnvMaxY), this.clipEnvMaxY);
            case 3 -> new Coordinate(this.clipEnvMinX, this.intersectionLineX(a, b, this.clipEnvMinX));
            default -> new Coordinate(this.clipEnvMinX, this.intersectionLineX(a, b, this.clipEnvMinX));
        };
        return intPt;
    }

    private final double intersectionLineY(Coordinate a, Coordinate b, double y) {
        Coordinate coordinate = b;
        Intrinsics.checkNotNull((Object)coordinate);
        double d = coordinate.x;
        Coordinate coordinate2 = a;
        Intrinsics.checkNotNull((Object)coordinate2);
        double m = (d - coordinate2.x) / (b.y - a.y);
        double intercept = (y - a.y) * m;
        return a.x + intercept;
    }

    private final double intersectionLineX(Coordinate a, Coordinate b, double x) {
        Coordinate coordinate = b;
        Intrinsics.checkNotNull((Object)coordinate);
        double d = coordinate.y;
        Coordinate coordinate2 = a;
        Intrinsics.checkNotNull((Object)coordinate2);
        double m = (d - coordinate2.y) / (b.x - a.x);
        double intercept = (x - a.x) * m;
        return a.y + intercept;
    }

    private final boolean isInsideEdge(Coordinate p, int edgeIndex) {
        boolean isInside = false;
        isInside = switch (edgeIndex) {
            case 0 -> {
                Coordinate v0 = p;
                Intrinsics.checkNotNull((Object)v0);
                if (v0.y > this.clipEnvMinY) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Coordinate v2 = p;
                Intrinsics.checkNotNull((Object)v2);
                if (v2.x < this.clipEnvMaxX) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Coordinate v3 = p;
                Intrinsics.checkNotNull((Object)v3);
                if (v3.y < this.clipEnvMaxY) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                Coordinate v4 = p;
                Intrinsics.checkNotNull((Object)v4);
                if (v4.x > this.clipEnvMinX) {
                    yield true;
                }
                yield false;
            }
            default -> {
                Coordinate v5 = p;
                Intrinsics.checkNotNull((Object)v5);
                yield v5.x > this.clipEnvMinX;
            }
        };
        return isInside;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/overlayng/RingClipper$Companion;", "", "<init>", "()V", "BOX_LEFT", "", "BOX_TOP", "BOX_RIGHT", "BOX_BOTTOM", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

