/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/operation/predicate/RectangleContains;", "", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "contains", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isContainedInBoundary", "isPointContainedInBoundary", "point", "Lorg/locationtech/jts/geom/Point;", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "isLineStringContainedInBoundary", "line", "Lorg/locationtech/jts/geom/LineString;", "isLineSegmentContainedInBoundary", "p0", "p1", "Companion", "kts-core"})
public final class RectangleContains {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Envelope rectEnv;

    public RectangleContains(@NotNull Polygon rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public final boolean contains(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (!this.rectEnv.contains(geom.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geom);
    }

    private final boolean isContainedInBoundary(Geometry geom) {
        if (geom instanceof Polygon) {
            return false;
        }
        if (geom instanceof Point) {
            return this.isPointContainedInBoundary((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geom);
        }
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.isContainedInBoundary(comp)) continue;
            return false;
        }
        return true;
    }

    private final boolean isPointContainedInBoundary(Point point) {
        Coordinate coordinate = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        return this.isPointContainedInBoundary(coordinate);
    }

    private final boolean isPointContainedInBoundary(Coordinate pt) {
        return pt.x == this.rectEnv.getMinX() || pt.x == this.rectEnv.getMaxX() || pt.y == this.rectEnv.getMinY() || pt.y == this.rectEnv.getMaxY();
    }

    private final boolean isLineStringContainedInBoundary(LineString line) {
        CoordinateSequence seq = line.getCoordinateSequence();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size() - 1;
        for (int i = 0; i < n; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            if (this.isLineSegmentContainedInBoundary(p0, p1)) continue;
            return false;
        }
        return true;
    }

    private final boolean isLineSegmentContainedInBoundary(Coordinate p0, Coordinate p1) {
        if (Intrinsics.areEqual((Object)p0, (Object)p1)) {
            return this.isPointContainedInBoundary(p0);
        }
        return p0.x == p1.x ? p0.x == this.rectEnv.getMinX() || p0.x == this.rectEnv.getMaxX() : p0.y == p1.y && (p0.y == this.rectEnv.getMinY() || p0.y == this.rectEnv.getMaxY());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/predicate/RectangleContains$Companion;", "", "<init>", "()V", "contains", "", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "b", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean contains(@NotNull Polygon rectangle, @NotNull Geometry b) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            RectangleContains rc = new RectangleContains(rectangle);
            return rc.contains(b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

