/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.RectangleLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/operation/predicate/RectangleIntersectsSegmentVisitor;", "Lorg/locationtech/jts/geom/util/ShortCircuitedGeometryVisitor;", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "rectIntersector", "Lorg/locationtech/jts/algorithm/RectangleLineIntersector;", "hasIntersection", "", "intersects", "visit", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "checkIntersectionWithLineStrings", "lines", "", "checkIntersectionWithSegments", "testLine", "Lorg/locationtech/jts/geom/LineString;", "isDone", "kts-core"})
public final class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    @NotNull
    private final Envelope rectEnv;
    @NotNull
    private final RectangleLineIntersector rectIntersector;
    private boolean hasIntersection;

    public RectangleIntersectsSegmentVisitor(@NotNull Polygon rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.rectIntersector = new RectangleLineIntersector(this.rectEnv);
    }

    public final boolean intersects() {
        return this.hasIntersection;
    }

    @Override
    protected void visit(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        List<Geometry> lines = LinearComponentExtracter.Companion.getLines(geom);
        this.checkIntersectionWithLineStrings(lines);
    }

    private final void checkIntersectionWithLineStrings(List<? extends Geometry> lines) {
        for (Geometry geometry : lines) {
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString testLine = (LineString)geometry;
            this.checkIntersectionWithSegments(testLine);
            if (!this.hasIntersection) continue;
            return;
        }
    }

    private final void checkIntersectionWithSegments(LineString testLine) {
        CoordinateSequence seq1;
        CoordinateSequence coordinateSequence = seq1 = testLine.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        Coordinate p0 = coordinateSequence.createCoordinate();
        Coordinate p1 = seq1.createCoordinate();
        int n = seq1.size();
        for (int j = 1; j < n; ++j) {
            seq1.getCoordinate(j - 1, p0);
            seq1.getCoordinate(j, p1);
            if (!this.rectIntersector.intersects(p0, p1)) continue;
            this.hasIntersection = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.hasIntersection;
    }
}

