/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.Label;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010(\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007J\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fJ0\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ0\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/operation/relate/EdgeEndBuilder;", "", "<init>", "()V", "computeEdgeEnds", "", "edges", "", "", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "l", "", "createEdgeEndForPrev", "eiCurr", "Lorg/locationtech/jts/geomgraph/EdgeIntersection;", "eiPrev", "createEdgeEndForNext", "eiNext", "kts-core"})
public final class EdgeEndBuilder {
    @NotNull
    public final List<Object> computeEdgeEnds(@NotNull Iterator<? extends Object> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        List l = new ArrayList();
        while (edges.hasNext()) {
            Object object = edges.next();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)object;
            this.computeEdgeEnds(e, l);
        }
        return l;
    }

    public final void computeEdgeEnds(@NotNull Edge edge, @NotNull List<Object> l) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Intrinsics.checkNotNullParameter(l, (String)"l");
        EdgeIntersectionList eiList = edge.getEdgeIntersectionList();
        eiList.addEndpoints();
        Iterator<?> it = eiList.iterator();
        EdgeIntersection eiPrev = null;
        EdgeIntersection eiCurr = null;
        if (!it.hasNext()) {
            return;
        }
        EdgeIntersection eiNext = (EdgeIntersection)it.next();
        do {
            eiPrev = eiCurr;
            eiCurr = eiNext;
            eiNext = null;
            if (it.hasNext()) {
                eiNext = (EdgeIntersection)it.next();
            }
            if (eiCurr == null) continue;
            this.createEdgeEndForPrev(edge, l, eiCurr, eiPrev);
            this.createEdgeEndForNext(edge, l, eiCurr, eiNext);
        } while (eiCurr != null);
    }

    public final void createEdgeEndForPrev(@NotNull Edge edge, @NotNull List<Object> l, @NotNull EdgeIntersection eiCurr, @Nullable EdgeIntersection eiPrev) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)eiCurr, (String)"eiCurr");
        int iPrev = eiCurr.getSegmentIndex();
        if (eiCurr.getDist() == 0.0) {
            if (iPrev == 0) {
                return;
            }
            --iPrev;
        }
        Coordinate pPrev = edge.getCoordinate(iPrev);
        if (eiPrev != null && eiPrev.getSegmentIndex() >= iPrev) {
            pPrev = eiPrev.getCoord();
        }
        Label label = edge.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label label2 = new Label(label);
        label2.flip();
        EdgeEnd e = new EdgeEnd(edge, eiCurr.getCoord(), pPrev, label2);
        l.add(e);
    }

    public final void createEdgeEndForNext(@NotNull Edge edge, @NotNull List<Object> l, @NotNull EdgeIntersection eiCurr, @Nullable EdgeIntersection eiNext) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)eiCurr, (String)"eiCurr");
        int iNext = eiCurr.getSegmentIndex() + 1;
        if (iNext >= edge.getNumPoints() && eiNext == null) {
            return;
        }
        Coordinate pNext = edge.getCoordinate(iNext);
        if (eiNext != null && eiNext.getSegmentIndex() == eiCurr.getSegmentIndex()) {
            pNext = eiNext.getCoord();
        }
        Coordinate coordinate = eiCurr.getCoord();
        Label label = edge.getLabel();
        Intrinsics.checkNotNull((Object)label);
        EdgeEnd e = new EdgeEnd(edge, coordinate, pNext, new Label(label));
        l.add(e);
    }
}

