/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.util.GeometryCombiner;
import org.locationtech.jts.legacy.TreeSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/operation/union/PointGeometryUnion;", "", "pointGeom", "Lorg/locationtech/jts/geom/Puntal;", "otherGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Puntal;Lorg/locationtech/jts/geom/Geometry;)V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "union", "Companion", "kts-core"})
public final class PointGeometryUnion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry pointGeom;
    @NotNull
    private final Geometry otherGeom;
    @NotNull
    private final GeometryFactory geomFact;

    public PointGeometryUnion(@NotNull Puntal pointGeom, @NotNull Geometry otherGeom) {
        Intrinsics.checkNotNullParameter((Object)pointGeom, (String)"pointGeom");
        Intrinsics.checkNotNullParameter((Object)otherGeom, (String)"otherGeom");
        this.pointGeom = (Geometry)((Object)pointGeom);
        this.otherGeom = otherGeom;
        this.geomFact = otherGeom.getFactory();
    }

    @Nullable
    public final Geometry union() {
        PointLocator locater = new PointLocator();
        Set exteriorCoords = (Set)((Object)new TreeSet(null, null, 3, null));
        int n = this.pointGeom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Coordinate coord;
            Geometry geometry = this.pointGeom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point point = (Point)geometry;
            Coordinate coordinate = coord = point.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            int loc = locater.locate(coordinate, this.otherGeom);
            if (loc != 2) continue;
            exteriorCoords.add(coord);
        }
        if (exteriorCoords.size() == 0) {
            return this.otherGeom;
        }
        Geometry ptComp = null;
        Coordinate[] coords = CoordinateArrays.toCoordinateArray(exteriorCoords);
        ptComp = coords.length == 1 ? (Geometry)this.geomFact.createPoint(coords[0]) : (Geometry)this.geomFact.createMultiPointFromCoords(coords);
        return GeometryCombiner.Companion.combine(ptComp, this.otherGeom);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/union/PointGeometryUnion$Companion;", "", "<init>", "()V", "union", "Lorg/locationtech/jts/geom/Geometry;", "pointGeom", "Lorg/locationtech/jts/geom/Puntal;", "otherGeom", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry union(@NotNull Puntal pointGeom, @NotNull Geometry otherGeom) {
            Intrinsics.checkNotNullParameter((Object)pointGeom, (String)"pointGeom");
            Intrinsics.checkNotNullParameter((Object)otherGeom, (String)"otherGeom");
            PointGeometryUnion unioner = new PointGeometryUnion(pointGeom, otherGeom);
            return unioner.union();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

