/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/valid/IndexedNestedPolygonTester;", "", "multiPoly", "Lorg/locationtech/jts/geom/MultiPolygon;", "<init>", "(Lorg/locationtech/jts/geom/MultiPolygon;)V", "index", "Lorg/locationtech/jts/index/SpatialIndex;", "locators", "", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "[Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "value", "Lorg/locationtech/jts/geom/Coordinate;", "nestedPoint", "getNestedPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "loadIndex", "", "getLocator", "polyIndex", "", "isNested", "", "()Z", "findNestedPoint", "shell", "Lorg/locationtech/jts/geom/LinearRing;", "possibleOuterPoly", "Lorg/locationtech/jts/geom/Polygon;", "locator", "Companion", "kts-core"})
public final class IndexedNestedPolygonTester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiPolygon multiPoly;
    @Nullable
    private SpatialIndex index;
    @Nullable
    private IndexedPointInAreaLocator[] locators;
    @Nullable
    private Coordinate nestedPoint;

    public IndexedNestedPolygonTester(@NotNull MultiPolygon multiPoly) {
        Intrinsics.checkNotNullParameter((Object)multiPoly, (String)"multiPoly");
        this.multiPoly = multiPoly;
        this.loadIndex();
    }

    @Nullable
    public final Coordinate getNestedPoint() {
        return this.nestedPoint;
    }

    private final void loadIndex() {
        this.index = new STRtree();
        int n = this.multiPoly.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = this.multiPoly.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            Envelope env = poly.getEnvelopeInternal();
            SpatialIndex spatialIndex = this.index;
            Intrinsics.checkNotNull((Object)spatialIndex);
            spatialIndex.insert(env, i);
        }
    }

    private final IndexedPointInAreaLocator getLocator(int polyIndex) {
        if (this.locators == null) {
            this.locators = new IndexedPointInAreaLocator[this.multiPoly.getNumGeometries()];
        }
        Intrinsics.checkNotNull((Object)this.locators);
        IndexedPointInAreaLocator locator = this.locators[polyIndex];
        if (locator == null) {
            locator = new IndexedPointInAreaLocator(this.multiPoly.getGeometryN(polyIndex));
            Intrinsics.checkNotNull((Object)this.locators);
            this.locators[polyIndex] = locator;
        }
        return locator;
    }

    public final boolean isNested() {
        int n = this.multiPoly.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            List<?> results;
            Geometry geometry = this.multiPoly.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            LinearRing shell = poly.getExteriorRing();
            SpatialIndex spatialIndex = this.index;
            Intrinsics.checkNotNull((Object)spatialIndex);
            List<?> list = results = spatialIndex.query(poly.getEnvelopeInternal());
            Intrinsics.checkNotNull(list);
            Iterator<?> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                int polyIndex = ((Number)iterator2.next()).intValue();
                Geometry geometry2 = this.multiPoly.getGeometryN(polyIndex);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                Polygon possibleOuterPoly = (Polygon)geometry2;
                if (poly == possibleOuterPoly || !possibleOuterPoly.getEnvelopeInternal().covers(poly.getEnvelopeInternal())) continue;
                this.nestedPoint = this.findNestedPoint(shell, possibleOuterPoly, this.getLocator(polyIndex));
                if (this.nestedPoint == null) continue;
                return true;
            }
        }
        return false;
    }

    private final Coordinate findNestedPoint(LinearRing shell, Polygon possibleOuterPoly, IndexedPointInAreaLocator locator) {
        LinearRing linearRing = shell;
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate shellPt0 = linearRing.getCoordinateN(0);
        int loc0 = locator.locate(shellPt0);
        if (loc0 == 2) {
            return null;
        }
        if (loc0 == 0) {
            return shellPt0;
        }
        Coordinate shellPt1 = shell.getCoordinateN(1);
        int loc1 = locator.locate(shellPt1);
        if (loc1 == 2) {
            return null;
        }
        return loc1 == 0 ? shellPt1 : IndexedNestedPolygonTester.Companion.findIncidentSegmentNestedPoint(shell, possibleOuterPoly);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/valid/IndexedNestedPolygonTester$Companion;", "", "<init>", "()V", "findIncidentSegmentNestedPoint", "Lorg/locationtech/jts/geom/Coordinate;", "shell", "Lorg/locationtech/jts/geom/LinearRing;", "poly", "Lorg/locationtech/jts/geom/Polygon;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate findIncidentSegmentNestedPoint(LinearRing shell, Polygon poly) {
            LinearRing polyShell;
            LinearRing linearRing = polyShell = poly.getExteriorRing();
            Intrinsics.checkNotNull((Object)linearRing);
            if (linearRing.isEmpty()) {
                return null;
            }
            if (!PolygonTopologyAnalyzer.Companion.isRingNested(shell, polyShell)) {
                return null;
            }
            int n = poly.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                LinearRing hole = poly.getInteriorRingN(i);
                if (!hole.getEnvelopeInternal().covers(shell.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.Companion.isRingNested(shell, hole)) continue;
                return null;
            }
            return shell.getCoordinateN(0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

