/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.valid.IndexedNestedHoleTester;
import org.locationtech.jts.operation.valid.IndexedNestedPolygonTester;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;
import org.locationtech.jts.operation.valid.TopologyValidationError;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001dH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001eH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001b\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0012\u0010&\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0012\u0010*\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010+\u001a\u00020\u000b2\b\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u001a\u0010.\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u001c\u00104\u001a\u0004\u0018\u00010\u00152\u0006\u00105\u001a\u00020\u001c2\b\u00106\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u00107\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u001eH\u0002J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006="}, d2={"Lorg/locationtech/jts/operation/valid/IsValidOp;", "", "inputGeometry", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "isInvertedRingValid", "", "validErr", "Lorg/locationtech/jts/operation/valid/TopologyValidationError;", "setSelfTouchingRingFormingHoleValid", "", "isValid", "()Z", "validationError", "getValidationError", "()Lorg/locationtech/jts/operation/valid/TopologyValidationError;", "logInvalid", "code", "", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "hasInvalidError", "isValidGeometry", "g", "Lorg/locationtech/jts/geom/Point;", "Lorg/locationtech/jts/geom/MultiPoint;", "Lorg/locationtech/jts/geom/LineString;", "Lorg/locationtech/jts/geom/LinearRing;", "Lorg/locationtech/jts/geom/Polygon;", "Lorg/locationtech/jts/geom/MultiPolygon;", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "checkCoordinatesValid", "coords", "", "([Lorg/locationtech/jts/geom/Coordinate;)V", "poly", "checkRingClosed", "ring", "checkRingsClosed", "checkRingsPointSize", "checkRingPointSize", "checkPointSize", "line", "minSize", "isNonRepeatedSizeAtLeast", "checkAreaIntersections", "areaAnalyzer", "Lorg/locationtech/jts/operation/valid/PolygonTopologyAnalyzer;", "checkRingSimple", "checkHolesInShell", "findHoleOutsideShellPoint", "hole", "shell", "checkHolesNotNested", "checkShellsNotNested", "mp", "checkInteriorConnected", "analyzer", "Companion", "kts-core"})
public final class IsValidOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeometry;
    private boolean isInvertedRingValid;
    @Nullable
    private TopologyValidationError validErr;
    private static final int MIN_SIZE_LINESTRING = 2;
    private static final int MIN_SIZE_RING = 4;

    public IsValidOp(@NotNull Geometry inputGeometry) {
        Intrinsics.checkNotNullParameter((Object)inputGeometry, (String)"inputGeometry");
        this.inputGeometry = inputGeometry;
    }

    public final void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isInvertedRingValid = isValid;
    }

    public final boolean isValid() {
        return this.isValidGeometry(this.inputGeometry);
    }

    @Nullable
    public final TopologyValidationError getValidationError() {
        this.isValidGeometry(this.inputGeometry);
        return this.validErr;
    }

    private final void logInvalid(int code, Coordinate pt) {
        this.validErr = new TopologyValidationError(code, pt);
    }

    private final boolean hasInvalidError() {
        return this.validErr != null;
    }

    private final boolean isValidGeometry(Geometry g) {
        this.validErr = null;
        if (g.isEmpty()) {
            return true;
        }
        if (g instanceof Point) {
            return this.isValid((Point)g);
        }
        if (g instanceof MultiPoint) {
            return this.isValid((MultiPoint)g);
        }
        if (g instanceof LinearRing) {
            return this.isValid((LinearRing)g);
        }
        if (g instanceof LineString) {
            return this.isValid((LineString)g);
        }
        if (g instanceof Polygon) {
            return this.isValid((Polygon)g);
        }
        if (g instanceof MultiPolygon) {
            return this.isValid((MultiPolygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.isValid((GeometryCollection)g);
        }
        throw new UnsupportedOperationException(String.valueOf(new PropertyReference0Impl(Reflection.getOrCreateKotlinClass(g.getClass())){

            public Object get() {
                return ((KClass)this.receiver).getSimpleName();
            }
        }));
    }

    private final boolean isValid(Point g) {
        this.checkCoordinatesValid(g.getCoordinates());
        return !this.hasInvalidError();
    }

    private final boolean isValid(MultiPoint g) {
        this.checkCoordinatesValid(g.getCoordinates());
        return !this.hasInvalidError();
    }

    private final boolean isValid(LineString g) {
        this.checkCoordinatesValid(g.getCoordinates());
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkPointSize(g, 2);
        return !this.hasInvalidError();
    }

    private final boolean isValid(LinearRing g) {
        this.checkCoordinatesValid(g.getCoordinates());
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingClosed(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingPointSize(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingSimple(g);
        return this.validErr == null;
    }

    private final boolean isValid(Polygon g) {
        this.checkCoordinatesValid(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingsClosed(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkRingsPointSize(g);
        if (this.hasInvalidError()) {
            return false;
        }
        PolygonTopologyAnalyzer areaAnalyzer = new PolygonTopologyAnalyzer(g, this.isInvertedRingValid);
        this.checkAreaIntersections(areaAnalyzer);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkHolesInShell(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkHolesNotNested(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkInteriorConnected(areaAnalyzer);
        return !this.hasInvalidError();
    }

    private final boolean isValid(MultiPolygon g) {
        Polygon p;
        int i;
        int n = g.getNumGeometries();
        for (int i2 = 0; i2 < n; ++i2) {
            Geometry geometry = g.getGeometryN(i2);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon p2 = (Polygon)geometry;
            this.checkCoordinatesValid(p2);
            if (this.hasInvalidError()) {
                return false;
            }
            this.checkRingsClosed(p2);
            if (this.hasInvalidError()) {
                return false;
            }
            this.checkRingsPointSize(p2);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        PolygonTopologyAnalyzer areaAnalyzer = new PolygonTopologyAnalyzer(g, this.isInvertedRingValid);
        this.checkAreaIntersections(areaAnalyzer);
        if (this.hasInvalidError()) {
            return false;
        }
        int n2 = g.getNumGeometries();
        for (i = 0; i < n2; ++i) {
            Geometry geometry = g.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            p = (Polygon)geometry;
            this.checkHolesInShell(p);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        n2 = g.getNumGeometries();
        for (i = 0; i < n2; ++i) {
            Geometry geometry = g.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            p = (Polygon)geometry;
            this.checkHolesNotNested(p);
            if (!this.hasInvalidError()) continue;
            return false;
        }
        this.checkShellsNotNested(g);
        if (this.hasInvalidError()) {
            return false;
        }
        this.checkInteriorConnected(areaAnalyzer);
        return !this.hasInvalidError();
    }

    private final boolean isValid(GeometryCollection gc) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            if (this.isValidGeometry(gc.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }

    private final void checkCoordinatesValid(Coordinate[] coords) {
        int n = coords.length;
        for (int i = 0; i < n; ++i) {
            if (Companion.isValid(coords[i])) continue;
            this.logInvalid(10, coords[i]);
            return;
        }
    }

    private final void checkCoordinatesValid(Polygon poly) {
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.checkCoordinatesValid(linearRing.getCoordinates());
        if (this.hasInvalidError()) {
            return;
        }
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            this.checkCoordinatesValid(poly.getInteriorRingN(i).getCoordinates());
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private final void checkRingClosed(LinearRing ring) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.isEmpty()) {
            return;
        }
        if (!ring.isClosed()) {
            Coordinate pt = ring.getNumPoints() >= 1 ? ring.getCoordinateN(0) : null;
            this.logInvalid(11, pt);
            return;
        }
    }

    private final void checkRingsClosed(Polygon poly) {
        this.checkRingClosed(poly.getExteriorRing());
        if (this.hasInvalidError()) {
            return;
        }
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            this.checkRingClosed(poly.getInteriorRingN(i));
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private final void checkRingsPointSize(Polygon poly) {
        this.checkRingPointSize(poly.getExteriorRing());
        if (this.hasInvalidError()) {
            return;
        }
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            this.checkRingPointSize(poly.getInteriorRingN(i));
            if (!this.hasInvalidError()) continue;
            return;
        }
    }

    private final void checkRingPointSize(LinearRing ring) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.isEmpty()) {
            return;
        }
        this.checkPointSize(ring, 4);
    }

    private final void checkPointSize(LineString line, int minSize) {
        if (!this.isNonRepeatedSizeAtLeast(line, minSize)) {
            LineString lineString = line;
            Intrinsics.checkNotNull((Object)lineString);
            Coordinate pt = lineString.getNumPoints() >= 1 ? line.getCoordinateN(0) : null;
            this.logInvalid(9, pt);
        }
    }

    private final boolean isNonRepeatedSizeAtLeast(LineString line, int minSize) {
        int numPts = 0;
        Coordinate prevPt = null;
        LineString lineString = line;
        Intrinsics.checkNotNull((Object)lineString);
        int n = lineString.getNumPoints();
        for (int i = 0; i < n; ++i) {
            if (numPts >= minSize) {
                return true;
            }
            Coordinate pt = line.getCoordinateN(i);
            if (prevPt == null || !pt.equals2D(prevPt)) {
                ++numPts;
            }
            prevPt = pt;
        }
        return numPts >= minSize;
    }

    private final void checkAreaIntersections(PolygonTopologyAnalyzer areaAnalyzer) {
        if (areaAnalyzer.hasInvalidIntersection()) {
            this.logInvalid(areaAnalyzer.getInvalidCode(), areaAnalyzer.getInvalidLocation());
            return;
        }
    }

    private final void checkRingSimple(LinearRing ring) {
        Coordinate intPt = PolygonTopologyAnalyzer.Companion.findSelfIntersection(ring);
        if (intPt != null) {
            this.logInvalid(6, intPt);
        }
    }

    private final void checkHolesInShell(Polygon poly) {
        LinearRing shell;
        if (poly.getNumInteriorRing() <= 0) {
            return;
        }
        LinearRing linearRing = shell = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        boolean isShellEmpty = linearRing.isEmpty();
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            if (hole.isEmpty()) continue;
            Coordinate invalidPt = null;
            invalidPt = isShellEmpty ? hole.getCoordinate() : this.findHoleOutsideShellPoint(hole, shell);
            if (invalidPt == null) continue;
            this.logInvalid(2, invalidPt);
            return;
        }
    }

    private final Coordinate findHoleOutsideShellPoint(LinearRing hole, LinearRing shell) {
        Coordinate holePt0 = hole.getCoordinateN(0);
        LinearRing linearRing = shell;
        Intrinsics.checkNotNull((Object)linearRing);
        if (!linearRing.getEnvelopeInternal().covers(hole.getEnvelopeInternal())) {
            return holePt0;
        }
        return PolygonTopologyAnalyzer.Companion.isRingNested(hole, shell) ? null : holePt0;
    }

    private final void checkHolesNotNested(Polygon poly) {
        if (poly.getNumInteriorRing() <= 0) {
            return;
        }
        IndexedNestedHoleTester nestedTester = new IndexedNestedHoleTester(poly);
        if (nestedTester.isNested()) {
            this.logInvalid(3, nestedTester.getNestedPoint());
        }
    }

    private final void checkShellsNotNested(MultiPolygon mp) {
        if (mp.getNumGeometries() <= 1) {
            return;
        }
        IndexedNestedPolygonTester nestedTester = new IndexedNestedPolygonTester(mp);
        if (nestedTester.isNested()) {
            this.logInvalid(7, nestedTester.getNestedPoint());
        }
    }

    private final void checkInteriorConnected(PolygonTopologyAnalyzer analyzer) {
        if (analyzer.isInteriorDisconnected()) {
            this.logInvalid(4, analyzer.getDisconnectionLocation());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/valid/IsValidOp$Companion;", "", "<init>", "()V", "MIN_SIZE_LINESTRING", "", "MIN_SIZE_RING", "isValid", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValid(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            IsValidOp isValidOp = new IsValidOp(geom);
            return isValidOp.isValid();
        }

        public final boolean isValid(@NotNull Coordinate coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            if (Math.INSTANCE.isNaN(coord.x)) {
                return false;
            }
            if (Math.INSTANCE.isInfinite(coord.x)) {
                return false;
            }
            if (Math.INSTANCE.isNaN(coord.y)) {
                return false;
            }
            return !Math.INSTANCE.isInfinite(coord.y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

