/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.valid.PolygonNode;
import org.locationtech.jts.operation.valid.PolygonRing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0003J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\tH\u0016J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\rH\u0002J@\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010%\u001a\u0004\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006("}, d2={"Lorg/locationtech/jts/operation/valid/PolygonIntersectionAnalyzer;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "isInvertedRingValid", "", "<init>", "(Z)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "value", "", "invalidCode", "getInvalidCode", "()I", "Lorg/locationtech/jts/geom/Coordinate;", "invalidLocation", "getInvalidLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "hasDoubleTouch", "doubleTouchLocation", "getDoubleTouchLocation", "isDone", "()Z", "isInvalid", "processIntersections", "", "ss0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "ss1", "segIndex1", "findInvalidIntersection", "addDoubleTouch", "intPt", "addSelfTouch", "ss", "e00", "e01", "e10", "e11", "Companion", "kts-core"})
public final class PolygonIntersectionAnalyzer
implements SegmentIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isInvertedRingValid;
    @NotNull
    private final LineIntersector li;
    private int invalidCode;
    @Nullable
    private Coordinate invalidLocation;
    private boolean hasDoubleTouch;
    @Nullable
    private Coordinate doubleTouchLocation;
    private static final int NO_INVALID_INTERSECTION = -1;

    public PolygonIntersectionAnalyzer(boolean isInvertedRingValid) {
        this.isInvertedRingValid = isInvertedRingValid;
        this.li = new RobustLineIntersector();
        this.invalidCode = -1;
    }

    public final int getInvalidCode() {
        return this.invalidCode;
    }

    @Nullable
    public final Coordinate getInvalidLocation() {
        return this.invalidLocation;
    }

    @Nullable
    public final Coordinate getDoubleTouchLocation() {
        return this.doubleTouchLocation;
    }

    @Override
    public boolean isDone() {
        return this.isInvalid() || this.hasDoubleTouch;
    }

    public final boolean isInvalid() {
        return this.invalidCode >= 0;
    }

    public final boolean hasDoubleTouch() {
        return this.hasDoubleTouch;
    }

    @Override
    public void processIntersections(@NotNull SegmentString ss0, int segIndex0, @NotNull SegmentString ss1, int segIndex1) {
        boolean isSameSegment;
        Intrinsics.checkNotNullParameter((Object)ss0, (String)"ss0");
        Intrinsics.checkNotNullParameter((Object)ss1, (String)"ss1");
        boolean isSameSegString = ss0 == ss1;
        boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
        if (isSameSegment) {
            return;
        }
        int code = this.findInvalidIntersection(ss0, segIndex0, ss1, segIndex1);
        if (code != -1) {
            this.invalidCode = code;
            this.invalidLocation = this.li.getIntersection(0);
        }
    }

    private final int findInvalidIntersection(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
        boolean isDoubleTouch;
        boolean hasCrossing;
        boolean isAdjacentSegments;
        boolean isSameSegString;
        Coordinate p00 = ss0.getCoordinate(segIndex0);
        Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = ss1.getCoordinate(segIndex1);
        Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (!this.li.hasIntersection()) {
            return -1;
        }
        boolean bl = isSameSegString = ss0 == ss1;
        if (this.li.isProper() || this.li.getIntersectionNum() >= 2) {
            return 5;
        }
        Coordinate intPt = this.li.getIntersection(0);
        boolean bl2 = isAdjacentSegments = isSameSegString && PolygonIntersectionAnalyzer.Companion.isAdjacentInRing(ss0, segIndex0, segIndex1);
        if (isAdjacentSegments) {
            return -1;
        }
        if (isSameSegString && !this.isInvertedRingValid) {
            return 6;
        }
        if (intPt.equals2D(p01) || intPt.equals2D(p11)) {
            return -1;
        }
        Coordinate e00 = p00;
        Coordinate e01 = p01;
        if (intPt.equals2D(p00)) {
            e00 = PolygonIntersectionAnalyzer.Companion.prevCoordinateInRing(ss0, segIndex0);
            e01 = p01;
        }
        Coordinate e10 = p10;
        Coordinate e11 = p11;
        if (intPt.equals2D(p10)) {
            e10 = PolygonIntersectionAnalyzer.Companion.prevCoordinateInRing(ss1, segIndex1);
            e11 = p11;
        }
        if (hasCrossing = PolygonNode.INSTANCE.isCrossing(intPt, e00, e01, e10, e11)) {
            return 5;
        }
        if (isSameSegString && this.isInvertedRingValid) {
            this.addSelfTouch(ss0, intPt, e00, e01, e10, e11);
        }
        if ((isDoubleTouch = this.addDoubleTouch(ss0, ss1, intPt)) && !isSameSegString) {
            this.hasDoubleTouch = true;
            this.doubleTouchLocation = intPt;
        }
        return -1;
    }

    private final boolean addDoubleTouch(SegmentString ss0, SegmentString ss1, Coordinate intPt) {
        return PolygonRing.Companion.addTouch((PolygonRing)ss0.getData(), (PolygonRing)ss1.getData(), intPt);
    }

    private final void addSelfTouch(SegmentString ss, Coordinate intPt, Coordinate e00, Coordinate e01, Coordinate e10, Coordinate e11) {
        PolygonRing polygonRing = (PolygonRing)ss.getData();
        if (polygonRing == null) {
            throw new IllegalStateException("SegmentString missing PolygonRing data when checking self-touches");
        }
        PolygonRing polyRing = polygonRing;
        polyRing.addSelfTouch(intPt, e00, e01, e10, e11);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonIntersectionAnalyzer$Companion;", "", "<init>", "()V", "NO_INVALID_INTERSECTION", "", "prevCoordinateInRing", "Lorg/locationtech/jts/geom/Coordinate;", "ringSS", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex", "isAdjacentInRing", "", "segIndex0", "segIndex1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate prevCoordinateInRing(SegmentString ringSS, int segIndex) {
            int prevIndex = segIndex - 1;
            if (prevIndex < 0) {
                prevIndex = ringSS.size() - 2;
            }
            return ringSS.getCoordinate(prevIndex);
        }

        private final boolean isAdjacentInRing(SegmentString ringSS, int segIndex0, int segIndex1) {
            int delta = Math.INSTANCE.abs(segIndex1 - segIndex0);
            if (delta <= 1) {
                return true;
            }
            return delta >= ringSS.size() - 2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

