/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.valid.PolygonIntersectionAnalyzer;
import org.locationtech.jts.operation.valid.PolygonNode;
import org.locationtech.jts.operation.valid.PolygonRing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u001f\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonTopologyAnalyzer;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isInvertedRingValid", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Z)V", "intFinder", "Lorg/locationtech/jts/operation/valid/PolygonIntersectionAnalyzer;", "polyRings", "", "Lorg/locationtech/jts/operation/valid/PolygonRing;", "value", "Lorg/locationtech/jts/geom/Coordinate;", "disconnectionLocation", "getDisconnectionLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "hasInvalidIntersection", "invalidCode", "", "getInvalidCode", "()I", "invalidLocation", "getInvalidLocation", "isInteriorDisconnected", "()Z", "checkInteriorDisconnectedByHoleCycle", "", "checkInteriorDisconnectedBySelfTouch", "analyze", "analyzeIntersections", "segStrings", "Lorg/locationtech/jts/noding/SegmentString;", "Companion", "kts-core"})
public final class PolygonTopologyAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isInvertedRingValid;
    @Nullable
    private PolygonIntersectionAnalyzer intFinder;
    @Nullable
    private List<PolygonRing> polyRings;
    @Nullable
    private Coordinate disconnectionLocation;

    public PolygonTopologyAnalyzer(@NotNull Geometry geom, boolean isInvertedRingValid) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.isInvertedRingValid = isInvertedRingValid;
        this.analyze(geom);
    }

    @Nullable
    public final Coordinate getDisconnectionLocation() {
        return this.disconnectionLocation;
    }

    public final boolean hasInvalidIntersection() {
        PolygonIntersectionAnalyzer polygonIntersectionAnalyzer = this.intFinder;
        Intrinsics.checkNotNull((Object)polygonIntersectionAnalyzer);
        return polygonIntersectionAnalyzer.isInvalid();
    }

    public final int getInvalidCode() {
        PolygonIntersectionAnalyzer polygonIntersectionAnalyzer = this.intFinder;
        Intrinsics.checkNotNull((Object)polygonIntersectionAnalyzer);
        return polygonIntersectionAnalyzer.getInvalidCode();
    }

    @Nullable
    public final Coordinate getInvalidLocation() {
        PolygonIntersectionAnalyzer polygonIntersectionAnalyzer = this.intFinder;
        Intrinsics.checkNotNull((Object)polygonIntersectionAnalyzer);
        return polygonIntersectionAnalyzer.getInvalidLocation();
    }

    public final boolean isInteriorDisconnected() {
        if (this.disconnectionLocation != null) {
            return true;
        }
        if (this.isInvertedRingValid) {
            this.checkInteriorDisconnectedBySelfTouch();
            if (this.disconnectionLocation != null) {
                return true;
            }
        }
        this.checkInteriorDisconnectedByHoleCycle();
        return this.disconnectionLocation != null;
    }

    public final void checkInteriorDisconnectedByHoleCycle() {
        if (this.polyRings != null) {
            List<PolygonRing> list = this.polyRings;
            Intrinsics.checkNotNull(list);
            this.disconnectionLocation = PolygonRing.Companion.findHoleCycleLocation(list);
        }
    }

    public final void checkInteriorDisconnectedBySelfTouch() {
        if (this.polyRings != null) {
            List<PolygonRing> list = this.polyRings;
            Intrinsics.checkNotNull(list);
            this.disconnectionLocation = PolygonRing.Companion.findInteriorSelfNode(list);
        }
    }

    private final void analyze(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        List segStrings = PolygonTopologyAnalyzer.Companion.createSegmentStrings(geom, this.isInvertedRingValid);
        this.polyRings = PolygonTopologyAnalyzer.Companion.getPolygonRings(segStrings);
        PolygonIntersectionAnalyzer polygonIntersectionAnalyzer = this.intFinder = this.analyzeIntersections(segStrings);
        Intrinsics.checkNotNull((Object)polygonIntersectionAnalyzer);
        if (polygonIntersectionAnalyzer.hasDoubleTouch()) {
            PolygonIntersectionAnalyzer polygonIntersectionAnalyzer2 = this.intFinder;
            Intrinsics.checkNotNull((Object)polygonIntersectionAnalyzer2);
            this.disconnectionLocation = polygonIntersectionAnalyzer2.getDoubleTouchLocation();
            return;
        }
    }

    private final PolygonIntersectionAnalyzer analyzeIntersections(List<? extends SegmentString> segStrings) {
        PolygonIntersectionAnalyzer segInt = new PolygonIntersectionAnalyzer(this.isInvertedRingValid);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(segInt);
        noder.computeNodes((Collection<? extends SegmentString>)segStrings);
        return segInt;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002J+\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0019\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001c\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J \u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010!2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0002J\u001a\u0010)\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010'H\u0002\u00a8\u0006+"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonTopologyAnalyzer$Companion;", "", "<init>", "()V", "isRingNested", "", "test", "Lorg/locationtech/jts/geom/LinearRing;", "target", "findNonEqualVertex", "Lorg/locationtech/jts/geom/Coordinate;", "ring", "p", "isIncidentSegmentInRing", "p0", "p1", "ringPts", "", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Z", "findRingVertexPrev", "index", "", "node", "([Lorg/locationtech/jts/geom/Coordinate;ILorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "findRingVertexNext", "ringIndexPrev", "([Lorg/locationtech/jts/geom/Coordinate;I)I", "ringIndexNext", "intersectingSegIndex", "pt", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)I", "findSelfIntersection", "createSegmentStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isInvertedRingValid", "getPolygonRings", "Lorg/locationtech/jts/operation/valid/PolygonRing;", "segStrings", "createSegString", "polyRing", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRingNested(@NotNull LinearRing test, @NotNull LinearRing target) {
            Intrinsics.checkNotNullParameter((Object)test, (String)"test");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Coordinate p0 = test.getCoordinateN(0);
            Coordinate[] targetPts = target.getCoordinates();
            int loc = PointLocation.locateInRing(p0, targetPts);
            if (loc == 2) {
                return false;
            }
            if (loc == 0) {
                return true;
            }
            Coordinate p1 = this.findNonEqualVertex(test, p0);
            return this.isIncidentSegmentInRing(p0, p1, targetPts);
        }

        private final Coordinate findNonEqualVertex(LinearRing ring, Coordinate p) {
            int i = 1;
            Coordinate next = ring.getCoordinateN(i);
            while (next.equals2D(p) && i < ring.getNumPoints() - 1) {
                next = ring.getCoordinateN(++i);
            }
            return next;
        }

        private final boolean isIncidentSegmentInRing(Coordinate p0, Coordinate p1, Coordinate[] ringPts) {
            boolean isInteriorOnRight;
            int index = this.intersectingSegIndex(ringPts, p0);
            if (index < 0) {
                throw new IllegalArgumentException("Segment vertex does not intersect ring");
            }
            Coordinate rPrev = this.findRingVertexPrev(ringPts, index, p0);
            Coordinate rNext = this.findRingVertexNext(ringPts, index, p0);
            boolean bl = isInteriorOnRight = !Orientation.isCCW(ringPts);
            if (!isInteriorOnRight) {
                Coordinate temp = rPrev;
                rPrev = rNext;
                rNext = temp;
            }
            return PolygonNode.INSTANCE.isInteriorSegment(p0, rPrev, rNext, p1);
        }

        private final Coordinate findRingVertexPrev(Coordinate[] ringPts, int index, Coordinate node) {
            int iPrev = index;
            Coordinate prev = ringPts[iPrev];
            while (node.equals2D(prev)) {
                iPrev = this.ringIndexPrev(ringPts, iPrev);
                prev = ringPts[iPrev];
            }
            return prev;
        }

        private final Coordinate findRingVertexNext(Coordinate[] ringPts, int index, Coordinate node) {
            int iNext = index + 1;
            Coordinate next = ringPts[iNext];
            while (node.equals2D(next)) {
                iNext = this.ringIndexNext(ringPts, iNext);
                next = ringPts[iNext];
            }
            return next;
        }

        private final int ringIndexPrev(Coordinate[] ringPts, int index) {
            return index == 0 ? ringPts.length - 2 : index - 1;
        }

        private final int ringIndexNext(Coordinate[] ringPts, int index) {
            return index >= ringPts.length - 2 ? 0 : index + 1;
        }

        private final int intersectingSegIndex(Coordinate[] ringPts, Coordinate pt) {
            LineIntersector li = new RobustLineIntersector();
            int n = ringPts.length - 1;
            for (int i = 0; i < n; ++i) {
                li.computeIntersection(pt, ringPts[i], ringPts[i + 1]);
                if (!li.hasIntersection()) continue;
                return pt.equals2D(ringPts[i + 1]) ? i + 1 : i;
            }
            return -1;
        }

        @Nullable
        public final Coordinate findSelfIntersection(@NotNull LinearRing ring) {
            Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
            PolygonTopologyAnalyzer ata = new PolygonTopologyAnalyzer(ring, false);
            return ata.hasInvalidIntersection() ? ata.getInvalidLocation() : null;
        }

        private final List<SegmentString> createSegmentStrings(Geometry geom, boolean isInvertedRingValid) {
            List segStrings = new ArrayList();
            if (geom instanceof LinearRing) {
                segStrings.add(this.createSegString((LinearRing)geom, null));
                return segStrings;
            }
            int n = geom.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry = geom.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                Polygon poly = (Polygon)geometry;
                if (poly.isEmpty()) continue;
                boolean hasHoles = poly.getNumInteriorRing() > 0;
                PolygonRing shellRing = null;
                if (hasHoles || isInvertedRingValid) {
                    shellRing = new PolygonRing(poly.getExteriorRing());
                }
                LinearRing linearRing = poly.getExteriorRing();
                Intrinsics.checkNotNull((Object)linearRing);
                segStrings.add(this.createSegString(linearRing, shellRing));
                int n2 = poly.getNumInteriorRing();
                for (int j = 0; j < n2; ++j) {
                    LinearRing hole = poly.getInteriorRingN(j);
                    if (hole.isEmpty()) continue;
                    PolygonRing holeRing = new PolygonRing(hole, j, shellRing);
                    segStrings.add(this.createSegString(hole, holeRing));
                }
            }
            return segStrings;
        }

        private final List<PolygonRing> getPolygonRings(List<? extends SegmentString> segStrings) {
            List polyRings = null;
            Iterator<? extends SegmentString> iterator2 = segStrings.iterator();
            while (iterator2.hasNext()) {
                SegmentString ss;
                SegmentString segmentString = ss = iterator2.next();
                Intrinsics.checkNotNull((Object)segmentString);
                PolygonRing polyRing = (PolygonRing)segmentString.getData();
                if (polyRing == null) continue;
                if (polyRings == null) {
                    polyRings = new ArrayList();
                }
                polyRings.add(polyRing);
            }
            return polyRings;
        }

        private final SegmentString createSegString(LinearRing ring, PolygonRing polyRing) {
            Coordinate[] pts = ring.getCoordinates();
            if (CoordinateArrays.INSTANCE.hasRepeatedPoints(pts)) {
                pts = CoordinateArrays.INSTANCE.removeRepeatedPoints(pts);
            }
            return new BasicSegmentString(pts, polyRing);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

