/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 F2\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001FB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010?\u001a\u00020@J\u0013\u0010B\u001a\u00020*2\b\u0010C\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u000e\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001c\u0010!\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020*@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00101\u001a\u0002002\u0006\u0010\u001e\u001a\u000200@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R(\u00106\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0010\"\u0004\b8\u0010\u0012R\u0011\u00109\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0014R\u0011\u0010;\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0014R\u0013\u0010=\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001bR\u0014\u0010A\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010'\u00a8\u0006G"}, d2={"Lorg/locationtech/jts/planargraph/DirectedEdge;", "Lorg/locationtech/jts/planargraph/GraphComponent;", "", "", "from", "Lorg/locationtech/jts/planargraph/Node;", "to", "directionPt", "Lorg/locationtech/jts/geom/Coordinate;", "edgeDirection", "", "<init>", "(Lorg/locationtech/jts/planargraph/Node;Lorg/locationtech/jts/planargraph/Node;Lorg/locationtech/jts/geom/Coordinate;Z)V", "parentEdge", "Lorg/locationtech/jts/planargraph/Edge;", "getParentEdge", "()Lorg/locationtech/jts/planargraph/Edge;", "setParentEdge", "(Lorg/locationtech/jts/planargraph/Edge;)V", "getFrom", "()Lorg/locationtech/jts/planargraph/Node;", "setFrom", "(Lorg/locationtech/jts/planargraph/Node;)V", "getTo", "setTo", "p0", "getP0", "()Lorg/locationtech/jts/geom/Coordinate;", "setP0", "(Lorg/locationtech/jts/geom/Coordinate;)V", "value", "getDirectionPt", "setDirectionPt", "sym", "getSym", "()Lorg/locationtech/jts/planargraph/DirectedEdge;", "setSym", "(Lorg/locationtech/jts/planargraph/DirectedEdge;)V", "getEdgeDirection", "()Z", "setEdgeDirection", "(Z)V", "", "quadrant", "getQuadrant", "()I", "setQuadrant", "(I)V", "", "angle", "getAngle", "()D", "setAngle", "(D)V", "edge", "getEdge", "setEdge", "fromNode", "getFromNode", "toNode", "getToNode", "coordinate", "getCoordinate", "remove", "", "isRemoved", "compareTo", "obj", "compareDirection", "e", "Companion", "kts-core"})
public class DirectedEdge
extends GraphComponent
implements Comparable<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Edge parentEdge;
    @NotNull
    private Node from;
    @NotNull
    private Node to;
    @Nullable
    private Coordinate p0;
    @NotNull
    private Coordinate directionPt;
    @Nullable
    private DirectedEdge sym;
    private boolean edgeDirection;
    private int quadrant;
    private double angle;

    public DirectedEdge(@NotNull Node from, @NotNull Node to, @NotNull Coordinate directionPt, boolean edgeDirection) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)directionPt, (String)"directionPt");
        this.from = from;
        this.to = to;
        this.edgeDirection = edgeDirection;
        this.p0 = from.getCoordinate();
        this.directionPt = directionPt;
        double d = directionPt.x;
        Coordinate coordinate = this.p0;
        Intrinsics.checkNotNull((Object)coordinate);
        double dx = d - coordinate.x;
        double d2 = directionPt.y;
        Coordinate coordinate2 = this.p0;
        Intrinsics.checkNotNull((Object)coordinate2);
        double dy = d2 - coordinate2.y;
        this.quadrant = Quadrant.INSTANCE.quadrant(dx, dy);
        this.angle = Math.INSTANCE.atan2(dy, dx);
    }

    @Nullable
    protected final Edge getParentEdge() {
        return this.parentEdge;
    }

    protected final void setParentEdge(@Nullable Edge edge) {
        this.parentEdge = edge;
    }

    @NotNull
    protected final Node getFrom() {
        return this.from;
    }

    protected final void setFrom(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
        this.from = node;
    }

    @NotNull
    protected final Node getTo() {
        return this.to;
    }

    protected final void setTo(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
        this.to = node;
    }

    @Nullable
    protected final Coordinate getP0() {
        return this.p0;
    }

    protected final void setP0(@Nullable Coordinate coordinate) {
        this.p0 = coordinate;
    }

    @NotNull
    public final Coordinate getDirectionPt() {
        return this.directionPt;
    }

    protected final void setDirectionPt(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.directionPt = coordinate;
    }

    @Nullable
    public final DirectedEdge getSym() {
        return this.sym;
    }

    public final void setSym(@Nullable DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    public final boolean getEdgeDirection() {
        return this.edgeDirection;
    }

    protected final void setEdgeDirection(boolean bl) {
        this.edgeDirection = bl;
    }

    public final int getQuadrant() {
        return this.quadrant;
    }

    protected final void setQuadrant(int n) {
        this.quadrant = n;
    }

    public final double getAngle() {
        return this.angle;
    }

    protected final void setAngle(double d) {
        this.angle = d;
    }

    @Nullable
    public final Edge getEdge() {
        return this.parentEdge;
    }

    public final void setEdge(@Nullable Edge parentEdge) {
        this.parentEdge = parentEdge;
    }

    @NotNull
    public final Node getFromNode() {
        return this.from;
    }

    @NotNull
    public final Node getToNode() {
        return this.to;
    }

    @Nullable
    public final Coordinate getCoordinate() {
        return this.from.getCoordinate();
    }

    public final void remove() {
        this.sym = null;
        this.parentEdge = null;
    }

    @Override
    public boolean isRemoved() {
        return this.parentEdge == null;
    }

    @Override
    public int compareTo(@Nullable Object obj) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
        DirectedEdge de = (DirectedEdge)obj;
        return this.compareDirection(de);
    }

    public final int compareDirection(@NotNull DirectedEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.quadrant > e.quadrant) {
            return 1;
        }
        return this.quadrant < e.quadrant ? -1 : Orientation.index(e.p0, e.directionPt, this.directionPt);
    }

    @JvmStatic
    @NotNull
    public static final List<Object> toEdges(@NotNull Collection<?> dirEdges) {
        return Companion.toEdges(dirEdges);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/planargraph/DirectedEdge$Companion;", "", "<init>", "()V", "toEdges", "", "dirEdges", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Object> toEdges(@NotNull Collection<?> dirEdges) {
            Intrinsics.checkNotNullParameter(dirEdges, (String)"dirEdges");
            List edges = new ArrayList();
            for (Object obj : dirEdges) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
                edges.add(((DirectedEdge)obj).getParentEdge());
            }
            return edges;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

