/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0086\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\b\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/planargraph/DirectedEdgeStar;", "", "<init>", "()V", "outEdges", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "getOutEdges", "()Ljava/util/List;", "setOutEdges", "(Ljava/util/List;)V", "sorted", "", "add", "", "de", "remove", "iterator", "", "degree", "", "getDegree", "()I", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "edges", "", "getEdges", "sortEdges", "getIndex", "edge", "Lorg/locationtech/jts/planargraph/Edge;", "dirEdge", "i", "getNextEdge", "getNextCWEdge", "kts-core"})
public final class DirectedEdgeStar {
    @NotNull
    private List<DirectedEdge> outEdges = new ArrayList();
    private boolean sorted;

    @NotNull
    protected final List<DirectedEdge> getOutEdges() {
        return this.outEdges;
    }

    protected final void setOutEdges(@NotNull List<DirectedEdge> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.outEdges = list;
    }

    public final void add(@NotNull DirectedEdge de) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        this.outEdges.add(de);
        this.sorted = false;
    }

    public final void remove(@NotNull DirectedEdge de) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        this.outEdges.remove(de);
    }

    @NotNull
    public final Iterator<DirectedEdge> iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public final int getDegree() {
        return this.outEdges.size();
    }

    @Nullable
    public final Coordinate getCoordinate() {
        Iterator<DirectedEdge> it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next().getCoordinate();
    }

    @NotNull
    public final List<DirectedEdge> getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    private final void sortEdges() {
        if (!this.sorted) {
            CollectionsKt.sortWith(this.outEdges, (Comparator)new Comparator<Object>(){

                public int compare(Object a, Object b) {
                    if (a instanceof Comparable) {
                        return ((Comparable)a).compareTo(b);
                    }
                    Object object = a;
                    Object object2 = b;
                    return Intrinsics.compare((int)(object != null ? object.hashCode() : 0), (int)(object2 != null ? object2.hashCode() : 0));
                }
            });
            this.sorted = true;
        }
    }

    public final int getIndex(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.sortEdges();
        int n = ((Collection)this.outEdges).size();
        for (int i = 0; i < n; ++i) {
            if (this.outEdges.get(i).getEdge() != edge) continue;
            return i;
        }
        return -1;
    }

    public final int getIndex(@NotNull DirectedEdge dirEdge) {
        Intrinsics.checkNotNullParameter((Object)dirEdge, (String)"dirEdge");
        this.sortEdges();
        int n = ((Collection)this.outEdges).size();
        for (int i = 0; i < n; ++i) {
            if (this.outEdges.get(i) != dirEdge) continue;
            return i;
        }
        return -1;
    }

    public final int getIndex(int i) {
        int modi = i % this.outEdges.size();
        if (modi < 0) {
            modi += this.outEdges.size();
        }
        return modi;
    }

    @NotNull
    public final DirectedEdge getNextEdge(@NotNull DirectedEdge dirEdge) {
        Intrinsics.checkNotNullParameter((Object)dirEdge, (String)"dirEdge");
        int i = this.getIndex(dirEdge);
        return this.outEdges.get(this.getIndex(i + 1));
    }

    @NotNull
    public final DirectedEdge getNextCWEdge(@NotNull DirectedEdge dirEdge) {
        Intrinsics.checkNotNullParameter((Object)dirEdge, (String)"dirEdge");
        int i = this.getIndex(dirEdge);
        return this.outEdges.get(this.getIndex(i - 1));
    }
}

