/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.NodeMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0004J\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0086\u0002J\u0013\u0010 \u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0086\u0002J\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u001fJ\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001fJ\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030%J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010*\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140,2\u0006\u0010-\u001a\u00020.R\"\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010$\u001a\u0006\u0012\u0002\b\u00030%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/planargraph/PlanarGraph;", "", "<init>", "()V", "edges", "", "getEdges", "()Ljava/util/Set;", "setEdges", "(Ljava/util/Set;)V", "dirEdges", "getDirEdges", "setDirEdges", "nodeMap", "Lorg/locationtech/jts/planargraph/NodeMap;", "getNodeMap", "()Lorg/locationtech/jts/planargraph/NodeMap;", "setNodeMap", "(Lorg/locationtech/jts/planargraph/NodeMap;)V", "findNode", "Lorg/locationtech/jts/planargraph/Node;", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "add", "", "node", "edge", "Lorg/locationtech/jts/planargraph/Edge;", "dirEdge", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "nodeIterator", "", "contains", "", "e", "de", "nodes", "", "getNodes", "()Ljava/util/Collection;", "dirEdgeIterator", "edgeIterator", "remove", "findNodesOfDegree", "", "degree", "", "kts-core"})
public abstract class PlanarGraph {
    @NotNull
    private Set<Object> edges = new HashSet();
    @NotNull
    private Set<Object> dirEdges = new HashSet();
    @NotNull
    private NodeMap nodeMap = new NodeMap();

    @NotNull
    protected final Set<Object> getEdges() {
        return this.edges;
    }

    protected final void setEdges(@NotNull Set<Object> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.edges = set;
    }

    @NotNull
    protected final Set<Object> getDirEdges() {
        return this.dirEdges;
    }

    protected final void setDirEdges(@NotNull Set<Object> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.dirEdges = set;
    }

    @NotNull
    protected final NodeMap getNodeMap() {
        return this.nodeMap;
    }

    protected final void setNodeMap(@NotNull NodeMap nodeMap) {
        Intrinsics.checkNotNullParameter((Object)nodeMap, (String)"<set-?>");
        this.nodeMap = nodeMap;
    }

    @Nullable
    public final Node findNode(@Nullable Coordinate pt) {
        return this.nodeMap.find(pt);
    }

    protected final void add(@Nullable Node node) {
        Node node2 = node;
        Intrinsics.checkNotNull((Object)node2);
        this.nodeMap.add(node2);
    }

    protected final void add(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.edges.add(edge);
        this.add(edge.getDirEdge(0));
        this.add(edge.getDirEdge(1));
    }

    protected final void add(@Nullable DirectedEdge dirEdge) {
        this.dirEdges.add(dirEdge);
    }

    @NotNull
    public final Iterator<?> nodeIterator() {
        return this.nodeMap.iterator();
    }

    public final boolean contains(@Nullable Edge e) {
        return this.edges.contains(e);
    }

    public final boolean contains(@Nullable DirectedEdge de) {
        return this.dirEdges.contains(de);
    }

    @NotNull
    public final Collection<?> getNodes() {
        return this.nodeMap.values();
    }

    @NotNull
    public final Iterator<?> dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    @NotNull
    public final Iterator<?> edgeIterator() {
        return this.edges.iterator();
    }

    @NotNull
    public final Collection<?> getEdges() {
        return this.edges;
    }

    public final void remove(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.remove(edge.getDirEdge(0));
        this.remove(edge.getDirEdge(1));
        this.edges.remove(edge);
        edge.remove();
    }

    public final void remove(@NotNull DirectedEdge de) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        DirectedEdge sym = de.getSym();
        if (sym != null) {
            sym.setSym(null);
        }
        de.getFromNode().remove(de);
        de.remove();
        this.dirEdges.remove(de);
    }

    public final void remove(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<DirectedEdge> outEdges = node.getOutEdges().getEdges();
        Iterator<DirectedEdge> i = outEdges.iterator();
        while (i.hasNext()) {
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
            DirectedEdge sym = de.getSym();
            if (sym != null) {
                this.remove(sym);
            }
            this.dirEdges.remove(de);
            Edge edge = de.getEdge();
            if (edge == null) continue;
            this.edges.remove(edge);
        }
        this.nodeMap.remove(node.getCoordinate());
        node.remove();
    }

    @NotNull
    public final List<Node> findNodesOfDegree(int degree) {
        List nodesFound = new ArrayList();
        Iterator<?> i = this.nodeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)obj;
            if (node.getDegree() != degree) continue;
            nodesFound.add(node);
        }
        return nodesFound;
    }
}

