/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;
import org.locationtech.jts.planargraph.Subgraph;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\bH\u0002J0\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0007j\b\u0012\u0004\u0012\u00020\r`\u00142\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/planargraph/algorithm/ConnectedSubgraphFinder;", "", "graph", "Lorg/locationtech/jts/planargraph/PlanarGraph;", "<init>", "(Lorg/locationtech/jts/planargraph/PlanarGraph;)V", "connectedSubgraphs", "", "Lorg/locationtech/jts/planargraph/Subgraph;", "getConnectedSubgraphs", "()Ljava/util/List;", "findSubgraph", "node", "Lorg/locationtech/jts/planargraph/Node;", "addReachable", "", "startNode", "subgraph", "addEdges", "nodeStack", "Lorg/locationtech/jts/legacy/Stack;", "kts-core"})
@SourceDebugExtension(value={"SMAP\nConnectedSubgraphFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectedSubgraphFinder.kt\norg/locationtech/jts/planargraph/algorithm/ConnectedSubgraphFinder\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,77:1\n21#2:78\n*S KotlinDebug\n*F\n+ 1 ConnectedSubgraphFinder.kt\norg/locationtech/jts/planargraph/algorithm/ConnectedSubgraphFinder\n*L\n74#1:78\n*E\n"})
public final class ConnectedSubgraphFinder {
    @NotNull
    private final PlanarGraph graph;

    public ConnectedSubgraphFinder(@NotNull PlanarGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
    }

    @NotNull
    public final List<Subgraph> getConnectedSubgraphs() {
        List subgraphs = new ArrayList();
        GraphComponent.Companion.setVisited(this.graph.nodeIterator(), false);
        Iterator<?> i = this.graph.edgeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Edge");
            Edge e = (Edge)obj;
            Node node = e.getDirEdge(0).getFromNode();
            if (node.isVisited()) continue;
            subgraphs.add(this.findSubgraph(node));
        }
        return subgraphs;
    }

    private final Subgraph findSubgraph(Node node) {
        Subgraph subgraph = new Subgraph(this.graph);
        this.addReachable(node, subgraph);
        return subgraph;
    }

    private final void addReachable(Node startNode, Subgraph subgraph) {
        List nodeStack = new ArrayList();
        nodeStack.add(startNode);
        while (!StackKt.empty(nodeStack)) {
            Object t = StackKt.pop(nodeStack);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)t;
            this.addEdges(node, nodeStack, subgraph);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addEdges(Node node, List<Node> nodeStack, Subgraph subgraph) {
        node.setVisited(true);
        Iterator<DirectedEdge> i = node.getOutEdges().iterator();
        while (i.hasNext()) {
            void $this$push$iv;
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
            Edge edge = de.getEdge();
            Intrinsics.checkNotNull((Object)edge);
            subgraph.add(edge);
            Node toNode = de.getToNode();
            if (toNode.isVisited()) continue;
            List<Node> list = nodeStack;
            Node item$iv = toNode;
            boolean $i$f$push = false;
            $this$push$iv.add(item$iv);
        }
    }
}

