/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/precision/CommonBits;", "", "<init>", "()V", "isFirst", "", "commonMantissaBitsCount", "", "commonBits", "", "commonSignExp", "add", "", "num", "", "common", "getCommon", "()D", "toString", "", "bits", "Companion", "kts-core"})
public final class CommonBits {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isFirst = true;
    private int commonMantissaBitsCount = 53;
    private long commonBits;
    private long commonSignExp;

    public final void add(double num) {
        long numBits = Math.INSTANCE.doubleToLongBits(num);
        if (this.isFirst) {
            this.commonBits = numBits;
            this.commonSignExp = Companion.signExpBits(this.commonBits);
            this.isFirst = false;
            return;
        }
        long numSignExp = Companion.signExpBits(numBits);
        if (numSignExp != this.commonSignExp) {
            this.commonBits = 0L;
            return;
        }
        this.commonMantissaBitsCount = Companion.numCommonMostSigMantissaBits(this.commonBits, numBits);
        this.commonBits = Companion.zeroLowerBits(this.commonBits, 64 - (12 + this.commonMantissaBitsCount));
    }

    public final double getCommon() {
        return Math.INSTANCE.longBitsToDouble(this.commonBits);
    }

    @NotNull
    public final String toString(long bits) {
        double x = Math.INSTANCE.longBitsToDouble(bits);
        String numStr = Math.INSTANCE.toBinaryString(bits);
        String padStr = "0000000000000000000000000000000000000000000000000000000000000000" + numStr;
        String string = padStr.substring(padStr.length() - 64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String bitStr = string;
        String string2 = bitStr.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = bitStr.substring(1, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = bitStr.substring(12);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return string2 + "  " + string3 + "(exp) " + string4 + " [ " + x + " ]";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/precision/CommonBits$Companion;", "", "<init>", "()V", "signExpBits", "", "num", "numCommonMostSigMantissaBits", "", "num1", "num2", "zeroLowerBits", "bits", "nBits", "getBit", "i", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final long signExpBits(long num) {
            return num >> 52;
        }

        public final int numCommonMostSigMantissaBits(long num1, long num2) {
            int count = 0;
            for (int i = 52; -1 < i; --i) {
                if (this.getBit(num1, i) != this.getBit(num2, i)) {
                    return count;
                }
                ++count;
            }
            return 52;
        }

        public final long zeroLowerBits(long bits, int nBits) {
            long invMask = (1L << nBits) - 1L;
            long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
            return bits & mask;
        }

        public final int getBit(long bits, int i) {
            long mask = 1L << i;
            return (bits & mask) != 0L ? 1 : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

