/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.overlayng.PrecisionReducer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u001a\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/precision/PrecisionReducerTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "targetPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "isRemoveCollapsed", "", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;Z)V", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coordinates", "parent", "Lorg/locationtech/jts/geom/Geometry;", "extend", "", "Lorg/locationtech/jts/geom/Coordinate;", "coords", "minLength", "", "([Lorg/locationtech/jts/geom/Coordinate;I)[Lorg/locationtech/jts/geom/Coordinate;", "reduceCompress", "(Lorg/locationtech/jts/geom/CoordinateSequence;)[Lorg/locationtech/jts/geom/Coordinate;", "transformPolygon", "geom", "Lorg/locationtech/jts/geom/Polygon;", "transformMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "reduceArea", "Companion", "kts-core"})
public final class PrecisionReducerTransformer
extends GeometryTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel targetPM;
    private final boolean isRemoveCollapsed;

    public PrecisionReducerTransformer(@NotNull PrecisionModel targetPM, boolean isRemoveCollapsed) {
        Intrinsics.checkNotNullParameter((Object)targetPM, (String)"targetPM");
        this.targetPM = targetPM;
        this.isRemoveCollapsed = isRemoveCollapsed;
    }

    public /* synthetic */ PrecisionReducerTransformer(PrecisionModel precisionModel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(precisionModel, bl);
    }

    @Override
    @Nullable
    protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coordinates, @Nullable Geometry parent) {
        CoordinateSequence coordinateSequence = coordinates;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reduceCompress(coordinates);
        int minSize = 0;
        if (parent instanceof LineString) {
            minSize = 2;
        }
        if (parent instanceof LinearRing) {
            minSize = 3;
        }
        if (coordsReduce.length < minSize) {
            if (this.isRemoveCollapsed) {
                return null;
            }
            coordsReduce = this.extend(coordsReduce, minSize);
        }
        GeometryFactory geometryFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private final Coordinate[] extend(Coordinate[] coords, int minLength) {
        if (coords.length >= minLength) {
            return coords;
        }
        Object[] exCoords = new Coordinate[minLength];
        int n = exCoords.length;
        for (int i = 0; i < n; ++i) {
            int iSrc = i < coords.length ? i : coords.length - 1;
            exCoords[i] = coords[iSrc].copy();
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])exCoords);
    }

    private final Coordinate[] reduceCompress(CoordinateSequence coordinates) {
        CoordinateList noRepeatCoordList = new CoordinateList();
        int n = coordinates.size();
        for (int i = 0; i < n; ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            noRepeatCoordList.add(coord, false);
        }
        return noRepeatCoordList.toCoordinateArray();
    }

    @Override
    @NotNull
    protected Geometry transformPolygon(@NotNull Polygon geom, @Nullable Geometry parent) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.reduceArea(geom);
    }

    @Override
    @NotNull
    protected Geometry transformMultiPolygon(@NotNull MultiPolygon geom, @Nullable Geometry parent) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.reduceArea(geom);
    }

    private final Geometry reduceArea(Geometry geom) {
        return PrecisionReducer.reducePrecision(geom, this.targetPM);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/precision/PrecisionReducerTransformer$Companion;", "", "<init>", "()V", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "geom", "targetPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "isRemoveCollapsed", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Geometry reduce(@Nullable Geometry geom, @NotNull PrecisionModel targetPM, boolean isRemoveCollapsed) {
            Intrinsics.checkNotNullParameter((Object)targetPM, (String)"targetPM");
            PrecisionReducerTransformer trans = new PrecisionReducerTransformer(targetPM, isRemoveCollapsed);
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            return trans.transform(geometry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

