/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryEditor;

@Deprecated(message="use GeometryPrecisionReducer")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/precision/SimpleGeometryPrecisionReducer;", "", "newPrecisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "removeCollapsed", "", "changePrecisionModel", "setRemoveCollapsedComponents", "", "setChangePrecisionModel", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "geom", "PrecisionReducerCoordinateOperation", "Companion", "kts-core"})
public final class SimpleGeometryPrecisionReducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel newPrecisionModel;
    private boolean removeCollapsed;
    private boolean changePrecisionModel;

    public SimpleGeometryPrecisionReducer(@NotNull PrecisionModel newPrecisionModel) {
        Intrinsics.checkNotNullParameter((Object)newPrecisionModel, (String)"newPrecisionModel");
        this.newPrecisionModel = newPrecisionModel;
        this.removeCollapsed = true;
    }

    public final void setRemoveCollapsedComponents(boolean removeCollapsed) {
        this.removeCollapsed = removeCollapsed;
    }

    public final void setChangePrecisionModel(boolean changePrecisionModel) {
        this.changePrecisionModel = changePrecisionModel;
    }

    @Nullable
    public final Geometry reduce(@NotNull Geometry geom) {
        GeometryEditor geometryEditor;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (this.changePrecisionModel) {
            GeometryFactory newFactory = new GeometryFactory(this.newPrecisionModel, geom.getFactory().getSRID());
            geometryEditor = new GeometryEditor(newFactory);
        } else {
            geometryEditor = new GeometryEditor();
        }
        GeometryEditor geomEdit = geometryEditor;
        return geomEdit.edit(geom, new PrecisionReducerCoordinateOperation());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/precision/SimpleGeometryPrecisionReducer$Companion;", "", "<init>", "()V", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "g", "precModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry reduce(@NotNull Geometry g, @NotNull PrecisionModel precModel) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)precModel, (String)"precModel");
            SimpleGeometryPrecisionReducer reducer = new SimpleGeometryPrecisionReducer(precModel);
            return reducer.reduce(g);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/precision/SimpleGeometryPrecisionReducer$PrecisionReducerCoordinateOperation;", "Lorg/locationtech/jts/geom/util/GeometryEditor$CoordinateOperation;", "<init>", "(Lorg/locationtech/jts/precision/SimpleGeometryPrecisionReducer;)V", "edit", "", "Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "geom", "Lorg/locationtech/jts/geom/Geometry;", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    private final class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        @Override
        @Nullable
        public Coordinate[] edit(@Nullable Coordinate[] coordinates, @NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Intrinsics.checkNotNull((Object)coordinates);
            if (coordinates.length == 0) {
                return null;
            }
            Object[] reducedCoords = new Coordinate[coordinates.length];
            int n = coordinates.length;
            for (int i = 0; i < n; ++i) {
                Coordinate coord = new Coordinate(coordinates[i]);
                SimpleGeometryPrecisionReducer.this.newPrecisionModel.makePrecise(coord);
                reducedCoords[i] = coord;
            }
            CoordinateList noRepeatedCoordList = new CoordinateList((Coordinate[])ArraysKt.requireNoNulls((Object[])reducedCoords), false);
            Coordinate[] noRepeatedCoords = noRepeatedCoordList.toCoordinateArray();
            int minLength = 0;
            if (geom instanceof LineString) {
                minLength = 2;
            }
            if (geom instanceof LinearRing) {
                minLength = 4;
            }
            Object[] collapsedCoords = reducedCoords;
            if (SimpleGeometryPrecisionReducer.this.removeCollapsed) {
                collapsedCoords = null;
            }
            return noRepeatedCoords.length < minLength ? (collapsedCoords != null ? (Coordinate[])ArraysKt.requireNoNulls((Object[])collapsedCoords) : null) : noRepeatedCoords;
        }
    }
}

