/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 >2\u00020\u0001:\u0001>B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tB\u001b\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J#\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010+J)\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010,J4\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\b\u00101\u001a\u0004\u0018\u00010\u00142\b\u00102\u001a\u0004\u0018\u00010\u00142\u0006\u00103\u001a\u00020'H\u0002J9\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u00104J+\u00105\u001a\u00020.2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002\u00a2\u0006\u0002\u00107JO\u00108\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\b\u00109\u001a\u0004\u0018\u00010\u00142\b\u0010:\u001a\u0004\u0018\u00010\u00142\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00170\u00132\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010=R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006?"}, d2={"Lorg/locationtech/jts/shape/CubicBezierCurve;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "alpha", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;D)V", "skew", "(Lorg/locationtech/jts/geom/Geometry;DD)V", "controlPoints", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "minSegmentLength", "numVerticesPerSegment", "", "inputGeom", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "bezierCurvePts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "interpolationParam", "", "[[D", "controlPointIndex", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "bezierLine", "Lorg/locationtech/jts/geom/LineString;", "ls", "bezierRing", "Lorg/locationtech/jts/geom/LinearRing;", "ring", "bezierPolygon", "Lorg/locationtech/jts/geom/Polygon;", "poly", "bezierCurve", "Lorg/locationtech/jts/geom/CoordinateList;", "coords", "isRing", "", "([Lorg/locationtech/jts/geom/Coordinate;Z)Lorg/locationtech/jts/geom/CoordinateList;", "([Lorg/locationtech/jts/geom/Coordinate;Z)[Lorg/locationtech/jts/geom/Coordinate;", "addCurve", "", "p0", "p1", "ctrl0", "crtl1", "curvePts", "([Lorg/locationtech/jts/geom/Coordinate;ZDD)[Lorg/locationtech/jts/geom/Coordinate;", "setLineEndControlPoints", "ctrl", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)V", "cubicBezier", "ctrl1", "ctrl2", "param", "curve", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;[[D[Lorg/locationtech/jts/geom/Coordinate;)V", "Companion", "kts-core"})
public final class CubicBezierCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double minSegmentLength;
    private final int numVerticesPerSegment;
    @NotNull
    private Geometry inputGeom;
    private double alpha;
    private double skew;
    @Nullable
    private Geometry controlPoints;
    @NotNull
    private final GeometryFactory geomFactory;
    private Coordinate[] bezierCurvePts;
    private double[][] interpolationParam;
    private int controlPointIndex;
    private static final double CIRCLE_LEN_FACTOR = 0.375;

    public CubicBezierCurve(@NotNull Geometry geom, double alpha) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.numVerticesPerSegment = 16;
        this.alpha = -1.0;
        double alpha2 = alpha;
        this.inputGeom = geom;
        this.geomFactory = geom.getFactory();
        if (alpha2 < 0.0) {
            alpha2 = 0.0;
        }
        this.alpha = alpha2;
    }

    public CubicBezierCurve(@NotNull Geometry geom, double alpha, double skew) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.numVerticesPerSegment = 16;
        this.alpha = -1.0;
        double alpha2 = alpha;
        this.inputGeom = geom;
        this.geomFactory = geom.getFactory();
        if (alpha2 < 0.0) {
            alpha2 = 0.0;
        }
        this.alpha = alpha2;
        this.skew = skew;
    }

    public CubicBezierCurve(@NotNull Geometry geom, @Nullable Geometry controlPoints) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.numVerticesPerSegment = 16;
        this.alpha = -1.0;
        this.inputGeom = geom;
        this.geomFactory = geom.getFactory();
        this.controlPoints = controlPoints;
    }

    @NotNull
    public final Geometry getResult() {
        this.bezierCurvePts = new Coordinate[this.numVerticesPerSegment];
        this.interpolationParam = CubicBezierCurve.Companion.computeIterpolationParameters(this.numVerticesPerSegment);
        return GeometryMapper.flatMap(this.inputGeom, 1, new GeometryMapper.MapOp(this){
            final /* synthetic */ CubicBezierCurve this$0;
            {
                this.this$0 = $receiver;
            }

            public Geometry map(Geometry geom) {
                Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
                if (geom instanceof LineString) {
                    return CubicBezierCurve.access$bezierLine(this.this$0, (LineString)geom);
                }
                return geom instanceof Polygon ? (Geometry)CubicBezierCurve.access$bezierPolygon(this.this$0, (Polygon)geom) : geom.copy();
            }
        });
    }

    private final LineString bezierLine(LineString ls) {
        Coordinate[] coords = ls.getCoordinates();
        CoordinateList curvePts = this.bezierCurve(coords, false);
        curvePts.add(coords[coords.length - 1].copy(), false);
        return this.geomFactory.createLineString(curvePts.toCoordinateArray());
    }

    private final LinearRing bezierRing(LinearRing ring) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] coords = linearRing.getCoordinates();
        CoordinateList curvePts = this.bezierCurve(coords, true);
        curvePts.closeRing();
        return this.geomFactory.createLinearRing(curvePts.toCoordinateArray());
    }

    private final Polygon bezierPolygon(Polygon poly) {
        LinearRing shell = this.bezierRing(poly.getExteriorRing());
        Object[] holes = null;
        if (poly.getNumInteriorRing() > 0) {
            holes = new LinearRing[poly.getNumInteriorRing()];
            int n = poly.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                holes[i] = this.bezierRing(poly.getInteriorRingN(i));
            }
        }
        return this.geomFactory.createPolygon(shell, (LinearRing[])(holes != null ? (LinearRing[])ArraysKt.requireNoNulls((Object[])holes) : null));
    }

    private final CoordinateList bezierCurve(Coordinate[] coords, boolean isRing) {
        Coordinate[] control = this.controlPoints(coords, isRing);
        CoordinateList curvePts = new CoordinateList();
        int n = coords.length - 1;
        for (int i = 0; i < n; ++i) {
            int ctrlIndex = 2 * i;
            this.addCurve(coords[i], coords[i + 1], control[ctrlIndex], control[ctrlIndex + 1], curvePts);
        }
        return curvePts;
    }

    private final Coordinate[] controlPoints(Coordinate[] coords, boolean isRing) {
        if (this.controlPoints != null) {
            Geometry geometry = this.controlPoints;
            Intrinsics.checkNotNull((Object)geometry);
            if (this.controlPointIndex >= geometry.getNumGeometries()) {
                throw new IllegalArgumentException("Too few control point elements");
            }
            Geometry geometry2 = this.controlPoints;
            Intrinsics.checkNotNull((Object)geometry2);
            int n = this.controlPointIndex;
            this.controlPointIndex = n + 1;
            Geometry ctrlPtsGeom = geometry2.getGeometryN(n);
            Coordinate[] ctrlPts = ctrlPtsGeom.getCoordinates();
            int expectedNum1 = 2 * coords.length - 2;
            int expectedNum2 = isRing ? coords.length - 1 : coords.length;
            Intrinsics.checkNotNull((Object)ctrlPts);
            if (expectedNum1 != ctrlPts.length && expectedNum2 != ctrlPts.length) {
                throw new IllegalArgumentException("Wrong number of control points for element " + (this.controlPointIndex - 1) + " - expected " + expectedNum1 + " or " + expectedNum2 + ", found " + ctrlPts.length);
            }
            return ctrlPts;
        }
        return this.controlPoints(coords, isRing, this.alpha, this.skew);
    }

    private final void addCurve(Coordinate p0, Coordinate p1, Coordinate ctrl0, Coordinate crtl1, CoordinateList curvePts) {
        double len = p0.distance(p1);
        if (len < this.minSegmentLength) {
            curvePts.add(new Coordinate(p0));
        } else {
            double[][] dArray = this.interpolationParam;
            if (this.interpolationParam == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"interpolationParam");
                dArray = null;
            }
            Coordinate[] coordinateArray = this.bezierCurvePts;
            if (this.bezierCurvePts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bezierCurvePts");
                coordinateArray = null;
            }
            this.cubicBezier(p0, p1, ctrl0, crtl1, dArray, coordinateArray);
            int i = 0;
            Coordinate[] coordinateArray2 = this.bezierCurvePts;
            if (this.bezierCurvePts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bezierCurvePts");
                coordinateArray2 = null;
            }
            int n = coordinateArray2.length - 1;
            while (i < n) {
                Coordinate[] coordinateArray3 = this.bezierCurvePts;
                if (this.bezierCurvePts == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bezierCurvePts");
                    coordinateArray3 = null;
                }
                curvePts.add((Object)coordinateArray3[i], false);
                ++i;
            }
        }
    }

    private final Coordinate[] controlPoints(Coordinate[] coords, boolean isRing, double alpha, double skew) {
        int N = coords.length;
        int start = 1;
        int end = N - 1;
        if (isRing) {
            N = coords.length - 1;
            start = 0;
            end = N;
        }
        int nControl = 2 * coords.length - 2;
        Object[] ctrl = new Coordinate[nControl];
        int n = end;
        for (int i = start; i < n; ++i) {
            int iprev = i == 0 ? N - 1 : i - 1;
            Coordinate v0 = coords[iprev];
            Coordinate v1 = coords[i];
            Coordinate v2 = coords[i + 1];
            double interiorAng = Angle.INSTANCE.angleBetweenOriented(v0, v1, v2);
            double orient = Math.INSTANCE.signum(interiorAng);
            double angBisect = Angle.bisector(v0, v1, v2);
            double ang0 = angBisect - orient * 1.5707963267948966;
            double ang1 = angBisect + orient * 1.5707963267948966;
            double dist0 = v1.distance(v0);
            double dist1 = v1.distance(v2);
            double lenBase = Math.INSTANCE.min(dist0, dist1);
            double intAngAbs = Math.INSTANCE.abs(interiorAng);
            double sharpnessFactor = intAngAbs >= 1.5707963267948966 ? 1.0 : intAngAbs / 1.5707963267948966;
            double len = alpha * 0.375 * sharpnessFactor * lenBase;
            double stretch0 = 1.0;
            double stretch1 = 1.0;
            if (!(skew == 0.0)) {
                int skewIndex;
                double stretch = Math.INSTANCE.abs(dist0 - dist1) / Math.INSTANCE.max(dist0, dist1);
                int n2 = skewIndex = dist0 > dist1 ? 0 : 1;
                if (skew < 0.0) {
                    skewIndex = 1 - skewIndex;
                }
                if (skewIndex == 0) {
                    stretch0 += Math.INSTANCE.abs(skew) * stretch;
                } else {
                    stretch1 += Math.INSTANCE.abs(skew) * stretch;
                }
            }
            Coordinate ctl0 = Angle.INSTANCE.project(v1, ang0, stretch0 * len);
            Coordinate ctl1 = Angle.INSTANCE.project(v1, ang1, stretch1 * len);
            int index = 2 * i - 1;
            int i0 = index < 0 ? nControl - 1 : index;
            ctrl[i0] = ctl0;
            ctrl[index + 1] = ctl1;
        }
        if (!isRing) {
            this.setLineEndControlPoints(coords, (Coordinate[])ctrl);
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])ctrl);
    }

    private final void setLineEndControlPoints(Coordinate[] coords, Coordinate[] ctrl) {
        int N = ctrl.length;
        ctrl[0] = CubicBezierCurve.Companion.mirrorControlPoint(ctrl[1], coords[1], coords[0]);
        ctrl[N - 1] = CubicBezierCurve.Companion.mirrorControlPoint(ctrl[N - 2], coords[coords.length - 1], coords[coords.length - 2]);
    }

    private final void cubicBezier(Coordinate p0, Coordinate p1, Coordinate ctrl1, Coordinate ctrl2, double[][] param, Coordinate[] curve2) {
        int n = curve2.length;
        curve2[0] = new Coordinate(p0);
        curve2[n - 1] = new Coordinate(p1);
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            Coordinate c = new Coordinate();
            double sum = param[i][0] + param[i][1] + param[i][2] + param[i][3];
            double d = param[i][0] * p0.x;
            double d2 = param[i][1];
            Coordinate coordinate = ctrl1;
            Intrinsics.checkNotNull((Object)coordinate);
            double d3 = d + d2 * coordinate.x;
            double d4 = param[i][2];
            Coordinate coordinate2 = ctrl2;
            Intrinsics.checkNotNull((Object)coordinate2);
            c.x = d3 + d4 * coordinate2.x + param[i][3] * p1.x;
            c.x /= sum;
            c.y = param[i][0] * p0.y + param[i][1] * ctrl1.y + param[i][2] * ctrl2.y + param[i][3] * p1.y;
            c.y /= sum;
            curve2[i] = c;
        }
    }

    @JvmStatic
    @NotNull
    public static final Geometry bezierCurve(@NotNull Geometry geom, double alpha) {
        return Companion.bezierCurve(geom, alpha);
    }

    @JvmStatic
    @NotNull
    public static final Geometry bezierCurve(@NotNull Geometry geom, @Nullable Geometry controlPoints) {
        return Companion.bezierCurve(geom, controlPoints);
    }

    public static final /* synthetic */ LineString access$bezierLine(CubicBezierCurve $this, LineString ls) {
        return $this.bezierLine(ls);
    }

    public static final /* synthetic */ Polygon access$bezierPolygon(CubicBezierCurve $this, Polygon poly) {
        return $this.bezierPolygon(poly);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\"\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\"\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/shape/CubicBezierCurve$Companion;", "", "<init>", "()V", "bezierCurve", "Lorg/locationtech/jts/geom/Geometry;", "geom", "alpha", "", "skew", "controlPoints", "CIRCLE_LEN_FACTOR", "aimedControlPoint", "Lorg/locationtech/jts/geom/Coordinate;", "c", "p1", "p0", "mirrorControlPoint", "reflectPointInLine", "p", "computeIterpolationParameters", "", "", "n", "", "(I)[[D", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry bezierCurve(@NotNull Geometry geom, double alpha) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            CubicBezierCurve curve2 = new CubicBezierCurve(geom, alpha);
            return curve2.getResult();
        }

        @NotNull
        public final Geometry bezierCurve(@NotNull Geometry geom, double alpha, double skew) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            CubicBezierCurve curve2 = new CubicBezierCurve(geom, alpha, skew);
            return curve2.getResult();
        }

        @JvmStatic
        @NotNull
        public final Geometry bezierCurve(@NotNull Geometry geom, @Nullable Geometry controlPoints) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            CubicBezierCurve curve2 = new CubicBezierCurve(geom, controlPoints);
            return curve2.getResult();
        }

        private final Coordinate aimedControlPoint(Coordinate c, Coordinate p1, Coordinate p0) {
            double len = p1.distance(c);
            double ang = Angle.INSTANCE.angle(p0, p1);
            return Angle.INSTANCE.project(p0, ang, len);
        }

        private final Coordinate mirrorControlPoint(Coordinate c, Coordinate p0, Coordinate p1) {
            double vlinex = p1.x - p0.x;
            double vliney = p1.y - p0.y;
            double vrotx = -vliney;
            double midx = (p0.x + p1.x) / (double)2;
            double midy = (p0.y + p1.y) / (double)2;
            return this.reflectPointInLine(c, new Coordinate(midx, midy), new Coordinate(midx + vrotx, midy + vlinex));
        }

        private final Coordinate reflectPointInLine(Coordinate p, Coordinate p0, Coordinate p1) {
            double vx = p1.x - p0.x;
            double vy = p1.y - p0.y;
            double d = p0.x;
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            double x = d - coordinate.x;
            double y = p0.y - p.y;
            double r = 1.0 / (vx * vx + vy * vy);
            double rx = p.x + (double)2 * (x - x * vx * vx * r - y * vx * vy * r);
            double ry = p.y + (double)2 * (y - y * vy * vy * r - x * vx * vy * r);
            return new Coordinate(rx, ry);
        }

        private final double[][] computeIterpolationParameters(int n) {
            int n2 = 0;
            double[][] dArrayArray = new double[n][];
            while (n2 < n) {
                int n3 = n2++;
                dArrayArray[n3] = new double[4];
            }
            double[][] param = dArrayArray;
            for (int i = 0; i < n; ++i) {
                double t = (double)i / (double)(n - 1);
                double tc = 1.0 - t;
                param[i][0] = tc * tc * tc;
                param[i][1] = 3.0 * tc * tc * t;
                param[i][2] = 3.0 * tc * t * t;
                param[i][3] = t * t * t;
            }
            return param;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

