/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u0014\u0010'\u001a\u0004\u0018\u00010(X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lorg/locationtech/jts/shape/GeometricShapeBuilder;", "", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "getGeomFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "setGeomFactory", "extent", "Lorg/locationtech/jts/geom/Envelope;", "getExtent", "()Lorg/locationtech/jts/geom/Envelope;", "setExtent", "(Lorg/locationtech/jts/geom/Envelope;)V", "numPts", "", "getNumPts", "()I", "setNumPts", "(I)V", "centre", "Lorg/locationtech/jts/geom/Coordinate;", "getCentre", "()Lorg/locationtech/jts/geom/Coordinate;", "diameter", "", "getDiameter", "()D", "radius", "getRadius", "squareBaseLine", "Lorg/locationtech/jts/geom/LineSegment;", "getSquareBaseLine", "()Lorg/locationtech/jts/geom/LineSegment;", "squareExtent", "getSquareExtent", "setNumPoints", "", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "createCoord", "x", "y", "kts-core"})
public abstract class GeometricShapeBuilder {
    @NotNull
    private GeometryFactory geomFactory;
    @NotNull
    private Envelope extent;
    private int numPts;

    public GeometricShapeBuilder(@NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        this.geomFactory = geomFactory;
        this.extent = new Envelope(0.0, 1.0, 0.0, 1.0);
    }

    @NotNull
    protected final GeometryFactory getGeomFactory() {
        return this.geomFactory;
    }

    protected final void setGeomFactory(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"<set-?>");
        this.geomFactory = geometryFactory;
    }

    @NotNull
    public final Envelope getExtent() {
        return this.extent;
    }

    public final void setExtent(@NotNull Envelope envelope) {
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"<set-?>");
        this.extent = envelope;
    }

    protected final int getNumPts() {
        return this.numPts;
    }

    protected final void setNumPts(int n) {
        this.numPts = n;
    }

    @Nullable
    public final Coordinate getCentre() {
        return this.extent.centre();
    }

    public final double getDiameter() {
        return Math.INSTANCE.min(this.extent.getHeight(), this.extent.getWidth());
    }

    public final double getRadius() {
        return this.getDiameter() / (double)2;
    }

    @NotNull
    public final LineSegment getSquareBaseLine() {
        Coordinate centre;
        double radius = this.getRadius();
        Coordinate coordinate = centre = this.getCentre();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate p0 = new Coordinate(coordinate.x - radius, centre.y - radius);
        Coordinate p1 = new Coordinate(centre.x + radius, centre.y - radius);
        return new LineSegment(p0, p1);
    }

    @NotNull
    public final Envelope getSquareExtent() {
        Coordinate centre;
        double radius = this.getRadius();
        Coordinate coordinate = centre = this.getCentre();
        Intrinsics.checkNotNull((Object)coordinate);
        return new Envelope(coordinate.x - radius, centre.x + radius, centre.y - radius, centre.y + radius);
    }

    public final void setNumPoints(int numPts) {
        this.numPts = numPts;
    }

    @Nullable
    public abstract Geometry getGeometry();

    @NotNull
    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.geomFactory.getPrecisionModel().makePrecise(pt);
        return pt;
    }
}

