/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/shape/fractal/HilbertCode;", "", "<init>", "()V", "MAX_LEVEL", "", "size", "level", "maxOrdinate", "numPoints", "checkLevel", "", "encode", "x", "y", "levelClamp", "decode", "Lorg/locationtech/jts/geom/Coordinate;", "index", "prefixScan", "", "deinterleave", "kts-core"})
public final class HilbertCode {
    @NotNull
    public static final HilbertCode INSTANCE = new HilbertCode();
    public static final int MAX_LEVEL = 16;

    private HilbertCode() {
    }

    @JvmStatic
    public static final int size(int level) {
        INSTANCE.checkLevel(level);
        return (int)Math.INSTANCE.pow(2.0, 2 * level);
    }

    public final int maxOrdinate(int level) {
        this.checkLevel(level);
        return (int)Math.INSTANCE.pow(2.0, level) - 1;
    }

    @JvmStatic
    public static final int level(int numPoints) {
        int pow2 = (int)(Math.INSTANCE.log(numPoints) / Math.INSTANCE.log(2.0));
        int level = pow2 / 2;
        int size = HilbertCode.size(level);
        if (size < numPoints) {
            ++level;
        }
        return level;
    }

    private final void checkLevel(int level) {
        if (level > 16) {
            throw new IllegalArgumentException("Level must be in range 0 to 16");
        }
    }

    @JvmStatic
    public static final int encode(int level, int x, int y) {
        int x2 = x;
        int y2 = y;
        int lvl = INSTANCE.levelClamp(level);
        long a = (x2 <<= 16 - lvl) ^ (y2 <<= 16 - lvl);
        long b = 0xFFFFL ^ a;
        long c = 0xFFFF ^ (x2 | y2);
        long d = x2 & (y2 ^ 0xFFFF);
        long A = a | b >> 1;
        long B = a >> 1 ^ a;
        long C = c >> 1 ^ b & d >> 1 ^ c;
        long D = a & c >> 1 ^ d >> 1 ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 2 ^ b & b >> 2;
        B = a & b >> 2 ^ b & (a ^ b) >> 2;
        C ^= a & c >> 2 ^ b & d >> 2;
        D ^= b & c >> 2 ^ (a ^ b) & d >> 2;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 4 ^ b & b >> 4;
        B = a & b >> 4 ^ b & (a ^ b) >> 4;
        C ^= a & c >> 4 ^ b & d >> 4;
        D ^= b & c >> 4 ^ (a ^ b) & d >> 4;
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= a & c >> 8 ^ b & d >> 8;
        D ^= b & c >> 8 ^ (a ^ b) & d >> 8;
        a = C ^ C >> 1;
        b = D ^ D >> 1;
        long i0 = x2 ^ y2;
        long i1 = b | 0xFFFFL ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FFL;
        i0 = (i0 | i0 << 4) & 0xF0F0F0FL;
        i0 = (i0 | i0 << 2) & 0x33333333L;
        i0 = (i0 | i0 << 1) & 0x55555555L;
        i1 = (i1 | i1 << 8) & 0xFF00FFL;
        i1 = (i1 | i1 << 4) & 0xF0F0F0FL;
        i1 = (i1 | i1 << 2) & 0x33333333L;
        i1 = (i1 | i1 << 1) & 0x55555555L;
        long index = (i1 << 1 | i0) >> 32 - 2 * lvl;
        return (int)index;
    }

    private final int levelClamp(int level) {
        int lvl = level < 1 ? 1 : level;
        lvl = lvl > 16 ? 16 : lvl;
        return lvl;
    }

    @JvmStatic
    @NotNull
    public static final Coordinate decode(int level, int index) {
        int index2 = index;
        INSTANCE.checkLevel(level);
        int lvl = INSTANCE.levelClamp(level);
        long i0 = INSTANCE.deinterleave(index2 <<= 32 - 2 * lvl);
        long i1 = INSTANCE.deinterleave(index2 >> 1);
        long t0 = (i0 | i1) ^ 0xFFFFL;
        long t1 = i0 & i1;
        long prefixT0 = INSTANCE.prefixScan(t0);
        long prefixT1 = INSTANCE.prefixScan(t1);
        long a = (i0 ^ 0xFFFFL) & prefixT1 | i0 & prefixT0;
        long x = (a ^ i1) >> 16 - lvl;
        long y = (a ^ i0 ^ i1) >> 16 - lvl;
        return new Coordinate(x, y);
    }

    private final long prefixScan(long x) {
        long x2 = x;
        x2 = x2 >> 8 ^ x2;
        x2 = x2 >> 4 ^ x2;
        x2 = x2 >> 2 ^ x2;
        x2 = x2 >> 1 ^ x2;
        return x2;
    }

    private final long deinterleave(int x) {
        int x2 = x;
        x2 &= 0x55555555;
        x2 = (x2 | x2 >> 1) & 0x33333333;
        x2 = (x2 | x2 >> 2) & 0xF0F0F0F;
        x2 = (x2 | x2 >> 4) & 0xFF00FF;
        x2 = (x2 | x2 >> 8) & 0xFFFF;
        return x2;
    }
}

