/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.shape.GeometricShapeBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/shape/fractal/SierpinskiCarpetBuilder;", "Lorg/locationtech/jts/shape/GeometricShapeBuilder;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "getHoles", "", "Lorg/locationtech/jts/geom/LinearRing;", "n", "", "originX", "", "originY", "width", "(IDDD)[Lorg/locationtech/jts/geom/LinearRing;", "addHoles", "", "holeList", "", "createSquareHole", "x", "y", "Companion", "kts-core"})
public final class SierpinskiCarpetBuilder
extends GeometricShapeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SierpinskiCarpetBuilder(@NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        super(geomFactory);
    }

    @Override
    @NotNull
    public Geometry getGeometry() {
        int level = Companion.recursionLevelForSize(this.getNumPts());
        LineSegment baseLine = this.getSquareBaseLine();
        Coordinate origin = baseLine.getCoordinate(0);
        LinearRing[] holes = this.getHoles(level, origin.x, origin.y, this.getDiameter());
        Geometry geometry = this.getGeomFactory().toGeometry(this.getSquareExtent());
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        LinearRing shell = ((Polygon)geometry).getExteriorRing();
        return this.getGeomFactory().createPolygon(shell, holes);
    }

    private final LinearRing[] getHoles(int n, double originX, double originY, double width) {
        List holeList = new ArrayList();
        this.addHoles(n, originX, originY, width, holeList);
        return GeometryFactory.Companion.toLinearRingArray(holeList);
    }

    private final void addHoles(int n, double originX, double originY, double width, List<LinearRing> holeList) {
        if (n < 0) {
            return;
        }
        int n2 = n - 1;
        double widthThird = width / 3.0;
        this.addHoles(n2, originX, originY, widthThird, holeList);
        this.addHoles(n2, originX + widthThird, originY, widthThird, holeList);
        this.addHoles(n2, originX + (double)2 * widthThird, originY, widthThird, holeList);
        this.addHoles(n2, originX, originY + widthThird, widthThird, holeList);
        this.addHoles(n2, originX + (double)2 * widthThird, originY + widthThird, widthThird, holeList);
        this.addHoles(n2, originX, originY + (double)2 * widthThird, widthThird, holeList);
        this.addHoles(n2, originX + widthThird, originY + (double)2 * widthThird, widthThird, holeList);
        this.addHoles(n2, originX + (double)2 * widthThird, originY + (double)2 * widthThird, widthThird, holeList);
        holeList.add(this.createSquareHole(originX + widthThird, originY + widthThird, widthThird));
    }

    private final LinearRing createSquareHole(double x, double y, double width) {
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(x, y), new Coordinate(x + width, y), new Coordinate(x + width, y + width), new Coordinate(x, y + width), new Coordinate(x, y)};
        Coordinate[] pts = coordinateArray;
        return this.getGeomFactory().createLinearRing(pts);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/shape/fractal/SierpinskiCarpetBuilder$Companion;", "", "<init>", "()V", "recursionLevelForSize", "", "numPts", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int recursionLevelForSize(int numPts) {
            double pow4 = numPts / 3;
            double exp = Math.INSTANCE.log(pow4) / Math.INSTANCE.log(4.0);
            return (int)exp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

